/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class ListUnspentTransactionOutputsByAddressRI {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_INDEX = "index";
    @SerializedName(value="index")
    private Integer index;
    public static final String SERIALIZED_NAME_IS_CONFIRMED = "isConfirmed";
    @SerializedName(value="isConfirmed")
    private Boolean isConfirmed;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Integer timestamp;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ListUnspentTransactionOutputsByAddressRI address(String address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2N5PcdirZUzKF9bWuGdugNuzcQrCbBudxv1", required=true, value="Represents the address that has unspend funds per which the result is returned.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public ListUnspentTransactionOutputsByAddressRI amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0.00873472", required=true, value="Represents the sent/received amount.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public ListUnspentTransactionOutputsByAddressRI index(Integer index) {
        this.index = index;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Represents the index position of the transaction in the block.")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public ListUnspentTransactionOutputsByAddressRI isConfirmed(Boolean isConfirmed) {
        this.isConfirmed = isConfirmed;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Represents the state of the transaction whether it is confirmed or not confirmed.")
    public Boolean getIsConfirmed() {
        return this.isConfirmed;
    }

    public void setIsConfirmed(Boolean isConfirmed) {
        this.isConfirmed = isConfirmed;
    }

    public ListUnspentTransactionOutputsByAddressRI timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1622466746", required=true, value="Defines the exact date/time in Unix Timestamp when this transaction was mined, confirmed or first seen in Mempool, if it is unconfirmed.")
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public ListUnspentTransactionOutputsByAddressRI transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="4b66461bf88b61e1e4326356534c135129defb504c7acb2fd6c92697d79eb250", required=true, value="Represents the unique identifier of a transaction, i.e. it could be `transactionId` in UTXO-based protocols like Bitcoin, and transaction `hash` in Ethereum blockchain.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListUnspentTransactionOutputsByAddressRI listUnspentTransactionOutputsByAddressRI = (ListUnspentTransactionOutputsByAddressRI)o;
        return Objects.equals(this.address, listUnspentTransactionOutputsByAddressRI.address) && Objects.equals(this.amount, listUnspentTransactionOutputsByAddressRI.amount) && Objects.equals(this.index, listUnspentTransactionOutputsByAddressRI.index) && Objects.equals(this.isConfirmed, listUnspentTransactionOutputsByAddressRI.isConfirmed) && Objects.equals(this.timestamp, listUnspentTransactionOutputsByAddressRI.timestamp) && Objects.equals(this.transactionId, listUnspentTransactionOutputsByAddressRI.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.amount, this.index, this.isConfirmed, this.timestamp, this.transactionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListUnspentTransactionOutputsByAddressRI {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    isConfirmed: ").append(this.toIndentedString(this.isConfirmed)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ListUnspentTransactionOutputsByAddressRI is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ListUnspentTransactionOutputsByAddressRI` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).toString()));
        }
    }

    public static ListUnspentTransactionOutputsByAddressRI fromJson(String jsonString) throws IOException {
        return (ListUnspentTransactionOutputsByAddressRI)JSON.getGson().fromJson(jsonString, ListUnspentTransactionOutputsByAddressRI.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_INDEX);
        openapiFields.add(SERIALIZED_NAME_IS_CONFIRMED);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_INDEX);
        openapiRequiredFields.add(SERIALIZED_NAME_IS_CONFIRMED);
        openapiRequiredFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ListUnspentTransactionOutputsByAddressRI.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ListUnspentTransactionOutputsByAddressRI.class));
            return new TypeAdapter<ListUnspentTransactionOutputsByAddressRI>(){

                public void write(JsonWriter out, ListUnspentTransactionOutputsByAddressRI value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ListUnspentTransactionOutputsByAddressRI read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ListUnspentTransactionOutputsByAddressRI.validateJsonObject(jsonObj);
                    return (ListUnspentTransactionOutputsByAddressRI)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

