/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;
import org.openapitools.client.model.AbstractOpenApiSchema;
import org.openapitools.client.model.AlreadyExists;
import org.openapitools.client.model.InvalidData;

public class NewUnconfirmedCoinsTransactionsE409
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(NewUnconfirmedCoinsTransactionsE409.class.getName());
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public NewUnconfirmedCoinsTransactionsE409() {
        super("oneOf", Boolean.FALSE);
    }

    public NewUnconfirmedCoinsTransactionsE409(AlreadyExists o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public NewUnconfirmedCoinsTransactionsE409(InvalidData o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof AlreadyExists) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof InvalidData) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be AlreadyExists, InvalidData");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public AlreadyExists getAlreadyExists() throws ClassCastException {
        return (AlreadyExists)super.getActualInstance();
    }

    public InvalidData getInvalidData() throws ClassCastException {
        return (InvalidData)super.getActualInstance();
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            AlreadyExists.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for AlreadyExists failed with `%s`.", e.getMessage()));
        }
        try {
            InvalidData.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for InvalidData failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for NewUnconfirmedCoinsTransactionsE409 with oneOf schemas: AlreadyExists, InvalidData. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonObj.toString()));
        }
    }

    public static NewUnconfirmedCoinsTransactionsE409 fromJson(String jsonString) throws IOException {
        return (NewUnconfirmedCoinsTransactionsE409)JSON.getGson().fromJson(jsonString, NewUnconfirmedCoinsTransactionsE409.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("AlreadyExists", (GenericType)new GenericType<AlreadyExists>(){});
        schemas.put("InvalidData", (GenericType)new GenericType<InvalidData>(){});
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NewUnconfirmedCoinsTransactionsE409.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterAlreadyExists = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlreadyExists.class));
            final TypeAdapter adapterInvalidData = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InvalidData.class));
            return new TypeAdapter<NewUnconfirmedCoinsTransactionsE409>(){

                public void write(JsonWriter out, NewUnconfirmedCoinsTransactionsE409 value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof AlreadyExists) {
                        JsonObject obj = adapterAlreadyExists.toJsonTree((Object)((AlreadyExists)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    if (value.getActualInstance() instanceof InvalidData) {
                        JsonObject obj = adapterInvalidData.toJsonTree((Object)((InvalidData)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: AlreadyExists, InvalidData");
                }

                public NewUnconfirmedCoinsTransactionsE409 read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonObject jsonObject = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        AlreadyExists.validateJsonObject(jsonObject);
                        actualAdapter = adapterAlreadyExists;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'AlreadyExists'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for AlreadyExists failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'AlreadyExists'", e);
                    }
                    try {
                        InvalidData.validateJsonObject(jsonObject);
                        actualAdapter = adapterInvalidData;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'InvalidData'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for InvalidData failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'InvalidData'", e);
                    }
                    if (match == 1) {
                        NewUnconfirmedCoinsTransactionsE409 ret = new NewUnconfirmedCoinsTransactionsE409();
                        ret.setActualInstance(actualAdapter.fromJsonTree((JsonElement)jsonObject));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for NewUnconfirmedCoinsTransactionsE409: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonObject.toString()));
                }
            }.nullSafe();
        }
    }
}

