/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openapitools.client.model.TokensForwardingFailDataItem;

@ApiModel(description="Specifies all data, as attributes, included into the callback notification, which depends on the `event`.")
public class TokensForwardingFailData {
    public static final String SERIALIZED_NAME_PRODUCT = "product";
    @SerializedName(value="product")
    private String product;
    public static final String SERIALIZED_NAME_EVENT = "event";
    @SerializedName(value="event")
    private String event;
    public static final String SERIALIZED_NAME_ITEM = "item";
    @SerializedName(value="item")
    private TokensForwardingFailDataItem item;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TokensForwardingFailData product(String product) {
        this.product = product;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="BLOCKCHAIN_AUTOMATIONS", required=true, value="Represents the Crypto APIs 2.0 product which sends the callback.")
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public TokensForwardingFailData event(String event) {
        this.event = event;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="TOKENS_FORWARDING_FAIL", required=true, value="Defines the specific event, for which a callback subscription is set.")
    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public TokensForwardingFailData item(TokensForwardingFailDataItem item) {
        this.item = item;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public TokensForwardingFailDataItem getItem() {
        return this.item;
    }

    public void setItem(TokensForwardingFailDataItem item) {
        this.item = item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokensForwardingFailData tokensForwardingFailData = (TokensForwardingFailData)o;
        return Objects.equals(this.product, tokensForwardingFailData.product) && Objects.equals(this.event, tokensForwardingFailData.event) && Objects.equals(this.item, tokensForwardingFailData.item);
    }

    public int hashCode() {
        return Objects.hash(this.product, this.event, this.item);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokensForwardingFailData {\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TokensForwardingFailData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TokensForwardingFailData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRODUCT) != null && !jsonObj.get(SERIALIZED_NAME_PRODUCT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `product` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRODUCT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EVENT) != null && !jsonObj.get(SERIALIZED_NAME_EVENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `event` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ITEM) != null) {
            TokensForwardingFailDataItem.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ITEM));
        }
    }

    public static TokensForwardingFailData fromJson(String jsonString) throws IOException {
        return (TokensForwardingFailData)JSON.getGson().fromJson(jsonString, TokensForwardingFailData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PRODUCT);
        openapiFields.add(SERIALIZED_NAME_EVENT);
        openapiFields.add(SERIALIZED_NAME_ITEM);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PRODUCT);
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT);
        openapiRequiredFields.add(SERIALIZED_NAME_ITEM);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TokensForwardingFailData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TokensForwardingFailData.class));
            return new TypeAdapter<TokensForwardingFailData>(){

                public void write(JsonWriter out, TokensForwardingFailData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TokensForwardingFailData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TokensForwardingFailData.validateJsonObject(jsonObj);
                    return (TokensForwardingFailData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

