/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openapitools.client.model.TransactionMinedDataItemMinedInBlock;

@ApiModel(description="Defines an `item` as one result.")
public class TransactionMinedDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_MINED_IN_BLOCK = "minedInBlock";
    @SerializedName(value="minedInBlock")
    private TransactionMinedDataItemMinedInBlock minedInBlock;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TransactionMinedDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public TransactionMinedDataItem network(String network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public TransactionMinedDataItem transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="e6439461e5bf8920e75740896d4b47730b844837295e8c3f2dbf441542aebcb6", required=true, value="Defines the unique ID of the specific transaction, i.e. its identification number.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransactionMinedDataItem minedInBlock(TransactionMinedDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public TransactionMinedDataItemMinedInBlock getMinedInBlock() {
        return this.minedInBlock;
    }

    public void setMinedInBlock(TransactionMinedDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionMinedDataItem transactionMinedDataItem = (TransactionMinedDataItem)o;
        return Objects.equals(this.blockchain, transactionMinedDataItem.blockchain) && Objects.equals(this.network, transactionMinedDataItem.network) && Objects.equals(this.transactionId, transactionMinedDataItem.transactionId) && Objects.equals(this.minedInBlock, transactionMinedDataItem.minedInBlock);
    }

    public int hashCode() {
        return Objects.hash(this.blockchain, this.network, this.transactionId, this.minedInBlock);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionMinedDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    minedInBlock: ").append(this.toIndentedString(this.minedInBlock)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransactionMinedDataItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransactionMinedDataItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockchain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MINED_IN_BLOCK) != null) {
            TransactionMinedDataItemMinedInBlock.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MINED_IN_BLOCK));
        }
    }

    public static TransactionMinedDataItem fromJson(String jsonString) throws IOException {
        return (TransactionMinedDataItem)JSON.getGson().fromJson(jsonString, TransactionMinedDataItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_MINED_IN_BLOCK);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_MINED_IN_BLOCK);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransactionMinedDataItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransactionMinedDataItem.class));
            return new TypeAdapter<TransactionMinedDataItem>(){

                public void write(JsonWriter out, TransactionMinedDataItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransactionMinedDataItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransactionMinedDataItem.validateJsonObject(jsonObj);
                    return (TransactionMinedDataItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

