/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@ApiModel(description="Defines an `item` as one result.")
public class TransactionRequestRejectionDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_REQUIRED_APPROVALS = "requiredApprovals";
    @SerializedName(value="requiredApprovals")
    private Integer requiredApprovals;
    public static final String SERIALIZED_NAME_REQUIRED_REJECTIONS = "requiredRejections";
    @SerializedName(value="requiredRejections")
    private Integer requiredRejections;
    public static final String SERIALIZED_NAME_CURRENT_APPROVALS = "currentApprovals";
    @SerializedName(value="currentApprovals")
    private Integer currentApprovals;
    public static final String SERIALIZED_NAME_CURRENT_REJECTIONS = "currentRejections";
    @SerializedName(value="currentRejections")
    private Integer currentRejections;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TransactionRequestRejectionDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ethereum", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public TransactionRequestRejectionDataItem network(String network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ropsten", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public TransactionRequestRejectionDataItem requiredApprovals(Integer requiredApprovals) {
        this.requiredApprovals = requiredApprovals;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2", required=true, value="The required number of approvals needed to approve the transaction.")
    public Integer getRequiredApprovals() {
        return this.requiredApprovals;
    }

    public void setRequiredApprovals(Integer requiredApprovals) {
        this.requiredApprovals = requiredApprovals;
    }

    public TransactionRequestRejectionDataItem requiredRejections(Integer requiredRejections) {
        this.requiredRejections = requiredRejections;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2", required=true, value="The required number of rejections needed to reject the transaction.")
    public Integer getRequiredRejections() {
        return this.requiredRejections;
    }

    public void setRequiredRejections(Integer requiredRejections) {
        this.requiredRejections = requiredRejections;
    }

    public TransactionRequestRejectionDataItem currentApprovals(Integer currentApprovals) {
        this.currentApprovals = currentApprovals;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0", required=true, value="The current number of approvals given for the transaction.")
    public Integer getCurrentApprovals() {
        return this.currentApprovals;
    }

    public void setCurrentApprovals(Integer currentApprovals) {
        this.currentApprovals = currentApprovals;
    }

    public TransactionRequestRejectionDataItem currentRejections(Integer currentRejections) {
        this.currentRejections = currentRejections;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2", required=true, value="The current number of rejections given for the transaction.")
    public Integer getCurrentRejections() {
        return this.currentRejections;
    }

    public void setCurrentRejections(Integer currentRejections) {
        this.currentRejections = currentRejections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionRequestRejectionDataItem transactionRequestRejectionDataItem = (TransactionRequestRejectionDataItem)o;
        return Objects.equals(this.blockchain, transactionRequestRejectionDataItem.blockchain) && Objects.equals(this.network, transactionRequestRejectionDataItem.network) && Objects.equals(this.requiredApprovals, transactionRequestRejectionDataItem.requiredApprovals) && Objects.equals(this.requiredRejections, transactionRequestRejectionDataItem.requiredRejections) && Objects.equals(this.currentApprovals, transactionRequestRejectionDataItem.currentApprovals) && Objects.equals(this.currentRejections, transactionRequestRejectionDataItem.currentRejections);
    }

    public int hashCode() {
        return Objects.hash(this.blockchain, this.network, this.requiredApprovals, this.requiredRejections, this.currentApprovals, this.currentRejections);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionRequestRejectionDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    requiredApprovals: ").append(this.toIndentedString(this.requiredApprovals)).append("\n");
        sb.append("    requiredRejections: ").append(this.toIndentedString(this.requiredRejections)).append("\n");
        sb.append("    currentApprovals: ").append(this.toIndentedString(this.currentApprovals)).append("\n");
        sb.append("    currentRejections: ").append(this.toIndentedString(this.currentRejections)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransactionRequestRejectionDataItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransactionRequestRejectionDataItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockchain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK).toString()));
        }
    }

    public static TransactionRequestRejectionDataItem fromJson(String jsonString) throws IOException {
        return (TransactionRequestRejectionDataItem)JSON.getGson().fromJson(jsonString, TransactionRequestRejectionDataItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_REQUIRED_APPROVALS);
        openapiFields.add(SERIALIZED_NAME_REQUIRED_REJECTIONS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_APPROVALS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_REJECTIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_REQUIRED_APPROVALS);
        openapiRequiredFields.add(SERIALIZED_NAME_REQUIRED_REJECTIONS);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENT_APPROVALS);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENT_REJECTIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransactionRequestRejectionDataItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransactionRequestRejectionDataItem.class));
            return new TypeAdapter<TransactionRequestRejectionDataItem>(){

                public void write(JsonWriter out, TransactionRequestRejectionDataItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransactionRequestRejectionDataItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransactionRequestRejectionDataItem.validateJsonObject(jsonObj);
                    return (TransactionRequestRejectionDataItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

