/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.FeatureWithLines;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class RerunPath {
    private static final Pattern RERUN_PATH_SPECIFICATION = Pattern.compile("(?m:^| |)(.*?\\.feature(?:(?::\\d+)*))");

    RerunPath() {
    }

    static Collection<FeatureWithLines> parse(Path rerunFileOrDirectory) {
        return RerunPath.listRerunFiles(rerunFileOrDirectory).stream().map(RerunPath::parseFeatureWithLinesFile).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<Path> listRerunFiles(Path path) {
        try {
            class FileCollector
            extends SimpleFileVisitor<Path> {
                final Set<Path> paths = new HashSet<Path>();

                FileCollector() {
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (!Files.isDirectory(file, new LinkOption[0])) {
                        this.paths.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            }
            FileCollector collector = new FileCollector();
            Files.walkFileTree(path, collector);
            return collector.paths;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static Collection<FeatureWithLines> parseFeatureWithLinesFile(Path path) {
        try {
            ArrayList<FeatureWithLines> featurePaths = new ArrayList<FeatureWithLines>();
            Files.readAllLines(path).forEach(line -> {
                Matcher matcher = RERUN_PATH_SPECIFICATION.matcher((CharSequence)line);
                while (matcher.find()) {
                    featurePaths.add(FeatureWithLines.parse(matcher.group(1)));
                }
            });
            return featurePaths;
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to parse '%s'", path), e);
        }
    }
}

