/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Transaction;
import io.delta.kernel.TransactionBuilder;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableFeatures;
import io.delta.kernel.internal.TableImpl;
import io.delta.kernel.internal.TransactionImpl;
import io.delta.kernel.internal.actions.Format;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.SnapshotHint;
import io.delta.kernel.internal.util.SchemaUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBuilderImpl
implements TransactionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TransactionBuilderImpl.class);
    private final long currentTimeMillis = System.currentTimeMillis();
    private final TableImpl table;
    private final String engineInfo;
    private final Operation operation;
    private Optional<StructType> schema = Optional.empty();
    private Optional<List<String>> partitionColumns = Optional.empty();
    private Optional<SetTransaction> setTxnOpt = Optional.empty();

    public TransactionBuilderImpl(TableImpl tableImpl, String string, Operation operation) {
        this.table = tableImpl;
        this.engineInfo = string;
        this.operation = operation;
    }

    @Override
    public TransactionBuilder withSchema(Engine engine, StructType structType) {
        this.schema = Optional.of(structType);
        return this;
    }

    @Override
    public TransactionBuilder withPartitionColumns(Engine engine, List<String> list) {
        if (!list.isEmpty()) {
            this.partitionColumns = Optional.of(list);
        }
        return this;
    }

    @Override
    public TransactionBuilder withTransactionId(Engine engine, String string, long l) {
        SetTransaction setTransaction = new SetTransaction(Objects.requireNonNull(string, "applicationId is null"), l, Optional.of(this.currentTimeMillis));
        this.setTxnOpt = Optional.of(setTransaction);
        return this;
    }

    @Override
    public Transaction build(Engine engine) {
        SnapshotImpl snapshotImpl;
        try {
            snapshotImpl = (SnapshotImpl)this.table.getLatestSnapshot(engine);
        }
        catch (TableNotFoundException tableNotFoundException) {
            String string = this.table.getPath(engine);
            logger.info("Table {} doesn't exist yet. Trying to create a new table.", (Object)string);
            this.schema.orElseThrow(() -> DeltaErrors.requiresSchemaForNewTable(string));
            Metadata metadata = this.getInitialMetadata();
            Protocol protocol = this.getInitialProtocol();
            LogReplay logReplay = this.getEmptyLogReplay(engine, metadata, protocol);
            snapshotImpl = new InitialSnapshot(this.table.getDataPath(), logReplay, metadata, protocol);
        }
        boolean bl = snapshotImpl.getVersion(engine) < 0L;
        this.validate(engine, snapshotImpl, bl);
        return new TransactionImpl(bl, this.table.getDataPath(), this.table.getLogPath(), snapshotImpl, this.engineInfo, this.operation, snapshotImpl.getProtocol(), snapshotImpl.getMetadata(), this.setTxnOpt);
    }

    private void validate(Engine engine, SnapshotImpl snapshotImpl, boolean bl) {
        String string = this.table.getPath(engine);
        TableFeatures.validateWriteSupportedTable(snapshotImpl.getProtocol(), snapshotImpl.getMetadata(), snapshotImpl.getMetadata().getSchema(), string);
        if (!bl) {
            if (this.schema.isPresent()) {
                throw DeltaErrors.tableAlreadyExists(string, "Table already exists, but provided a new schema. Schema can only be set on a new table.");
            }
            if (this.partitionColumns.isPresent()) {
                throw DeltaErrors.tableAlreadyExists(string, "Table already exists, but provided new partition columns. Partition columns can only be set on a new table.");
            }
        } else {
            SchemaUtils.validateSchema(this.schema.get(), false);
            SchemaUtils.validatePartitionColumns(this.schema.get(), this.partitionColumns.orElse(Collections.emptyList()));
        }
        this.setTxnOpt.ifPresent(setTransaction -> {
            Optional<Long> optional = snapshotImpl.getLatestTransactionVersion(setTransaction.getAppId());
            if (optional.isPresent() && optional.get() >= setTransaction.getVersion()) {
                throw DeltaErrors.concurrentTransaction(setTransaction.getAppId(), setTransaction.getVersion(), optional.get());
            }
        });
    }

    private LogReplay getEmptyLogReplay(Engine engine, final Metadata metadata, final Protocol protocol) {
        return new LogReplay(this.table.getLogPath(), this.table.getDataPath(), -1L, engine, LogSegment.empty(this.table.getLogPath()), Optional.empty()){

            @Override
            protected Tuple2<Protocol, Metadata> loadTableProtocolAndMetadata(Optional<SnapshotHint> optional, long l) {
                return new Tuple2<Protocol, Metadata>(protocol, metadata);
            }

            @Override
            public Optional<Long> getLatestTransactionIdentifier(String string) {
                return Optional.empty();
            }
        };
    }

    private Metadata getInitialMetadata() {
        List<String> list = SchemaUtils.casePreservingPartitionColNames(this.schema.get(), this.partitionColumns.orElse(Collections.emptyList()));
        return new Metadata(UUID.randomUUID().toString(), Optional.empty(), Optional.empty(), new Format(), this.schema.get().toJson(), this.schema.get(), VectorUtils.stringArrayValue(list), Optional.of(this.currentTimeMillis), VectorUtils.stringStringMapValue(Collections.emptyMap()));
    }

    private Protocol getInitialProtocol() {
        return new Protocol(1, 2, null, null);
    }

    private class InitialSnapshot
    extends SnapshotImpl {
        InitialSnapshot(Path path, LogReplay logReplay, Metadata metadata, Protocol protocol) {
            super(path, LogSegment.empty(TransactionBuilderImpl.this.table.getLogPath()), logReplay, protocol, metadata);
        }
    }
}

