/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.types.DataType;
import java.util.Objects;

@Evolving
public class ArrayType
extends DataType {
    private final DataType elementType;
    private final boolean containsNull;

    public ArrayType(DataType dataType, boolean bl) {
        this.elementType = dataType;
        this.containsNull = bl;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    @Override
    public boolean equivalent(DataType dataType) {
        return dataType instanceof ArrayType && ((ArrayType)dataType).getElementType().equivalent(this.elementType);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ArrayType arrayType = (ArrayType)object;
        return this.containsNull == arrayType.containsNull && Objects.equals(this.elementType, arrayType.elementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.elementType, this.containsNull);
    }

    @Override
    public String toJson() {
        return String.format("{\"type\": \"array\",\"elementType\": %s,\"containsNull\": %s}", this.elementType.toJson(), this.containsNull);
    }

    @Override
    public String toString() {
        return "array[" + this.elementType + "]";
    }
}

