/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeletionVectorsPreDowngradeCommand;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.FeatureAutomaticallyEnabledByMetadata;
import org.apache.spark.sql.delta.PreDowngradeTableFeatureCommand;
import org.apache.spark.sql.delta.ReaderWriterFeature;
import org.apache.spark.sql.delta.RemovableFeature;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import scala.Function0;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class DeletionVectorsTableFeature$
extends ReaderWriterFeature
implements RemovableFeature,
FeatureAutomaticallyEnabledByMetadata {
    public static final DeletionVectorsTableFeature$ MODULE$ = new DeletionVectorsTableFeature$();

    static {
        RemovableFeature.$init$(MODULE$);
        FeatureAutomaticallyEnabledByMetadata.$init$(MODULE$);
    }

    @Override
    public boolean requiresHistoryProtection() {
        return RemovableFeature.requiresHistoryProtection$(this);
    }

    @Override
    public boolean historyContainsFeature(SparkSession spark, Snapshot downgradeTxnReadSnapshot) {
        return RemovableFeature.historyContainsFeature$(this, spark, downgradeTxnReadSnapshot);
    }

    @Override
    public boolean automaticallyUpdateProtocolOfExistingTables() {
        return true;
    }

    @Override
    public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata, SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_DELETION_VECTORS_CREATION().fromMetaData(metadata));
    }

    @Override
    public boolean validateRemoval(Snapshot snapshot) {
        boolean dvsWritable = DeletionVectorUtils$.MODULE$.deletionVectorsWritable(snapshot, DeletionVectorUtils$.MODULE$.deletionVectorsWritable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsWritable$default$3());
        boolean dvsExist = BoxesRunTime.unboxToLong((Object)snapshot.numDeletionVectorsOpt().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) > 0L;
        return !dvsWritable && !dvsExist;
    }

    @Override
    public boolean actionUsesFeature(Action action) {
        Action action2 = action;
        if (action2 instanceof Metadata) {
            Metadata metadata = (Metadata)action2;
            return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_DELETION_VECTORS_CREATION().fromMetaData(metadata));
        }
        if (action2 instanceof AddFile) {
            AddFile addFile = (AddFile)action2;
            return addFile.deletionVector() != null;
        }
        if (action2 instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)action2;
            return removeFile.deletionVector() != null;
        }
        if (action2 instanceof AddCDCFile) {
            AddCDCFile addCDCFile = (AddCDCFile)action2;
            return addCDCFile.deletionVector() != null;
        }
        return false;
    }

    @Override
    public PreDowngradeTableFeatureCommand preDowngradeCommand(DeltaTableV2 table) {
        return new DeletionVectorsPreDowngradeCommand(table);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeletionVectorsTableFeature$.class);
    }

    private DeletionVectorsTableFeature$() {
        super("deletionVectors");
    }
}

