/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.LogSegment;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.UninitializedCheckpointProvider;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class SnapshotManagement$
implements DeltaLogging {
    public static final SnapshotManagement$ MODULE$ = new SnapshotManagement$();
    private static DeltaThreadPool checkpointV2ThreadPool;
    private static DeltaThreadPool deltaLogAsyncUpdateThreadPool;
    private static DeltaThreadPool org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public scala.collection.immutable.Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private DeltaThreadPool checkpointV2ThreadPool$lzycompute() {
        SnapshotManagement$ snapshotManagement$ = this;
        synchronized (snapshotManagement$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                int numThreads = BoxesRunTime.unboxToInt((Object)SparkSession$.MODULE$.active().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.CHECKPOINT_V2_DRIVER_THREADPOOL_PARALLELISM()));
                checkpointV2ThreadPool = DeltaThreadPool$.MODULE$.apply("checkpointV2-threadpool", numThreads);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return checkpointV2ThreadPool;
    }

    public DeltaThreadPool checkpointV2ThreadPool() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.checkpointV2ThreadPool$lzycompute();
        }
        return checkpointV2ThreadPool;
    }

    private DeltaThreadPool deltaLogAsyncUpdateThreadPool$lzycompute() {
        SnapshotManagement$ snapshotManagement$ = this;
        synchronized (snapshotManagement$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                ThreadPoolExecutor tpe = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("delta-state-update", 8, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
                deltaLogAsyncUpdateThreadPool = new DeltaThreadPool(tpe);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return deltaLogAsyncUpdateThreadPool;
    }

    public DeltaThreadPool deltaLogAsyncUpdateThreadPool() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.deltaLogAsyncUpdateThreadPool$lzycompute();
        }
        return deltaLogAsyncUpdateThreadPool;
    }

    private DeltaThreadPool commitCoordinatorGetCommitsThreadPool$lzycompute() {
        SnapshotManagement$ snapshotManagement$ = this;
        synchronized (snapshotManagement$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                int numThreads = BoxesRunTime.unboxToInt((Object)SparkSession$.MODULE$.active().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.COORDINATED_COMMITS_GET_COMMITS_THREAD_POOL_SIZE()));
                ThreadPoolExecutor tpe = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("commit-coordinator-get-commits", numThreads, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
                org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool = new DeltaThreadPool(tpe);
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool;
    }

    public DeltaThreadPool org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.commitCoordinatorGetCommitsThreadPool$lzycompute();
        }
        return org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool;
    }

    public void verifyDeltaVersions(SparkSession spark, long[] versions, Option<Object> expectedStartVersion, Option<Object> expectedEndVersion, Option<Snapshot> cachedSnapshot) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(versions))) {
            Vector deltaVersions = Predef$.MODULE$.wrapLongArray(versions).toVector();
            NumericRange.Inclusive inclusive = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)deltaVersions.head()))).to(deltaVersions.last());
            Vector vector = deltaVersions;
            if (inclusive == null ? vector != null : !inclusive.equals(vector)) {
                Option snapshot = cachedSnapshot.filter((Function1 & Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement$.$anonfun$verifyDeltaVersions$1(x$55)));
                Object x$1 = null;
                String x$2 = "delta.exceptions.deltaVersionsNotContiguous";
                scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stackTrace"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()))).mkString("\n\t")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startVersion"), deltaVersions.head()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endVersion"), deltaVersions.last()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versionToLoad"), expectedEndVersion.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsafeVolatileSnapshot.latestCheckpointVersion"), snapshot.map((Function1 & Serializable)x$56 -> BoxesRunTime.boxToLong((long)SnapshotManagement$.$anonfun$verifyDeltaVersions$3(x$56))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsafeVolatileSnapshot.latestSnapshotVersion"), snapshot.map((Function1 & Serializable)x$57 -> BoxesRunTime.boxToLong((long)x$57.version())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsafeVolatileSnapshot.checksumOpt"), snapshot.map((Function1 & Serializable)x$58 -> x$58.checksumOpt()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))}));
                scala.collection.immutable.Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                Option<Path> x$5 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(null, "delta.exceptions.deltaVersionsNotContiguous", x$4, x$3, x$5);
                throw DeltaErrors$.MODULE$.deltaVersionsNotContiguousException(spark, (Seq<Object>)deltaVersions, BoxesRunTime.unboxToLong((Object)deltaVersions.head()), BoxesRunTime.unboxToLong((Object)deltaVersions.last()), BoxesRunTime.unboxToLong((Object)expectedEndVersion.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
            }
        }
        expectedStartVersion.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)v -> Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(versions)) && BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.longArrayOps(versions))) == v, (Function0 & Serializable)() -> new StringBuilder(62).append("Did not get the first delta ").append("file version: ").append(v).append(" to compute Snapshot").toString()));
        expectedEndVersion.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)v -> Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(versions)) && BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.longArrayOps(versions))) == v, (Function0 & Serializable)() -> new StringBuilder(61).append("Did not get the last delta ").append("file version: ").append(v).append(" to compute Snapshot").toString()));
    }

    public LogSegment appendCommitToLogSegment(LogSegment oldLogSegment, FileStatus commitFileStatus, long committedVersion) {
        Predef$.MODULE$.require(oldLogSegment.version() + 1L == committedVersion);
        long x$1 = committedVersion;
        Seq x$2 = (Seq)oldLogSegment.deltas().$colon$plus((Object)commitFileStatus);
        long x$3 = commitFileStatus.getModificationTime();
        Path x$4 = oldLogSegment.copy$default$1();
        UninitializedCheckpointProvider x$5 = oldLogSegment.copy$default$4();
        return oldLogSegment.copy(x$4, x$1, (Seq<FileStatus>)x$2, x$5, x$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyDeltaVersions$1(Snapshot x$55) {
        return x$55 != null;
    }

    public static final /* synthetic */ long $anonfun$verifyDeltaVersions$3(Snapshot x$56) {
        return x$56.checkpointProvider().version();
    }

    private SnapshotManagement$() {
    }
}

