/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Tuple2;

public final class TypeWideningShims$ {
    public static final TypeWideningShims$ MODULE$ = new TypeWideningShims$();

    public boolean isTypeChangeSupported(AtomicType fromType, AtomicType toType) {
        AtomicType to;
        AtomicType from;
        Tuple2 tuple2 = new Tuple2((Object)fromType, (Object)toType);
        if (tuple2 != null) {
            AtomicType from2 = (AtomicType)tuple2._1();
            AtomicType to2 = (AtomicType)tuple2._2();
            AtomicType atomicType = from2;
            AtomicType atomicType2 = to2;
            if (!(atomicType != null ? !atomicType.equals(atomicType2) : atomicType2 != null)) {
                return true;
            }
        }
        if (tuple2 != null && !Cast$.MODULE$.canUpCast((DataType)(from = (AtomicType)tuple2._1()), (DataType)(to = (AtomicType)tuple2._2()))) {
            return false;
        }
        if (tuple2 != null) {
            AtomicType from3 = (AtomicType)tuple2._1();
            AtomicType to3 = (AtomicType)tuple2._2();
            if (from3 instanceof IntegralType) {
                IntegralType integralType = (IntegralType)from3;
                if (to3 instanceof IntegralType) {
                    IntegralType integralType2 = (IntegralType)to3;
                    return integralType.defaultSize() <= integralType2.defaultSize();
                }
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType3 = (AtomicType)tuple2._2();
            if (FloatType$.MODULE$.equals(atomicType) && DoubleType$.MODULE$.equals(atomicType3)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType4 = (AtomicType)tuple2._2();
            if (DateType$.MODULE$.equals(atomicType) && TimestampNTZType$.MODULE$.equals(atomicType4)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType5 = (AtomicType)tuple2._2();
            if ((ByteType$.MODULE$.equals(atomicType) ? true : (ShortType$.MODULE$.equals(atomicType) ? true : IntegerType$.MODULE$.equals(atomicType))) && DoubleType$.MODULE$.equals(atomicType5)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType from4 = (AtomicType)tuple2._1();
            AtomicType to4 = (AtomicType)tuple2._2();
            if (from4 instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)from4;
                if (to4 instanceof DecimalType) {
                    DecimalType decimalType2 = (DecimalType)to4;
                    return decimalType2.isWiderThan((DataType)decimalType);
                }
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType d = (AtomicType)tuple2._2();
            if ((ByteType$.MODULE$.equals(atomicType) ? true : (ShortType$.MODULE$.equals(atomicType) ? true : IntegerType$.MODULE$.equals(atomicType))) && d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                return decimalType.isWiderThan((DataType)IntegerType$.MODULE$);
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType d = (AtomicType)tuple2._2();
            if (LongType$.MODULE$.equals(atomicType) && d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                return decimalType.isWiderThan((DataType)LongType$.MODULE$);
            }
        }
        return false;
    }

    public boolean isTypeChangeSupportedForSchemaEvolution(AtomicType fromType, AtomicType toType) {
        AtomicType to;
        AtomicType from;
        Tuple2 tuple2 = new Tuple2((Object)fromType, (Object)toType);
        if (tuple2 != null) {
            AtomicType from2 = (AtomicType)tuple2._1();
            AtomicType to2 = (AtomicType)tuple2._2();
            AtomicType atomicType = from2;
            AtomicType atomicType2 = to2;
            if (!(atomicType != null ? !atomicType.equals(atomicType2) : atomicType2 != null)) {
                return true;
            }
        }
        if (tuple2 != null && !this.isTypeChangeSupported(from = (AtomicType)tuple2._1(), to = (AtomicType)tuple2._2())) {
            return false;
        }
        if (tuple2 != null) {
            AtomicType from3 = (AtomicType)tuple2._1();
            AtomicType to3 = (AtomicType)tuple2._2();
            if (from3 instanceof IntegralType) {
                IntegralType integralType = (IntegralType)from3;
                if (to3 instanceof IntegralType) {
                    IntegralType integralType2 = (IntegralType)to3;
                    return integralType.defaultSize() <= integralType2.defaultSize();
                }
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType3 = (AtomicType)tuple2._2();
            if (FloatType$.MODULE$.equals(atomicType) && DoubleType$.MODULE$.equals(atomicType3)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType from4 = (AtomicType)tuple2._1();
            AtomicType to4 = (AtomicType)tuple2._2();
            if (from4 instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)from4;
                if (to4 instanceof DecimalType) {
                    DecimalType decimalType2 = (DecimalType)to4;
                    return decimalType2.isWiderThan((DataType)decimalType);
                }
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType4 = (AtomicType)tuple2._2();
            if (DateType$.MODULE$.equals(atomicType) && TimestampNTZType$.MODULE$.equals(atomicType4)) {
                return true;
            }
        }
        return false;
    }

    private TypeWideningShims$() {
    }
}

