/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.CheckpointProvider;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.FeatureAutomaticallyEnabledByMetadata;
import org.apache.spark.sql.delta.LazyCompleteCheckpointProvider;
import org.apache.spark.sql.delta.PreDowngradeTableFeatureCommand;
import org.apache.spark.sql.delta.PreloadedCheckpointProvider;
import org.apache.spark.sql.delta.ReaderWriterFeature;
import org.apache.spark.sql.delta.RemovableFeature;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.V2CheckpointPreDowngradeCommand;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.CheckpointMetadata;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.SidecarFile;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import scala.runtime.ModuleSerializationProxy;

public final class V2CheckpointTableFeature$
extends ReaderWriterFeature
implements RemovableFeature,
FeatureAutomaticallyEnabledByMetadata {
    public static final V2CheckpointTableFeature$ MODULE$ = new V2CheckpointTableFeature$();

    static {
        RemovableFeature.$init$(MODULE$);
        FeatureAutomaticallyEnabledByMetadata.$init$(MODULE$);
    }

    @Override
    public boolean requiresHistoryProtection() {
        return RemovableFeature.requiresHistoryProtection$(this);
    }

    @Override
    public boolean historyContainsFeature(SparkSession spark, Snapshot downgradeTxnReadSnapshot) {
        return RemovableFeature.historyContainsFeature$(this, spark, downgradeTxnReadSnapshot);
    }

    @Override
    public boolean automaticallyUpdateProtocolOfExistingTables() {
        return true;
    }

    private boolean isV2CheckpointSupportNeededByMetadata(Metadata metadata) {
        return DeltaConfigs$.MODULE$.CHECKPOINT_POLICY().fromMetaData(metadata).needsV2CheckpointSupport();
    }

    @Override
    public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata, SparkSession spark) {
        return this.isV2CheckpointSupportNeededByMetadata(metadata);
    }

    @Override
    public boolean validateRemoval(Snapshot snapshot) {
        if (this.isV2CheckpointSupportNeededByMetadata(snapshot.metadata())) {
            return false;
        }
        CheckpointProvider checkpointProvider = snapshot.checkpointProvider();
        if (checkpointProvider.isEmpty()) {
            return true;
        }
        if (checkpointProvider instanceof PreloadedCheckpointProvider) {
            return true;
        }
        if (checkpointProvider instanceof LazyCompleteCheckpointProvider) {
            LazyCompleteCheckpointProvider lazyCompleteCheckpointProvider = (LazyCompleteCheckpointProvider)checkpointProvider;
            return lazyCompleteCheckpointProvider.underlyingCheckpointProvider() instanceof PreloadedCheckpointProvider;
        }
        return false;
    }

    @Override
    public boolean actionUsesFeature(Action action) {
        Action action2 = action;
        if (action2 instanceof Metadata) {
            Metadata metadata = (Metadata)action2;
            return this.isV2CheckpointSupportNeededByMetadata(metadata);
        }
        if (action2 instanceof CheckpointMetadata) {
            return true;
        }
        return action2 instanceof SidecarFile;
    }

    @Override
    public PreDowngradeTableFeatureCommand preDowngradeCommand(DeltaTableV2 table) {
        return new V2CheckpointPreDowngradeCommand(table);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(V2CheckpointTableFeature$.class);
    }

    private V2CheckpointTableFeature$() {
        super("v2Checkpoint");
    }
}

