/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CheckpointOnlyAction;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.LogReplay;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t}e\u0001B\u001d;\u0001\u001dC\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005/\")!\f\u0001C\u00017\"9q\f\u0001a\u0001\n\u0013\u0001\u0007b\u00023\u0001\u0001\u0004%I!\u001a\u0005\u0007W\u0002\u0001\u000b\u0015B1\t\u000f1\u0004\u0001\u0019!C\u0005[\"9a\u000e\u0001a\u0001\n\u0013y\u0007BB9\u0001A\u0003&1\u000bC\u0004s\u0001\u0001\u0007I\u0011B:\t\u000f]\u0004\u0001\u0019!C\u0005q\"1!\u0010\u0001Q!\nQDqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002(\u0001\u0001\u000b\u0011B?\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA\u001d\u0001\u0001\u0006I!!\f\t\u0013\u0005m\u0002A1A\u0005\n\u0005u\u0002\u0002\u0003B'\u0001\u0001\u0006I!a\u0010\t\u0013\t=\u0003A1A\u0005\n\tE\u0003\u0002\u0003B.\u0001\u0001\u0006IAa\u0015\t\u0013\tu\u0003A1A\u0005\n\tE\u0003\u0002\u0003B0\u0001\u0001\u0006IAa\u0015\t\u000f\t\u0005\u0004\u0001\"\u0011\u0003d!9!Q\u000f\u0001\u0005\n\t]\u0004\u0002\u0003BC\u0001\u0011\u0005AHa\"\t\u0011\t-\u0005\u0001\"\u0001=\u0005\u001bCqA!%\u0001\t\u0003\u0012\u0019\n\u0003\u0005\u0003\u0016\u0002!\t\u0001\u0010BL\u000f\u001d\t)E\u000fE\u0001\u0003\u000f2a!\u000f\u001e\t\u0002\u0005%\u0003B\u0002.\u001f\t\u0003\tYE\u0002\u0004\u0002Ny\u0011\u0015q\n\u0005\u000b\u0003S\u0002#Q3A\u0005\u0002\u0005-\u0004BCA?A\tE\t\u0015!\u0003\u0002n!Q\u0011q\u0010\u0011\u0003\u0016\u0004%\t!!!\t\u0015\u0005\u0015\u0005E!E!\u0002\u0013\t\u0019\t\u0003\u0004[A\u0011\u0005\u0011q\u0011\u0005\n\u0003#\u0003\u0013\u0011!C\u0001\u0003'C\u0011\"!'!#\u0003%\t!a'\t\u0013\u0005E\u0006%%A\u0005\u0002\u0005M\u0006\"CA\\A\u0005\u0005I\u0011IA]\u0011%\t)\rIA\u0001\n\u0003\t9\rC\u0005\u0002P\u0002\n\t\u0011\"\u0001\u0002R\"I\u00111\u001c\u0011\u0002\u0002\u0013\u0005\u0013Q\u001c\u0005\n\u0003O\u0004\u0013\u0011!C\u0001\u0003SD\u0011\"a=!\u0003\u0003%\t%!>\t\u0013\u0005e\b%!A\u0005B\u0005m\b\"CA\u007fA\u0005\u0005I\u0011IA\u0000\u0011%\u0011\t\u0001IA\u0001\n\u0003\u0012\u0019aB\u0005\u0003\by\t\t\u0011#\u0001\u0003\n\u0019I\u0011Q\n\u0010\u0002\u0002#\u0005!1\u0002\u0005\u00075N\"\tAa\t\t\u0013\u0005u8'!A\u0005F\u0005}\b\"\u0003B\u0013g\u0005\u0005I\u0011\u0011B\u0014\u0011%\u0011icMA\u0001\n\u0003\u0013y\u0003C\u0005\u0003>M\n\t\u0011\"\u0003\u0003@\t\t\u0012J\\'f[>\u0014\u0018\u0010T8h%\u0016\u0004H.Y=\u000b\u0005mb\u0014aB1di&|gn\u001d\u0006\u0003{y\nQ\u0001Z3mi\u0006T!a\u0010!\u0002\u0007M\fHN\u0003\u0002B\u0005\u0006)1\u000f]1sW*\u00111\tR\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001%O!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u0019\te.\u001f*fMB\u0011q\nU\u0007\u0002u%\u0011\u0011K\u000f\u0002\n\u0019><'+\u001a9mCf\f\u0011$\\5o\r&dWMU3uK:$\u0018n\u001c8US6,7\u000f^1naB\u0011\u0011\nV\u0005\u0003+*\u0013A\u0001T8oO\u0006\u0019S.\u001b8TKR$&/\u00198tC\u000e$\u0018n\u001c8SKR,g\u000e^5p]RKW.Z:uC6\u0004\bcA%Y'&\u0011\u0011L\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0002\rqJg.\u001b;?)\raVL\u0018\t\u0003\u001f\u0002AQAU\u0002A\u0002MCQAV\u0002A\u0002]\u000bacY;se\u0016tG\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\\\u000b\u0002CB\u0011qJY\u0005\u0003Gj\u0012\u0001\u0002\u0015:pi>\u001cw\u000e\\\u0001\u001bGV\u0014(/\u001a8u!J|Go\\2pYZ+'o]5p]~#S-\u001d\u000b\u0003M&\u0004\"!S4\n\u0005!T%\u0001B+oSRDqA[\u0003\u0002\u0002\u0003\u0007\u0011-A\u0002yIE\nqcY;se\u0016tG\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c\u0011\u0002\u001d\r,(O]3oiZ+'o]5p]V\t1+\u0001\ndkJ\u0014XM\u001c;WKJ\u001c\u0018n\u001c8`I\u0015\fHC\u00014q\u0011\u001dQ\u0007\"!AA\u0002M\u000bqbY;se\u0016tGOV3sg&|g\u000eI\u0001\u0010GV\u0014(/\u001a8u\u001b\u0016$\u0018\rR1uCV\tA\u000f\u0005\u0002Pk&\u0011aO\u000f\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006\u00192-\u001e:sK:$X*\u001a;b\t\u0006$\u0018m\u0018\u0013fcR\u0011a-\u001f\u0005\bU.\t\t\u00111\u0001u\u0003A\u0019WO\u001d:f]RlU\r^1ECR\f\u0007%\u0001\u0007ue\u0006t7/Y2uS>t7/F\u0001~!\u001dq\u0018qAA\u0006\u0003Ci\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u0015!*\u0001\u0006d_2dWm\u0019;j_:L1!!\u0003\u0000\u0005\u001dA\u0015m\u001d5NCB\u0004B!!\u0004\u0002\u001c9!\u0011qBA\f!\r\t\tBS\u0007\u0003\u0003'Q1!!\u0006G\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0004&\u0002\rA\u0013X\rZ3g\u0013\u0011\ti\"a\b\u0003\rM#(/\u001b8h\u0015\r\tIB\u0013\t\u0004\u001f\u0006\r\u0012bAA\u0013u\tq1+\u001a;Ue\u0006t7/Y2uS>t\u0017!\u0004;sC:\u001c\u0018m\u0019;j_:\u001c\b%A\be_6\f\u0017N\\'fi\u0006$\u0017\r^1t+\t\ti\u0003E\u0004\u007f\u0003_\tY!a\r\n\u0007\u0005ErPA\u0002NCB\u00042aTA\u001b\u0013\r\t9D\u000f\u0002\u000f\t>l\u0017-\u001b8NKR\fG-\u0019;b\u0003A!w.\\1j]6+G/\u00193bi\u0006\u001c\b%A\u0006bGRLg/\u001a$jY\u0016\u001cXCAA !\u001dq\u0018qAA!\u0005\u000f\u00022!a\u0011!\u001d\tyU$A\tJ]6+Wn\u001c:z\u0019><'+\u001a9mCf\u0004\"a\u0014\u0010\u0014\u0005yAECAA$\u0005U)f.[9vK\u001aKG.Z!di&|g\u000eV;qY\u0016\u001cb\u0001\t%\u0002R\u0005]\u0003cA%\u0002T%\u0019\u0011Q\u000b&\u0003\u000fA\u0013x\u000eZ;diB!\u0011\u0011LA2\u001d\u0011\tY&a\u0018\u000f\t\u0005E\u0011QL\u0005\u0002\u0017&\u0019\u0011\u0011\r&\u0002\u000fA\f7m[1hK&!\u0011QMA4\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\tGS\u0001\bM&dW-\u0016*J+\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u00079,GO\u0003\u0002\u0002x\u0005!!.\u0019<b\u0013\u0011\tY(!\u001d\u0003\u0007U\u0013\u0016*\u0001\u0005gS2,WKU%!\u0003E!W\r\\3uS>tg+Z2u_J,&+S\u000b\u0003\u0003\u0007\u0003B!\u0013-\u0002\f\u0005\u0011B-\u001a7fi&|gNV3di>\u0014XKU%!)\u0019\tI)!$\u0002\u0010B\u0019\u00111\u0012\u0011\u000e\u0003yAq!!\u001b&\u0001\u0004\ti\u0007C\u0004\u0002\u0000\u0015\u0002\r!a!\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003\u0013\u000b)*a&\t\u0013\u0005%d\u0005%AA\u0002\u00055\u0004\"CA@MA\u0005\t\u0019AAB\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!(+\t\u00055\u0014qT\u0016\u0003\u0003C\u0003B!a)\u0002.6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI+A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0016&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00020\u0006\u0015&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA[U\u0011\t\u0019)a(\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\u0011\t\t-!\u001e\u0002\t1\fgnZ\u0005\u0005\u0003;\ty,\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002JB\u0019\u0011*a3\n\u0007\u00055'JA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002T\u0006e\u0007cA%\u0002V&\u0019\u0011q\u001b&\u0003\u0007\u0005s\u0017\u0010\u0003\u0005kW\u0005\u0005\t\u0019AAe\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAp!\u0019\t\t/a9\u0002T6\u0011\u00111A\u0005\u0005\u0003K\f\u0019A\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAv\u0003c\u00042!SAw\u0013\r\tyO\u0013\u0002\b\u0005>|G.Z1o\u0011!QW&!AA\u0002\u0005M\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a/\u0002x\"A!NLA\u0001\u0002\u0004\tI-\u0001\u0005iCND7i\u001c3f)\t\tI-\u0001\u0005u_N#(/\u001b8h)\t\tY,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\u0014)\u0001\u0003\u0005kc\u0005\u0005\t\u0019AAj\u0003U)f.[9vK\u001aKG.Z!di&|g\u000eV;qY\u0016\u00042!a#4'\u0015\u0019$Q\u0002B\r!)\u0011yA!\u0006\u0002n\u0005\r\u0015\u0011R\u0007\u0003\u0005#Q1Aa\u0005K\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0006\u0003\u0012\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\tm!\u0011E\u0007\u0003\u0005;QAAa\b\u0002v\u0005\u0011\u0011n\\\u0005\u0005\u0003K\u0012i\u0002\u0006\u0002\u0003\n\u0005)\u0011\r\u001d9msR1\u0011\u0011\u0012B\u0015\u0005WAq!!\u001b7\u0001\u0004\ti\u0007C\u0004\u0002\u0000Y\u0002\r!a!\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0007B\u001d!\u0011I\u0005La\r\u0011\u000f%\u0013)$!\u001c\u0002\u0004&\u0019!q\u0007&\u0003\rQ+\b\u000f\\33\u0011%\u0011YdNA\u0001\u0002\u0004\tI)A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u0011\u0011\t\u0005u&1I\u0005\u0005\u0005\u000b\nyL\u0001\u0004PE*,7\r\u001e\t\u0004\u001f\n%\u0013b\u0001B&u\t9\u0011\t\u001a3GS2,\u0017\u0001D1di&4XMR5mKN\u0004\u0013\u0001F2b]\u000e,G\u000e\\3e%\u0016lwN^3GS2,7/\u0006\u0002\u0003TA9a0a\u0002\u0002B\tU\u0003cA(\u0003X%\u0019!\u0011\f\u001e\u0003\u0015I+Wn\u001c<f\r&dW-A\u000bdC:\u001cW\r\u001c7fIJ+Wn\u001c<f\r&dWm\u001d\u0011\u0002#\u0005\u001cG/\u001b<f%\u0016lwN^3GS2,7/\u0001\nbGRLg/\u001a*f[>4XMR5mKN\u0004\u0013AB1qa\u0016tG\rF\u0003g\u0005K\u0012I\u0007\u0003\u0004\u0003h]\u0001\raU\u0001\bm\u0016\u00148/[8o\u0011\u0019Yt\u00031\u0001\u0003lA1\u0011\u0011\fB7\u0005_JA!!:\u0002hA\u0019qJ!\u001d\n\u0007\tM$H\u0001\u0004BGRLwN\\\u0001\u000eO\u0016$Hk\\7cgR|g.Z:\u0016\u0005\te\u0004CBA-\u0005w\u0012y(\u0003\u0003\u0003~\u0005\u001d$\u0001C%uKJ\f'\r\\3\u0011\u0007=\u0013\t)C\u0002\u0003\u0004j\u0012!BR5mK\u0006\u001bG/[8o\u0003=9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cXC\u0001BE!\u0019\tIFa\u001f\u0002\"\u0005\u0011r-\u001a;E_6\f\u0017N\\'fi\u0006$\u0017\r^1t+\t\u0011y\t\u0005\u0004\u0002Z\tm\u00141G\u0001\u000bG\",7m\u001b9pS:$XC\u0001B6\u0003!\tG\u000e\u001c$jY\u0016\u001cXC\u0001BM!\u0019\tIFa'\u0003H%!!QTA4\u0005\r\u0019V-\u001d")
public class InMemoryLogReplay
implements LogReplay {
    private final long minFileRetentionTimestamp;
    private final Option<Object> minSetTransactionRetentionTimestamp;
    private Protocol currentProtocolVersion;
    private long currentVersion;
    private Metadata currentMetaData;
    private final HashMap<String, SetTransaction> transactions;
    private final Map<String, DomainMetadata> domainMetadatas;
    private final HashMap<UniqueFileActionTuple, AddFile> activeFiles;
    private final HashMap<UniqueFileActionTuple, RemoveFile> cancelledRemoveFiles;
    private final HashMap<UniqueFileActionTuple, RemoveFile> activeRemoveFiles;

    private Protocol currentProtocolVersion() {
        return this.currentProtocolVersion;
    }

    private void currentProtocolVersion_$eq(Protocol x$1) {
        this.currentProtocolVersion = x$1;
    }

    private long currentVersion() {
        return this.currentVersion;
    }

    private void currentVersion_$eq(long x$1) {
        this.currentVersion = x$1;
    }

    private Metadata currentMetaData() {
        return this.currentMetaData;
    }

    private void currentMetaData_$eq(Metadata x$1) {
        this.currentMetaData = x$1;
    }

    private HashMap<String, SetTransaction> transactions() {
        return this.transactions;
    }

    private Map<String, DomainMetadata> domainMetadatas() {
        return this.domainMetadatas;
    }

    private HashMap<UniqueFileActionTuple, AddFile> activeFiles() {
        return this.activeFiles;
    }

    private HashMap<UniqueFileActionTuple, RemoveFile> cancelledRemoveFiles() {
        return this.cancelledRemoveFiles;
    }

    private HashMap<UniqueFileActionTuple, RemoveFile> activeRemoveFiles() {
        return this.activeRemoveFiles;
    }

    @Override
    public void append(long version, Iterator<Action> actions) {
        Predef$.MODULE$.assert(this.currentVersion() == -1L || version == this.currentVersion() + 1L, (Function0 & Serializable)() -> new StringBuilder(46).append("Attempted to replay version ").append(version).append(", but state is at ").append(this.currentVersion()).toString());
        this.currentVersion_$eq(version);
        actions.foreach((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            DomainMetadata domainMetadata = null;
            Action action = x0$1;
            if (action instanceof SetTransaction) {
                SetTransaction setTransaction = (SetTransaction)action;
                this.transactions().update((Object)setTransaction.appId(), (Object)setTransaction);
                return BoxedUnit.UNIT;
            }
            if (action instanceof DomainMetadata) {
                bl = true;
                domainMetadata = (DomainMetadata)action;
                if (domainMetadata.removed()) {
                    return this.domainMetadatas().remove((Object)domainMetadata.domain());
                }
            }
            if (bl && !domainMetadata.removed()) {
                this.domainMetadatas().update((Object)domainMetadata.domain(), (Object)domainMetadata);
                return BoxedUnit.UNIT;
            }
            if (action instanceof CheckpointOnlyAction) {
                return BoxedUnit.UNIT;
            }
            if (action instanceof Metadata) {
                Metadata metadata = (Metadata)action;
                this.currentMetaData_$eq(metadata);
                return BoxedUnit.UNIT;
            }
            if (action instanceof Protocol) {
                Protocol protocol = (Protocol)action;
                this.currentProtocolVersion_$eq(protocol);
                return BoxedUnit.UNIT;
            }
            if (action instanceof AddFile) {
                AddFile addFile = (AddFile)action;
                UniqueFileActionTuple uniquePath = new UniqueFileActionTuple(addFile.pathAsUri(), addFile.getDeletionVectorUniqueId());
                boolean x$1 = false;
                String x$2 = addFile.copy$default$1();
                scala.collection.immutable.Map<String, String> x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                String x$6 = addFile.copy$default$6();
                scala.collection.immutable.Map<String, String> x$7 = addFile.copy$default$7();
                DeletionVectorDescriptor x$8 = addFile.copy$default$8();
                Option<Object> x$9 = addFile.copy$default$9();
                Option<Object> x$10 = addFile.copy$default$10();
                Option<String> x$11 = addFile.copy$default$11();
                this.activeFiles().update((Object)uniquePath, (Object)addFile.copy(x$2, x$3, x$4, x$5, false, x$6, x$7, x$8, x$9, x$10, x$11));
                this.cancelledRemoveFiles().remove((Object)uniquePath);
                return this.activeRemoveFiles().remove((Object)uniquePath);
            }
            if (action instanceof RemoveFile) {
                RemoveFile removeFile = (RemoveFile)action;
                UniqueFileActionTuple uniquePath = new UniqueFileActionTuple(removeFile.pathAsUri(), removeFile.getDeletionVectorUniqueId());
                Option option = this.activeFiles().remove((Object)uniquePath);
                if (option instanceof Some) {
                    this.cancelledRemoveFiles().update((Object)uniquePath, (Object)removeFile);
                } else if (None$.MODULE$.equals(option)) {
                    this.activeRemoveFiles().update((Object)uniquePath, (Object)removeFile);
                } else {
                    throw new MatchError((Object)option);
                }
                return BoxedUnit.UNIT;
            }
            if (action instanceof CommitInfo) {
                return BoxedUnit.UNIT;
            }
            if (action instanceof AddCDCFile) {
                return BoxedUnit.UNIT;
            }
            if (action == null) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)action);
        });
    }

    private Iterable<FileAction> getTombstones() {
        return (Iterable)((IterableOps)((IterableOps)this.cancelledRemoveFiles().values().$plus$plus((IterableOnce)this.activeRemoveFiles().values())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InMemoryLogReplay.$anonfun$getTombstones$1(this, x$1)))).map((Function1 & Serializable)x$2 -> {
            boolean x$1 = false;
            String x$22 = x$2.copy$default$1();
            Option<Object> x$3 = x$2.copy$default$2();
            Option<Object> x$4 = x$2.copy$default$4();
            scala.collection.immutable.Map<String, String> x$5 = x$2.copy$default$5();
            Option<Object> x$6 = x$2.copy$default$6();
            scala.collection.immutable.Map<String, String> x$7 = x$2.copy$default$7();
            DeletionVectorDescriptor x$8 = x$2.copy$default$8();
            Option<Object> x$9 = x$2.copy$default$9();
            Option<Object> x$10 = x$2.copy$default$10();
            String x$11 = x$2.copy$default$11();
            return x$2.copy(x$22, x$3, false, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        });
    }

    public Iterable<SetTransaction> getTransactions() {
        if (this.minSetTransactionRetentionTimestamp.isEmpty()) {
            return this.transactions().values();
        }
        return (Iterable)this.transactions().values().filter((Function1 & Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)InMemoryLogReplay.$anonfun$getTransactions$1(this, txn)));
    }

    public Iterable<DomainMetadata> getDomainMetadatas() {
        return this.domainMetadatas().values();
    }

    @Override
    public Iterator<Action> checkpoint() {
        Seq fileActions = (Seq)((IterableOnceOps)this.activeFiles().values().$plus$plus(this.getTombstones())).toSeq().sortBy((Function1 & Serializable)x$4 -> x$4.path(), (Ordering)Ordering.String$.MODULE$);
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.currentProtocolVersion())).toIterator().$plus$plus((Function0 & Serializable)() -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.currentMetaData())).toIterator()).$plus$plus((Function0 & Serializable)() -> this.getDomainMetadatas()).$plus$plus((Function0 & Serializable)() -> this.getTransactions()).$plus$plus((Function0 & Serializable)() -> fileActions.toIterator());
    }

    public Seq<AddFile> allFiles() {
        return this.activeFiles().values().toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$getTombstones$1(InMemoryLogReplay $this, RemoveFile x$1) {
        return x$1.delTimestamp() > $this.minFileRetentionTimestamp;
    }

    public static final /* synthetic */ boolean $anonfun$getTransactions$1(InMemoryLogReplay $this, SetTransaction txn) {
        return txn.lastUpdated().exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 > BoxesRunTime.unboxToLong((Object)$this.minSetTransactionRetentionTimestamp.get()));
    }

    public InMemoryLogReplay(long minFileRetentionTimestamp, Option<Object> minSetTransactionRetentionTimestamp) {
        this.minFileRetentionTimestamp = minFileRetentionTimestamp;
        this.minSetTransactionRetentionTimestamp = minSetTransactionRetentionTimestamp;
        this.currentProtocolVersion = null;
        this.currentVersion = -1L;
        this.currentMetaData = null;
        this.transactions = new HashMap();
        this.domainMetadatas = (Map)Map$.MODULE$.empty();
        this.activeFiles = new HashMap();
        this.cancelledRemoveFiles = new HashMap();
        this.activeRemoveFiles = new HashMap();
    }

    public static final class UniqueFileActionTuple
    implements Product,
    Serializable {
        private final URI fileURI;
        private final Option<String> deletionVectorURI;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public URI fileURI() {
            return this.fileURI;
        }

        public Option<String> deletionVectorURI() {
            return this.deletionVectorURI;
        }

        public UniqueFileActionTuple copy(URI fileURI, Option<String> deletionVectorURI) {
            return new UniqueFileActionTuple(fileURI, deletionVectorURI);
        }

        public URI copy$default$1() {
            return this.fileURI();
        }

        public Option<String> copy$default$2() {
            return this.deletionVectorURI();
        }

        public String productPrefix() {
            return "UniqueFileActionTuple";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.fileURI();
                }
                case 1: {
                    return this.deletionVectorURI();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UniqueFileActionTuple;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "fileURI";
                }
                case 1: {
                    return "deletionVectorURI";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UniqueFileActionTuple)) return false;
            boolean bl = true;
            if (!bl) return false;
            UniqueFileActionTuple uniqueFileActionTuple = (UniqueFileActionTuple)x$1;
            URI uRI = this.fileURI();
            URI uRI2 = uniqueFileActionTuple.fileURI();
            if (uRI == null) {
                if (uRI2 != null) {
                    return false;
                }
            } else if (!((Object)uRI).equals(uRI2)) return false;
            Option<String> option = this.deletionVectorURI();
            Option<String> option2 = uniqueFileActionTuple.deletionVectorURI();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public UniqueFileActionTuple(URI fileURI, Option<String> deletionVectorURI) {
            this.fileURI = fileURI;
            this.deletionVectorURI = deletionVectorURI;
            Product.$init$((Product)this);
        }
    }
}

