/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.TableFeature;
import org.apache.spark.sql.delta.TableFeature$;
import org.apache.spark.sql.delta.actions.Protocol$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.MapView;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TableFeatureProtocolUtils$ {
    public static final TableFeatureProtocolUtils$ MODULE$ = new TableFeatureProtocolUtils$();
    private static final String FEATURE_PROP_PREFIX = "delta.feature.";
    private static final String DEFAULT_FEATURE_PROP_PREFIX = "spark.databricks.delta.properties.defaults.feature.";
    private static final String FEATURE_PROP_ENABLED = "enabled";
    private static final String FEATURE_PROP_SUPPORTED = "supported";
    private static final int TABLE_FEATURES_MIN_READER_VERSION = 3;
    private static final int TABLE_FEATURES_MIN_WRITER_VERSION = 7;

    public String FEATURE_PROP_PREFIX() {
        return FEATURE_PROP_PREFIX;
    }

    public String DEFAULT_FEATURE_PROP_PREFIX() {
        return DEFAULT_FEATURE_PROP_PREFIX;
    }

    public String FEATURE_PROP_ENABLED() {
        return FEATURE_PROP_ENABLED;
    }

    public String FEATURE_PROP_SUPPORTED() {
        return FEATURE_PROP_SUPPORTED;
    }

    public int TABLE_FEATURES_MIN_READER_VERSION() {
        return TABLE_FEATURES_MIN_READER_VERSION;
    }

    public int TABLE_FEATURES_MIN_WRITER_VERSION() {
        return TABLE_FEATURES_MIN_WRITER_VERSION;
    }

    public String propertyKey(TableFeature feature) {
        return this.propertyKey(feature.name());
    }

    public String propertyKey(String featureName) {
        return new StringBuilder(0).append(this.FEATURE_PROP_PREFIX()).append(featureName).toString();
    }

    public String defaultPropertyKey(TableFeature feature) {
        return this.defaultPropertyKey(feature.name());
    }

    public String defaultPropertyKey(String featureName) {
        return new StringBuilder(0).append(this.DEFAULT_FEATURE_PROP_PREFIX()).append(featureName).toString();
    }

    public boolean supportsReaderFeatures(int readerVersion) {
        return readerVersion >= this.TABLE_FEATURES_MIN_READER_VERSION();
    }

    public boolean supportsWriterFeatures(int writerVersion) {
        return writerVersion >= this.TABLE_FEATURES_MIN_WRITER_VERSION();
    }

    public scala.collection.immutable.Set<TableFeature> getSupportedFeaturesFromTableConfigs(Map<String, String> configs) {
        MapView featureConfigs = configs.filterKeys((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)x$26.startsWith(TableFeatureProtocolUtils$.MODULE$.FEATURE_PROP_PREFIX())));
        Set unsupportedFeatureConfigs = (Set)Set$.MODULE$.empty();
        scala.collection.immutable.Set collectedFeatures = ((IterableOnceOps)featureConfigs.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option<TableFeature> featureOpt;
                String status;
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                String name = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(key), MODULE$.FEATURE_PROP_PREFIX()).toLowerCase(Locale.ROOT);
                String string = status = value.toLowerCase(Locale.ROOT);
                String string2 = MODULE$.FEATURE_PROP_SUPPORTED();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String string3 = status;
                    String string4 = MODULE$.FEATURE_PROP_ENABLED();
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        throw DeltaErrors$.MODULE$.unsupportedTableFeatureStatusException(name, status);
                    }
                }
                Object object = !(featureOpt = TableFeature$.MODULE$.featureNameToFeature(name)).isDefined() ? unsupportedFeatureConfigs.$plus$eq((Object)key) : BoxedUnit.UNIT;
                return featureOpt;
            }
            throw new MatchError((Object)tuple2);
        })).toSet();
        if (unsupportedFeatureConfigs.nonEmpty()) {
            throw DeltaErrors$.MODULE$.unsupportedTableFeatureConfigsException((Iterable<String>)unsupportedFeatureConfigs);
        }
        return collectedFeatures;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTableProtocolProperty(String key) {
        String string = key;
        String string2 = Protocol$.MODULE$.MIN_READER_VERSION_PROP();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = key;
        String string4 = Protocol$.MODULE$.MIN_WRITER_VERSION_PROP();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = key;
        String string6 = DeltaConfigs$.MODULE$.CREATE_TABLE_IGNORE_PROTOCOL_DEFAULTS().key();
        if (string5 == null) {
            if (string6 == null) return true;
        } else if (string5.equals(string6)) return true;
        if (!key.startsWith(this.FEATURE_PROP_PREFIX())) return false;
        return true;
    }

    public Tuple2<Object, Object> minimumRequiredVersions(Seq<TableFeature> features) {
        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((SeqOps)features.map((Function1 & Serializable)x$27 -> BoxesRunTime.boxToInteger((int)x$27.minReaderVersion()))).$colon$plus((Object)BoxesRunTime.boxToInteger((int)1))).max((Ordering)Ordering.Int$.MODULE$)), BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((SeqOps)features.map((Function1 & Serializable)x$28 -> BoxesRunTime.boxToInteger((int)x$28.minWriterVersion()))).$colon$plus((Object)BoxesRunTime.boxToInteger((int)1))).max((Ordering)Ordering.Int$.MODULE$)));
    }

    private TableFeatureProtocolUtils$() {
    }
}

