/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.coordinatedcommits;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import io.delta.storage.commit.CommitCoordinatorClient;
import io.delta.storage.commit.uccommitcoordinator.UCClient;
import io.delta.storage.commit.uccommitcoordinator.UCCommitCoordinatorClient;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.coordinatedcommits.CatalogOwnedCommitCoordinatorBuilder;
import org.apache.spark.sql.delta.coordinatedcommits.UCClientFactory;
import org.apache.spark.sql.delta.coordinatedcommits.UCTokenBasedRestClientFactory$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapView;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class UCCommitCoordinatorBuilder$
implements CatalogOwnedCommitCoordinatorBuilder,
DeltaLogging {
    public static final UCCommitCoordinatorBuilder$ MODULE$ = new UCCommitCoordinatorBuilder$();
    private static final String UNITY_CATALOG_CONNECTOR_CLASS;
    private static final ConcurrentHashMap<String, UCCommitCoordinatorClient> commitCoordinatorClientCache;
    private static final ConcurrentHashMap<Tuple2<String, String>, String> uriTokenToMetastoreIdCache;
    private static UCClientFactory ucClientFactory;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        UNITY_CATALOG_CONNECTOR_CLASS = "io.unitycatalog.spark.UCSingleCatalog";
        commitCoordinatorClientCache = new ConcurrentHashMap();
        uriTokenToMetastoreIdCache = new ConcurrentHashMap();
        ucClientFactory = UCTokenBasedRestClientFactory$.MODULE$;
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public scala.collection.immutable.Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private final String SPARK_SQL_CATALOG_PREFIX() {
        return "spark.sql.catalog.";
    }

    public final String UNITY_CATALOG_CONNECTOR_CLASS() {
        return UNITY_CATALOG_CONNECTOR_CLASS;
    }

    private final String URI_SUFFIX() {
        return "uri";
    }

    private final String TOKEN_SUFFIX() {
        return "token";
    }

    private ConcurrentHashMap<String, UCCommitCoordinatorClient> commitCoordinatorClientCache() {
        return commitCoordinatorClientCache;
    }

    private ConcurrentHashMap<Tuple2<String, String>, String> uriTokenToMetastoreIdCache() {
        return uriTokenToMetastoreIdCache;
    }

    public UCClientFactory ucClientFactory() {
        return ucClientFactory;
    }

    public void ucClientFactory_$eq(UCClientFactory x$1) {
        ucClientFactory = x$1;
    }

    @Override
    public String getName() {
        return "unity-catalog";
    }

    @Override
    public CommitCoordinatorClient build(SparkSession spark, scala.collection.immutable.Map<String, String> conf) {
        String metastoreId = (String)conf.getOrElse((Object)"ucMetastoreId", (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(60).append("UC metastore ID not found in the provided coordinator conf: ").append(conf).toString());
        });
        return (CommitCoordinatorClient)this.commitCoordinatorClientCache().computeIfAbsent(metastoreId, x$1 -> new UCCommitCoordinatorClient((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)conf).asJava(), MODULE$.getMatchingUCClient(spark, metastoreId)));
    }

    @Override
    public CommitCoordinatorClient buildForCatalog(SparkSession spark, String catalogName) {
        Some some;
        Tuple3 tuple3;
        Option option = this.getCatalogConfigs(spark).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UCCommitCoordinatorBuilder$.$anonfun$buildForCatalog$1(catalogName, x$2)));
        if (!(option instanceof Some) || (tuple3 = (Tuple3)(some = (Some)option).value()) == null) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(63).append("Catalog ").append(catalogName).append(" not found in the provided SparkSession configurations.").toString());
            }
            throw new MatchError((Object)option);
        }
        String uri = (String)tuple3._2();
        String token = (String)tuple3._3();
        UCClient client = this.ucClientFactory().createUCClient(uri, token);
        scala.collection.immutable.Map conf = Predef$.MODULE$.Map().empty();
        return new UCCommitCoordinatorClient((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)conf).asJava(), client);
    }

    private UCClient getMatchingUCClient(SparkSession spark, String metastoreId) {
        List matchingClients = ((List)this.getCatalogConfigs(spark).map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                String uri = (String)tuple3._2();
                String token = (String)tuple3._3();
                return new Tuple2((Object)uri, (Object)token);
            }
            throw new MatchError((Object)tuple3);
        }).distinct()).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)UCCommitCoordinatorBuilder$.$anonfun$getMatchingUCClient$2(metastoreId, x0$2)));
        List list = matchingClients;
        if (Nil$.MODULE$.equals(list)) {
            throw this.noMatchingCatalogException(metastoreId);
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List list2 = colon2.next$access$1();
            if (tuple2 != null) {
                String uri = (String)tuple2._1();
                String token = (String)tuple2._2();
                if (Nil$.MODULE$.equals(list2)) {
                    return this.ucClientFactory().createUCClient(uri, token);
                }
            }
        }
        throw this.multipleMatchingCatalogs(metastoreId, (List<String>)list.map((Function1 & Serializable)x$3 -> (String)x$3._1()));
    }

    private Option<String> getMetastoreId(String uri, String token) {
        Some some;
        try {
            String metastoreId = this.uriTokenToMetastoreIdCache().computeIfAbsent((Tuple2<String, String>)new Tuple2((Object)uri, (Object)token), x$4 -> {
                String string;
                UCClient ucClient = MODULE$.ucClientFactory().createUCClient(uri, token);
                try {
                    string = ucClient.getMetastoreId();
                }
                finally {
                    MODULE$.safeClose(ucClient, uri);
                }
                return string;
            });
            some = new Some((Object)metastoreId);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to getMetastoreSummary with ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.URI(), (Object)uri)}))), throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    private IllegalStateException noMatchingCatalogException(String metastoreId) {
        return new IllegalStateException(new StringBuilder(362).append("No matching catalog found for UC metastore ID ").append(metastoreId).append(". ").append("Please ensure the catalog is configured correctly by setting ").append("`spark.sql.catalog.<catalog-name>`, `spark.sql.catalog.<catalog-name>.uri` and ").append("`spark.sql.catalog.<catalog-name>.token`. Note that the matching process involves ").append("retrieving the metastoreId using the provided `<uri, token>` pairs in Spark ").append("Session configs.").toString());
    }

    private IllegalStateException multipleMatchingCatalogs(String metastoreId, List<String> uris) {
        return new IllegalStateException(new StringBuilder(364).append("Found multiple catalogs for UC metastore ID ").append(metastoreId).append(" at ").append(uris).append(". ").append("Please ensure the catalog is configured correctly by setting ").append("`spark.sql.catalog.<catalog-name>`, `spark.sql.catalog.<catalog-name>.uri` and ").append("`spark.sql.catalog.<catalog-name>.token`. Note that the matching process involves ").append("retrieving the metastoreId using the provided `<uri, token>` pairs in Spark ").append("Session configs.").toString());
    }

    public List<Tuple3<String, String, String>> getCatalogConfigs(SparkSession spark) {
        MapView catalogConfigs = spark.conf().getAll().filterKeys((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("spark.sql.catalog.")));
        return ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)catalogConfigs.keys().map((Function1 & Serializable)x$6 -> x$6.split("\\."))).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)UCCommitCoordinatorBuilder$.$anonfun$getCatalogConfigs$3(x$7)))).map((Function1 & Serializable)x$8 -> x$8[3])).filter((Function1 & Serializable)catalogName -> BoxesRunTime.boxToBoolean((boolean)UCCommitCoordinatorBuilder$.$anonfun$getCatalogConfigs$5(catalogConfigs, catalogName)))).flatMap((Function1 & Serializable)catalogName -> {
            Option token;
            Option uri = catalogConfigs.get((Object)new StringBuilder(22).append("spark.sql.catalog.").append((String)catalogName).append(".").append("uri").toString());
            Tuple2 tuple2 = new Tuple2((Object)uri, (Object)(token = catalogConfigs.get((Object)new StringBuilder(24).append("spark.sql.catalog.").append((String)catalogName).append(".").append("token").toString())));
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String u = (String)some.value();
                    if (option2 instanceof Some) {
                        Some some2;
                        Some some3 = (Some)option2;
                        String t = (String)some3.value();
                        try {
                            new URI(u);
                            some2 = new Some((Object)new Tuple3(catalogName, (Object)u, (Object)t));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping catalog ", " as it "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.CATALOG(), catalogName)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"does not have a valid URI ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.URI(), (Object)u)})))));
                            some2 = None$.MODULE$;
                        }
                        return some2;
                    }
                }
            }
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping catalog ", " as it does "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.CATALOG(), catalogName)}))), "not have both uri and token configured in Spark Session."));
            return None$.MODULE$;
        })).toList();
    }

    private void safeClose(UCClient ucClient, String uri) {
        try {
            ucClient.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to close UCClient for uri ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.URI(), (Object)uri)}))), throwable2);
            }
            throw throwable;
        }
    }

    public void clearCache() {
        this.commitCoordinatorClientCache().clear();
        this.uriTokenToMetastoreIdCache().clear();
    }

    public static final /* synthetic */ boolean $anonfun$buildForCatalog$1(String catalogName$1, Tuple3 x$2) {
        Object object = x$2._1();
        String string = catalogName$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$getMatchingUCClient$2(String metastoreId$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String uri = (String)tuple2._1();
            String token = (String)tuple2._2();
            return MODULE$.getMetastoreId(uri, token).contains((Object)metastoreId$2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getCatalogConfigs$3(String[] x$7) {
        return x$7.length == 4;
    }

    public static final /* synthetic */ boolean $anonfun$getCatalogConfigs$5(MapView catalogConfigs$1, String catalogName) {
        Option connector = catalogConfigs$1.get((Object)new StringBuilder(18).append("spark.sql.catalog.").append(catalogName).toString());
        return connector.contains((Object)MODULE$.UNITY_CATALOG_CONNECTOR_CLASS());
    }

    private UCCommitCoordinatorBuilder$() {
    }
}

