/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.hooks;

import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.commands.DeltaOptimizeContext;
import org.apache.spark.sql.delta.commands.DeltaOptimizeContext$;
import org.apache.spark.sql.delta.commands.DeltaReorgOperation;
import org.apache.spark.sql.delta.commands.OptimizeExecutor;
import org.apache.spark.sql.delta.commands.optimize.OptimizeMetrics;
import org.apache.spark.sql.delta.hooks.AutoCompact$;
import org.apache.spark.sql.delta.hooks.AutoCompactPartitionReserve$;
import org.apache.spark.sql.delta.hooks.AutoCompactRequest;
import org.apache.spark.sql.delta.hooks.AutoCompactType;
import org.apache.spark.sql.delta.hooks.AutoCompactType$;
import org.apache.spark.sql.delta.hooks.AutoCompactType$Enabled$;
import org.apache.spark.sql.delta.hooks.AutoCompactUtils$;
import org.apache.spark.sql.delta.hooks.PostCommitHook;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.stats.AutoCompactPartitionStats;
import org.apache.spark.sql.delta.stats.AutoCompactPartitionStats$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dfa\u0002\u0007\u000e!\u0003\r\tA\u0007\u0005\u0006W\u0001!\t\u0001\f\u0005\ba\u0001\u0011\r\u0011\"\u00112\u0011!i\u0004A1A\u0005\u0002=q\u0004\"\u0002$\u0001\t\u00039\u0005B\u00020\u0001\t\u0003iq\fC\u0003q\u0001\u0011\u0005\u0013\u000f\u0003\u0005\u0002\u0018\u0001!\taDA\r\u0011!\t9\u0005\u0001C\u0001\u001f\u0005%\u0003BCAB\u0001E\u0005I\u0011A\b\u0002\u0006\"Q\u00111\u0014\u0001\u0012\u0002\u0013\u0005q\"!(\t\u0015\u0005\u0005\u0006!%A\u0005\u0002=\t\u0019KA\bBkR|7i\\7qC\u000e$()Y:f\u0015\tqq\"A\u0003i_>\\7O\u0003\u0002\u0011#\u0005)A-\u001a7uC*\u0011!cE\u0001\u0004gFd'B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M!\u0001aG\u0011&!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!eI\u0007\u0002\u001b%\u0011A%\u0004\u0002\u000f!>\u001cHoQ8n[&$\bj\\8l!\t1\u0013&D\u0001(\u0015\tAs\"\u0001\u0005nKR,'/\u001b8h\u0013\tQsE\u0001\u0007EK2$\u0018\rT8hO&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002[A\u0011ADL\u0005\u0003_u\u0011A!\u00168ji\u0006!a.Y7f+\u0005\u0011\u0004CA\u001a;\u001d\t!\u0004\b\u0005\u00026;5\taG\u0003\u000283\u00051AH]8pizJ!!O\u000f\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003su\tqa\u0014)`)f\u0003V)F\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003mC:<'\"\u0001#\u0002\t)\fg/Y\u0005\u0003w\u0005\u000b!cZ3u\u0003V$xnQ8na\u0006\u001cG\u000fV=qKR\u0019\u0001J\u0014,\u0011\u0007qI5*\u0003\u0002K;\t1q\n\u001d;j_:\u0004\"A\t'\n\u00055k!aD!vi>\u001cu.\u001c9bGR$\u0016\u0010]3\t\u000b=#\u0001\u0019\u0001)\u0002\t\r|gN\u001a\t\u0003#Rk\u0011A\u0015\u0006\u0003'F\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003+J\u0013qaU)M\u0007>tg\rC\u0003X\t\u0001\u0007\u0001,\u0001\u0005nKR\fG-\u0019;b!\tIF,D\u0001[\u0015\tYv\"A\u0004bGRLwN\\:\n\u0005uS&\u0001C'fi\u0006$\u0017\r^1\u0002+MDw.\u001e7e'.L\u0007/Q;u_\u000e{W\u000e]1diR!\u0001mY3k!\ta\u0012-\u0003\u0002c;\t9!i\\8mK\u0006t\u0007\"\u00023\u0006\u0001\u0004A\u0015AE1vi>\u001cu.\u001c9bGR$\u0016\u0010]3PaRDQ\u0001F\u0003A\u0002\u0019\u0004\"a\u001a5\u000e\u0003EI!![\t\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b-,\u0001\u0019\u00017\u0002\u0007QDh\u000e\u0005\u0002n]6\tq\"\u0003\u0002p\u001f\t\u0001B)\u001a7uCR\u0013\u0018M\\:bGRLwN\\\u0001\u0004eVtGCB\u0017sgRLh\u0010C\u0003\u0015\r\u0001\u0007a\rC\u0003l\r\u0001\u0007A\u000eC\u0003v\r\u0001\u0007a/\u0001\td_6l\u0017\u000e\u001e;fIZ+'o]5p]B\u0011Ad^\u0005\u0003qv\u0011A\u0001T8oO\")!P\u0002a\u0001w\u0006\u0011\u0002o\\:u\u0007>lW.\u001b;T]\u0006\u00048\u000f[8u!\tiG0\u0003\u0002~\u001f\tA1K\\1qg\"|G\u000fC\u0003\\\r\u0001\u0007q\u0010\u0005\u0004\u0002\u0002\u0005-\u0011\u0011\u0003\b\u0005\u0003\u0007\t9AD\u00026\u0003\u000bI\u0011AH\u0005\u0004\u0003\u0013i\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\tyA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tI!\b\t\u00043\u0006M\u0011bAA\u000b5\n1\u0011i\u0019;j_:\f!cY8na\u0006\u001cG/\u00134OK\u000e,7o]1ssRa\u00111DA\u0019\u0003g\t)$a\u000e\u0002<A1\u0011\u0011AA\u000f\u0003CIA!a\b\u0002\u0010\t\u00191+Z9\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005Aq\u000e\u001d;j[&TXMC\u0002\u0002,=\t\u0001bY8n[\u0006tGm]\u0005\u0005\u0003_\t)CA\bPaRLW.\u001b>f\u001b\u0016$(/[2t\u0011\u0015!r\u00011\u0001g\u0011\u0015Yw\u00011\u0001m\u0011\u0015Qx\u00011\u0001|\u0011\u0019\tId\u0002a\u0001e\u00051q\u000e\u001d+za\u0016Dq!!\u0010\b\u0001\u0004\ty$A\nnCb$U\r\\3uK\u0012\u0014vn^:SCRLw\u000e\u0005\u0003\u001d\u0013\u0006\u0005\u0003c\u0001\u000f\u0002D%\u0019\u0011QI\u000f\u0003\r\u0011{WO\u00197f\u0003\u001d\u0019w.\u001c9bGR$b\"a\u0007\u0002L\u00055\u0013qKA7\u0003\u007f\n\t\tC\u0003\u0015\u0011\u0001\u0007a\rC\u0004\u0002P!\u0001\r!!\u0015\u0002\u0011\u0011,G\u000e^1M_\u001e\u00042!\\A*\u0013\r\t)f\u0004\u0002\t\t\u0016dG/\u0019'pO\"9\u0011\u0011\f\u0005A\u0002\u0005m\u0013\u0001D2bi\u0006dwn\u001a+bE2,\u0007\u0003\u0002\u000fJ\u0003;\u0002B!a\u0018\u0002j5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'A\u0004dCR\fGn\\4\u000b\u0007\u0005\u001d\u0014#\u0001\u0005dCR\fG._:u\u0013\u0011\tY'!\u0019\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\t\u0013\u0005=\u0004\u0002%AA\u0002\u0005E\u0014a\u00059beRLG/[8o!J,G-[2bi\u0016\u001c\bCBA\u0001\u0003;\t\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\u0011\tI(!\u001a\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003{\n9H\u0001\u0006FqB\u0014Xm]:j_:D\u0001\"!\u000f\t!\u0003\u0005\rA\r\u0005\n\u0003{A\u0001\u0013!a\u0001\u0003\u007f\t\u0011cY8na\u0006\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t9I\u000b\u0003\u0002r\u0005%5FAAF!\u0011\ti)a&\u000e\u0005\u0005=%\u0002BAI\u0003'\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UU$\u0001\u0006b]:|G/\u0019;j_:LA!!'\u0002\u0010\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002#\r|W\u000e]1di\u0012\"WMZ1vYR$S'\u0006\u0002\u0002 *\u001a!'!#\u0002#\r|W\u000e]1di\u0012\"WMZ1vYR$c'\u0006\u0002\u0002&*\"\u0011qHAE\u0001")
public interface AutoCompactBase
extends PostCommitHook,
DeltaLogging {
    public void org$apache$spark$sql$delta$hooks$AutoCompactBase$_setter_$name_$eq(String var1);

    public void org$apache$spark$sql$delta$hooks$AutoCompactBase$_setter_$OP_TYPE_$eq(String var1);

    @Override
    public String name();

    public String OP_TYPE();

    public static /* synthetic */ Option getAutoCompactType$(AutoCompactBase $this, SQLConf conf, Metadata metadata) {
        return $this.getAutoCompactType(conf, metadata);
    }

    default public Option<AutoCompactType> getAutoCompactType(SQLConf conf, Metadata metadata) {
        Option<AutoCompactType> option;
        Some some;
        boolean bl;
        Option autoCompactTypeFromConf = conf.getConf(DeltaSQLConf$.MODULE$.DELTA_AUTO_COMPACT_ENABLED()).map((Function1 & Serializable)x$1 -> AutoCompactType$.MODULE$.apply((String)x$1));
        if (autoCompactTypeFromConf.nonEmpty()) {
            return (Option)autoCompactTypeFromConf.get();
        }
        Option<Object> deprecatedFlag = DeltaConfigs$.MODULE$.AUTO_OPTIMIZE().fromMetaData(metadata);
        Option<Object> option2 = deprecatedFlag;
        if (option2 instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option2).value()))) {
            option = new Option<AutoCompactType>((Object)AutoCompactType$Enabled$.MODULE$);
        } else {
            Option<String> confValueFromTableProperty = DeltaConfigs$.MODULE$.AUTO_COMPACT().fromMetaData(metadata);
            Option<String> option3 = confValueFromTableProperty;
            if (option3 instanceof Some) {
                Some some2 = (Some)option3;
                String v = (String)some2.value();
                option = AutoCompactType$.MODULE$.apply(v);
            } else if (None$.MODULE$.equals(option3)) {
                option = AutoCompactType$.MODULE$.apply(AutoCompactType$.MODULE$.DISABLED());
            } else {
                throw new MatchError(option3);
            }
        }
        Option<AutoCompactType> autoCompactTypeFromPropertyOrDefaultValue = option;
        return autoCompactTypeFromPropertyOrDefaultValue;
    }

    public static /* synthetic */ boolean shouldSkipAutoCompact$(AutoCompactBase $this, Option autoCompactTypeOpt, SparkSession spark, DeltaTransaction txn) {
        return $this.shouldSkipAutoCompact((Option<AutoCompactType>)autoCompactTypeOpt, spark, txn);
    }

    default public boolean shouldSkipAutoCompact(Option<AutoCompactType> autoCompactTypeOpt, SparkSession spark, DeltaTransaction txn) {
        if (autoCompactTypeOpt.isEmpty()) {
            return true;
        }
        return !AutoCompactUtils$.MODULE$.isQualifiedForAutoCompact(spark, txn);
    }

    public static /* synthetic */ void run$(AutoCompactBase $this, SparkSession spark, DeltaTransaction txn, long committedVersion, Snapshot postCommitSnapshot, Iterator actions) {
        $this.run(spark, txn, committedVersion, postCommitSnapshot, (Iterator<Action>)actions);
    }

    @Override
    default public void run(SparkSession spark, DeltaTransaction txn, long committedVersion, Snapshot postCommitSnapshot, Iterator<Action> actions) {
        SQLConf conf = spark.sessionState().conf();
        Option<AutoCompactType> autoCompactTypeOpt = this.getAutoCompactType(conf, postCommitSnapshot.metadata());
        if (this.shouldSkipAutoCompact(autoCompactTypeOpt, spark, txn)) {
            return;
        }
        this.compactIfNecessary(spark, txn, postCommitSnapshot, this.OP_TYPE(), (Option<Object>)None$.MODULE$);
    }

    public static /* synthetic */ Seq compactIfNecessary$(AutoCompactBase $this, SparkSession spark, DeltaTransaction txn, Snapshot postCommitSnapshot, String opType, Option maxDeletedRowsRatio) {
        return $this.compactIfNecessary(spark, txn, postCommitSnapshot, opType, (Option<Object>)maxDeletedRowsRatio);
    }

    default public Seq<OptimizeMetrics> compactIfNecessary(SparkSession spark, DeltaTransaction txn, Snapshot postCommitSnapshot, String opType, Option<Object> maxDeletedRowsRatio) {
        String tableId = txn.deltaLog().tableId();
        AutoCompactRequest autoCompactRequest = AutoCompactUtils$.MODULE$.prepareAutoCompactRequest(spark, txn, postCommitSnapshot, (Option<Set<Map<String, String>>>)txn.partitionsAddedToOpt().map((Function1 & Serializable)x$2 -> x$2.toSet()), opType, maxDeletedRowsRatio);
        if (autoCompactRequest.shouldCompact()) {
            Seq<OptimizeMetrics> seq;
            try {
                try {
                    Seq<OptimizeMetrics> metrics = AutoCompact$.MODULE$.compact(spark, txn.deltaLog(), txn.catalogTable(), autoCompactRequest.targetPartitionsPredicate(), opType, maxDeletedRowsRatio);
                    AutoCompactPartitionStats partitionsStats = AutoCompactPartitionStats$.MODULE$.instance(spark);
                    partitionsStats.markPartitionsAsCompacted(tableId, autoCompactRequest.allowedPartitions());
                    seq = metrics;
                }
                catch (Throwable e) {
                    this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Auto Compaction failed with: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.ERROR(), (Object)e.getMessage())}))));
                    DeltaLog x$1 = txn.deltaLog();
                    String x$22 = "delta.autoCompaction.error";
                    Map<String, Object> x$3 = this.getErrorData(e);
                    Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                    Option<Path> x$5 = this.recordDeltaEvent$default$5();
                    this.recordDeltaEvent(x$1, "delta.autoCompaction.error", x$4, x$3, x$5);
                    throw e;
                }
            }
            finally {
                if (AutoCompactUtils$.MODULE$.reservePartitionEnabled(spark)) {
                    AutoCompactPartitionReserve$.MODULE$.releasePartitions(tableId, autoCompactRequest.allowedPartitions());
                }
            }
            return seq;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static /* synthetic */ Seq compact$(AutoCompactBase $this, SparkSession spark, DeltaLog deltaLog, Option catalogTable, Seq partitionPredicates, String opType, Option maxDeletedRowsRatio) {
        return $this.compact(spark, deltaLog, (Option<CatalogTable>)catalogTable, (Seq<Expression>)partitionPredicates, opType, (Option<Object>)maxDeletedRowsRatio);
    }

    default public Seq<OptimizeMetrics> compact(SparkSession spark, DeltaLog deltaLog, Option<CatalogTable> catalogTable, Seq<Expression> partitionPredicates, String opType, Option<Object> maxDeletedRowsRatio) {
        return (Seq)this.recordDeltaOperation(deltaLog, opType, this.recordDeltaOperation$default$3(), (Function0 & Serializable)() -> {
            long maxFileSize = BoxesRunTime.unboxToLong((Object)spark.conf().get(DeltaSQLConf$.MODULE$.DELTA_AUTO_COMPACT_MAX_FILE_SIZE()));
            Some minFileSizeOpt = new Some(spark.conf().get(DeltaSQLConf$.MODULE$.DELTA_AUTO_COMPACT_MIN_FILE_SIZE()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> maxFileSize / 2L));
            Some maxFileSizeOpt = new Some((Object)BoxesRunTime.boxToLong((long)maxFileSize));
            return (Seq)this.recordDeltaOperation(deltaLog, new StringBuilder(8).append(opType).append(".execute").toString(), this.recordDeltaOperation$default$3(), (Function0 & Serializable)() -> {
                DeltaOptimizeContext optimizeContext = new DeltaOptimizeContext((Option<DeltaReorgOperation>)None$.MODULE$, (Option<Object>)minFileSizeOpt, (Option<Object>)maxFileSizeOpt, maxDeletedRowsRatio, DeltaOptimizeContext$.MODULE$.apply$default$5());
                Option x$1 = catalogTable;
                boolean x$2 = deltaLog.update$default$1();
                Option<Object> x$32 = deltaLog.update$default$2();
                Seq<Row> rows = new OptimizeExecutor(spark, deltaLog.update(x$2, x$32, (Option<CatalogTable>)x$1), catalogTable, partitionPredicates, (Seq<String>)((Seq)Nil$.MODULE$), true, optimizeContext).optimize();
                Seq metrics = (Seq)rows.map((Function1 & Serializable)x$3 -> (OptimizeMetrics)x$3.getAs(1));
                DeltaLog x$4 = deltaLog;
                String x$5 = new StringBuilder(16).append(opType).append(".execute.metrics").toString();
                OptimizeMetrics x$6 = (OptimizeMetrics)metrics.head();
                Map<TagDefinition, String> x$7 = this.recordDeltaEvent$default$3();
                Option<Path> x$8 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(x$4, x$5, x$7, x$6, x$8);
                return metrics;
            });
        });
    }

    public static /* synthetic */ Seq compact$default$4$(AutoCompactBase $this) {
        return $this.compact$default$4();
    }

    default public Seq<Expression> compact$default$4() {
        return Nil$.MODULE$;
    }

    public static /* synthetic */ String compact$default$5$(AutoCompactBase $this) {
        return $this.compact$default$5();
    }

    default public String compact$default$5() {
        return this.OP_TYPE();
    }

    public static /* synthetic */ Option compact$default$6$(AutoCompactBase $this) {
        return $this.compact$default$6();
    }

    default public Option<Object> compact$default$6() {
        return None$.MODULE$;
    }

    public static void $init$(AutoCompactBase $this) {
        $this.org$apache$spark$sql$delta$hooks$AutoCompactBase$_setter_$name_$eq("Auto Compact");
        $this.org$apache$spark$sql$delta$hooks$AutoCompactBase$_setter_$OP_TYPE_$eq("delta.commit.hooks.autoOptimize");
    }
}

