/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.redirect;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.redirect.DropRedirectInProgress$;
import org.apache.spark.sql.delta.redirect.PathBasedRedirectSpec;
import org.apache.spark.sql.delta.redirect.RedirectReaderWriter$;
import org.apache.spark.sql.delta.redirect.RedirectReady$;
import org.apache.spark.sql.delta.redirect.RedirectSpec;
import org.apache.spark.sql.delta.redirect.RedirectState;
import org.apache.spark.sql.delta.redirect.RedirectWriterOnly$;
import org.apache.spark.sql.delta.redirect.TableRedirectConfiguration;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.DynamicVariable;

public final class RedirectFeature$ {
    public static final RedirectFeature$ MODULE$ = new RedirectFeature$();
    private static final String DELTALOG_PREFIX = "redirect-delta-log://";
    private static final DynamicVariable<Object> isUpdateTableRedirectDDL = new DynamicVariable((Object)BoxesRunTime.boxToBoolean((boolean)false));

    public boolean isFeatureSupported(Snapshot snapshot) {
        return RedirectReaderWriter$.MODULE$.isFeatureSupported(snapshot) || RedirectWriterOnly$.MODULE$.isFeatureSupported(snapshot);
    }

    private Option<TableRedirectConfiguration> getRedirectConfigurationFromDeltaLog(SparkSession spark, DeltaLog deltaLog, Option<CatalogTable> initialCatalogTable) {
        Option<CatalogTable> x$1 = initialCatalogTable;
        boolean x$2 = deltaLog.update$default$1();
        Option<Object> x$3 = deltaLog.update$default$2();
        Snapshot snapshot = deltaLog.update(x$2, x$3, x$1);
        return this.getRedirectConfiguration((Map<String, String>)snapshot.getProperties().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Tuple2<Path, Option<CatalogTable>> getRedirectLocationAndTable(SparkSession spark, DeltaLog deltaLog, TableRedirectConfiguration redirectConfig) {
        RedirectSpec redirectSpec = redirectConfig.spec();
        if (!(redirectSpec instanceof PathBasedRedirectSpec)) {
            throw new MatchError((Object)redirectSpec);
        }
        PathBasedRedirectSpec pathBasedRedirectSpec = (PathBasedRedirectSpec)redirectSpec;
        Option catalogTableOpt = (Option)this.withUpdateTableRedirectDDL(true, (Function0 & Serializable)() -> {
            Option option;
            Analyzer analyzer = spark.sessionState().analyzer();
            .colon.colon colon2 = new .colon.colon((Object)"delta", (List)new .colon.colon((Object)pathBasedRedirectSpec.destPath(), (List)Nil$.MODULE$));
            if (colon2 == null || (option = analyzer.CatalogAndIdentifier().unapply((Seq)colon2)).isEmpty()) {
                throw new MatchError((Object)colon2);
            }
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
            Identifier ident = (Identifier)((Tuple2)option.get())._2();
            Tuple2 tuple2 = new Tuple2((Object)catalog, (Object)ident);
            CatalogPlugin catalog2 = (CatalogPlugin)tuple2._1();
            Identifier ident2 = (Identifier)tuple2._2();
            return ((DeltaTableV2)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().loadTable(ident2)).catalogTable();
        });
        Path redirectLocation = redirectConfig.getRedirectLocation(deltaLog, spark);
        return new Tuple2((Object)redirectLocation, (Object)catalogTableOpt);
    }

    public TableRedirectConfiguration parseRedirectConfiguration(String configString) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return (TableRedirectConfiguration)mapper.readValue(configString, TableRedirectConfiguration.class);
    }

    public Option<TableRedirectConfiguration> getRedirectConfiguration(Map<String, String> properties) {
        return properties.get((Object)DeltaConfigs$.MODULE$.REDIRECT_READER_WRITER().key()).orElse((Function0 & Serializable)() -> properties.get((Object)DeltaConfigs$.MODULE$.REDIRECT_WRITER_ONLY().key())).map((Function1 & Serializable)configString -> MODULE$.parseRedirectConfiguration((String)configString));
    }

    public boolean isUpdateProperty(Snapshot snapshot, DeltaOperations.Operation op) {
        DeltaOperations.Operation operation = op;
        if (operation instanceof DeltaOperations.SetTableProperties) {
            DeltaOperations.SetTableProperties setTableProperties = (DeltaOperations.SetTableProperties)operation;
            Map<String, String> properties = setTableProperties.properties();
            Seq propertyKeys = properties.keySet().toSeq();
            return RedirectReaderWriter$.MODULE$.isUpdateProperty(snapshot, (Seq<String>)propertyKeys) || RedirectWriterOnly$.MODULE$.isUpdateProperty(snapshot, (Seq<String>)propertyKeys);
        }
        if (operation instanceof DeltaOperations.UnsetTableProperties) {
            DeltaOperations.UnsetTableProperties unsetTableProperties = (DeltaOperations.UnsetTableProperties)operation;
            Seq<String> propertyKeys = unsetTableProperties.propKeys();
            return RedirectReaderWriter$.MODULE$.isUpdateProperty(snapshot, propertyKeys) || RedirectWriterOnly$.MODULE$.isUpdateProperty(snapshot, propertyKeys);
        }
        return false;
    }

    public Option<TableRedirectConfiguration> getRedirectConfiguration(Snapshot snapshot) {
        return this.getRedirectConfiguration(snapshot.metadata().configuration());
    }

    public boolean hasRedirectConfig(Map<String, String> configs) {
        return this.getRedirectConfiguration(configs).isDefined();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRedirectProperty(String name) {
        String string = name;
        String string2 = DeltaConfigs$.MODULE$.REDIRECT_READER_WRITER().key();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = name;
        String string4 = DeltaConfigs$.MODULE$.REDIRECT_WRITER_ONLY().key();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public void validateStateTransition(String identifier, RedirectState currentState, RedirectState newState) {
        Tuple2 tuple2 = new Tuple2((Object)currentState, (Object)newState);
        if (tuple2 != null) {
            RedirectState state = (RedirectState)tuple2._1();
            RedirectState redirectState = (RedirectState)tuple2._2();
            if (RedirectReady$.MODULE$.equals(redirectState)) {
                RedirectState redirectState2 = state;
                DropRedirectInProgress$ dropRedirectInProgress$ = DropRedirectInProgress$.MODULE$;
                if (!(redirectState2 != null ? !redirectState2.equals(dropRedirectInProgress$) : dropRedirectInProgress$ != null)) {
                    throw DeltaErrors$.MODULE$.invalidRedirectStateTransition(identifier, state, newState);
                }
                return;
            }
        }
        if (tuple2 != null) {
            RedirectState state = (RedirectState)tuple2._1();
            RedirectState redirectState = (RedirectState)tuple2._2();
            if (DropRedirectInProgress$.MODULE$.equals(redirectState)) {
                RedirectState redirectState3 = state;
                RedirectReady$ redirectReady$ = RedirectReady$.MODULE$;
                if (redirectState3 == null ? redirectReady$ != null : !redirectState3.equals(redirectReady$)) {
                    throw DeltaErrors$.MODULE$.invalidRedirectStateTransition(identifier, state, newState);
                }
                return;
            }
        }
        if (tuple2 != null) {
            RedirectState state = (RedirectState)tuple2._1();
            throw DeltaErrors$.MODULE$.invalidRedirectStateTransition(identifier, state, newState);
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<TableRedirectConfiguration> needDeltaLogRedirect(SparkSession spark, DeltaLog deltaLog, Option<CatalogTable> initialCatalogTable) {
        boolean canSkipTableRedirect;
        boolean bl = canSkipTableRedirect = !BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.ENABLE_TABLE_REDIRECT_FEATURE())) || BoxesRunTime.unboxToBoolean((Object)this.isUpdateTableRedirectDDL().value()) || !deltaLog.tableExists();
        if (canSkipTableRedirect) {
            return None$.MODULE$;
        }
        Option<TableRedirectConfiguration> redirectConfigOpt = this.getRedirectConfigurationFromDeltaLog(spark, deltaLog, initialCatalogTable);
        boolean needRedirectToDest = redirectConfigOpt.exists((Function1 & Serializable)redirectConfig -> BoxesRunTime.boxToBoolean((boolean)redirectConfig.needRedirect(spark, deltaLog.dataPath())));
        if (needRedirectToDest) {
            return redirectConfigOpt;
        }
        return None$.MODULE$;
    }

    public void validateTableRedirect(Snapshot snapshot, Option<CatalogTable> catalogTable, Map<String, String> configs) {
        String identifier = (String)catalogTable.map((Function1 & Serializable)x$6 -> x$6.identifier().quotedString()).getOrElse((Function0 & Serializable)() -> new StringBuilder(8).append("delta.`").append(snapshot.deltaLog().logPath().toString()).append("`").toString());
        if (configs.contains((Object)DeltaConfigs$.MODULE$.REDIRECT_READER_WRITER().key())) {
            if (RedirectWriterOnly$.MODULE$.isFeatureSet(snapshot.metadata())) {
                throw DeltaErrors$.MODULE$.invalidSetUnSetRedirectCommand(identifier, DeltaConfigs$.MODULE$.REDIRECT_READER_WRITER().key(), DeltaConfigs$.MODULE$.REDIRECT_WRITER_ONLY().key());
            }
        } else if (configs.contains((Object)DeltaConfigs$.MODULE$.REDIRECT_WRITER_ONLY().key())) {
            if (RedirectReaderWriter$.MODULE$.isFeatureSet(snapshot.metadata())) {
                throw DeltaErrors$.MODULE$.invalidSetUnSetRedirectCommand(identifier, DeltaConfigs$.MODULE$.REDIRECT_WRITER_ONLY().key(), DeltaConfigs$.MODULE$.REDIRECT_READER_WRITER().key());
            }
        } else {
            return;
        }
        Option<TableRedirectConfiguration> currentRedirectConfigOpt = this.getRedirectConfiguration(snapshot);
        Option<TableRedirectConfiguration> newRedirectConfigOpt = this.getRedirectConfiguration(configs);
        newRedirectConfigOpt.foreach((Function1 & Serializable)newRedirectConfig -> {
            RedirectFeature$.$anonfun$validateTableRedirect$3(currentRedirectConfigOpt, identifier, newRedirectConfig);
            return BoxedUnit.UNIT;
        });
    }

    public String DELTALOG_PREFIX() {
        return DELTALOG_PREFIX;
    }

    private DynamicVariable<Object> isUpdateTableRedirectDDL() {
        return isUpdateTableRedirectDDL;
    }

    public <T> T withUpdateTableRedirectDDL(boolean updateTableRedirectDDL, Function0<T> thunk) {
        return (T)this.isUpdateTableRedirectDDL().withValue((Object)BoxesRunTime.boxToBoolean((boolean)updateTableRedirectDDL), thunk);
    }

    public static final /* synthetic */ void $anonfun$validateTableRedirect$3(Option currentRedirectConfigOpt$1, String identifier$1, TableRedirectConfiguration newRedirectConfig) {
        RedirectState newState = newRedirectConfig.redirectState();
        Option option = currentRedirectConfigOpt$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            TableRedirectConfiguration currentRedirectConfig = (TableRedirectConfiguration)some.value();
            MODULE$.validateStateTransition(identifier$1, currentRedirectConfig.redirectState(), newState);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            RedirectState redirectState = newState;
            DropRedirectInProgress$ dropRedirectInProgress$ = DropRedirectInProgress$.MODULE$;
            if (!(redirectState != null ? !redirectState.equals(dropRedirectInProgress$) : dropRedirectInProgress$ != null)) {
                throw DeltaErrors$.MODULE$.invalidRedirectStateTransition(identifier$1, newState, DropRedirectInProgress$.MODULE$);
            }
        }
    }

    private RedirectFeature$() {
    }
}

