/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.schema;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem;
import org.apache.spark.sql.catalyst.expressions.GetArrayStructFields;
import org.apache.spark.sql.catalyst.expressions.GetMapValue;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumnsUtils$;
import org.apache.spark.sql.delta.ClassicColumnConversions$;
import org.apache.spark.sql.delta.DeltaAnalysisException;
import org.apache.spark.sql.delta.DeltaAnalysisException$;
import org.apache.spark.sql.delta.DeltaColumnMappingMode;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.GeneratedColumn$;
import org.apache.spark.sql.delta.NoMapping$;
import org.apache.spark.sql.delta.RowCommitVersion$MetadataStructField$;
import org.apache.spark.sql.delta.RowId$RowIdMetadataStructField$;
import org.apache.spark.sql.delta.TypeWidening$;
import org.apache.spark.sql.delta.TypeWideningMode;
import org.apache.spark.sql.delta.TypeWideningMode$NoTypeWidening$;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaMergingUtils$;
import org.apache.spark.sql.delta.schema.UnsupportedDataTypeInfo;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.sources.DeltaStreamUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.Utils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantShims$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class SchemaUtils$
implements DeltaLogging {
    public static final SchemaUtils$ MODULE$ = new SchemaUtils$();
    private static final Function2<String, String, Object> DELTA_COL_RESOLVER;
    private static final int ARRAY_ELEMENT_INDEX;
    private static final int MAP_KEY_INDEX;
    private static final int MAP_VALUE_INDEX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
        DELTA_COL_RESOLVER = package$.MODULE$.caseInsensitiveResolution();
        ARRAY_ELEMENT_INDEX = 0;
        MAP_KEY_INDEX = 0;
        MAP_VALUE_INDEX = 1;
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public scala.collection.immutable.Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Function2<String, String, Object> DELTA_COL_RESOLVER() {
        return DELTA_COL_RESOLVER;
    }

    private int ARRAY_ELEMENT_INDEX() {
        return ARRAY_ELEMENT_INDEX;
    }

    private int MAP_KEY_INDEX() {
        return MAP_KEY_INDEX;
    }

    private int MAP_VALUE_INDEX() {
        return MAP_VALUE_INDEX;
    }

    public Seq<Tuple2<Seq<String>, StructField>> filterRecursively(DataType schema, boolean checkComplexTypes, Function1<StructField, Object> f) {
        return this.recurseIntoComplexTypes$1(schema, (Seq)Nil$.MODULE$, f, checkComplexTypes);
    }

    public boolean typeExistsRecursively(DataType dt, Function1<DataType, Object> f) {
        DataType dataType;
        block4: {
            while (true) {
                if ((dataType = dt) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)structType)) || ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.MODULE$.typeExistsRecursively(field.dataType(), (Function1<DataType, Object>)f)));
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    if (!BoxesRunTime.unboxToBoolean((Object)f.apply((Object)arrayType))) {
                        dt = arrayType.elementType();
                        continue;
                    }
                    return true;
                }
                if (!(dataType instanceof MapType)) break block4;
                MapType mapType = (MapType)dataType;
                if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)mapType)) || this.typeExistsRecursively(mapType.keyType(), f)) break;
                dt = mapType.valueType();
            }
            return true;
        }
        return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)dataType));
    }

    public Option<DataType> findAnyTypeRecursively(DataType dt, Function1<DataType, Object> f) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return new Some((Object)structType).filter(f).orElse((Function0 & Serializable)() -> ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)field -> MODULE$.findAnyTypeRecursively(field.dataType(), f), ClassTag$.MODULE$.apply(DataType.class))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findAnyTypeRecursively$3(x$1))));
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return new Some((Object)arrayType).filter(f).orElse((Function0 & Serializable)() -> MODULE$.findAnyTypeRecursively(arrayType.elementType(), f));
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return new Some((Object)mapType).filter(f).orElse((Function0 & Serializable)() -> MODULE$.findAnyTypeRecursively(mapType.keyType(), f)).orElse((Function0 & Serializable)() -> MODULE$.findAnyTypeRecursively(mapType.valueType(), f));
        }
        return new Some((Object)dataType).filter(f);
    }

    public DataType typeAsNullable(DataType dt) {
        DataType s2;
        DataType s1;
        boolean bl = false;
        ArrayType arrayType = null;
        boolean bl2 = false;
        MapType mapType = null;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return structType.asNullable();
        }
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType s = arrayType.elementType();
            if (s instanceof StructType) {
                StructType structType = (StructType)s;
                return arrayType.copy((DataType)structType.asNullable(), true);
            }
        }
        if (bl) {
            boolean x$1 = true;
            DataType x$2 = arrayType.copy$default$1();
            return arrayType.copy(x$2, true);
        }
        if (dataType instanceof MapType) {
            bl2 = true;
            mapType = (MapType)dataType;
            DataType s12 = mapType.keyType();
            DataType s22 = mapType.valueType();
            if (s12 instanceof StructType) {
                StructType structType = (StructType)s12;
                if (s22 instanceof StructType) {
                    StructType structType2 = (StructType)s22;
                    return mapType.copy((DataType)structType.asNullable(), (DataType)structType2.asNullable(), true);
                }
            }
        }
        if (bl2 && (s1 = mapType.keyType()) instanceof StructType) {
            StructType structType = (StructType)s1;
            StructType x$3 = structType.asNullable();
            boolean x$4 = true;
            DataType x$5 = mapType.copy$default$2();
            return mapType.copy((DataType)x$3, x$5, true);
        }
        if (bl2 && (s2 = mapType.valueType()) instanceof StructType) {
            StructType structType = (StructType)s2;
            StructType x$6 = structType.asNullable();
            boolean x$7 = true;
            DataType x$8 = mapType.copy$default$1();
            return mapType.copy(x$8, (DataType)x$6, true);
        }
        return dataType;
    }

    public Dataset<Row> dropNullTypeColumns(Dataset<Row> df) {
        StructType schema = df.schema();
        if (!this.typeExistsRecursively((DataType)schema, (Function1<DataType, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$dropNullTypeColumns$1(x$2)))) {
            return df;
        }
        Seq selectExprs = (Seq)schema.flatMap((Function1 & Serializable)f -> {
            if (f.dataType() instanceof NullType) {
                return None$.MODULE$;
            }
            return new Some((Object)this.generateSelectExpr$1((StructField)f, (Seq)Nil$.MODULE$));
        });
        return df.select(selectExprs);
    }

    private StructField getRawFieldWithoutCharVarcharMetadata(StructField field) {
        Metadata cleanedMetadata;
        StructField rawField = (StructField)CharVarcharUtils$.MODULE$.getRawType(field.metadata()).map((Function1 & Serializable)dt -> {
            DataType x$1 = dt;
            String x$2 = field.copy$default$1();
            boolean x$3 = field.copy$default$3();
            Metadata x$4 = field.copy$default$4();
            return field.copy(x$2, x$1, x$3, x$4);
        }).getOrElse((Function0 & Serializable)() -> field);
        String x$5 = rawField.name();
        DataType x$6 = rawField.dataType();
        boolean x$7 = rawField.nullable();
        Metadata x$8 = rawField.metadata();
        ExprId x$9 = AttributeReference$.MODULE$.apply$default$5(x$5, x$6, x$7, x$8);
        Seq x$10 = AttributeReference$.MODULE$.apply$default$6(x$5, x$6, x$7, x$8);
        AttributeReference throwAwayAttrRef = new AttributeReference(x$5, x$6, x$7, x$8, x$9, x$10);
        Metadata x$11 = cleanedMetadata = CharVarcharUtils$.MODULE$.cleanAttrMetadata(throwAwayAttrRef).metadata();
        String x$12 = rawField.copy$default$1();
        DataType x$13 = rawField.copy$default$2();
        boolean x$14 = rawField.copy$default$3();
        return rawField.copy(x$12, x$13, x$14, x$11);
    }

    public StructField setFieldDataTypeCharVarcharSafe(StructField field, DataType newDataType) {
        boolean byPassCharVarcharToStringFix = BoxesRunTime.unboxToBoolean((Object)SparkSession$.MODULE$.active().conf().get(DeltaSQLConf$.MODULE$.DELTA_BYPASS_CHARVARCHAR_TO_STRING_FIX()));
        StructField rawField = byPassCharVarcharToStringFix ? field : this.getRawFieldWithoutCharVarcharMetadata(field);
        DataType x$1 = newDataType;
        String x$2 = rawField.copy$default$1();
        boolean x$3 = rawField.copy$default$3();
        Metadata x$4 = rawField.copy$default$4();
        StructField rawFieldWithNewDataType = rawField.copy(x$2, x$1, x$3, x$4);
        if (byPassCharVarcharToStringFix) {
            return rawFieldWithNewDataType;
        }
        StructType throwAwayStructType = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)rawFieldWithNewDataType, (List)Nil$.MODULE$));
        return (StructField)CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(throwAwayStructType).head();
    }

    public StructType dropNullTypeColumns(StructType schema) {
        return StructType$.MODULE$.apply(SchemaUtils$.recurseAndRemove$1(schema));
    }

    public Option<String> findNullTypeColumn(StructType schema) {
        if (this.typeExistsRecursively((DataType)schema, (Function1<DataType, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findNullTypeColumn$2(x$5)))) {
            return SchemaUtils$.findNullTypeColumnRec$1(schema, (Seq)scala.package$.MODULE$.Seq().empty());
        }
        return None$.MODULE$;
    }

    public DataType normalizeColumnNamesInDataType(DeltaLog deltaLog, DataType sourceDataType, DataType tableDataType, Seq<String> sourceParentFields, StructType tableSchema) {
        block12: {
            block11: {
                Tuple2 tuple2 = new Tuple2((Object)sourceDataType, (Object)tableDataType);
                if (tuple2 != null) {
                    DataType sourceStruct = (DataType)tuple2._1();
                    DataType tableStruct = (DataType)tuple2._2();
                    if (sourceStruct instanceof StructType) {
                        StructType structType = (StructType)sourceStruct;
                        if (tableStruct instanceof StructType) {
                            StructType structType2 = (StructType)tableStruct;
                            scala.collection.immutable.Map<String, StructField> tableFields = SchemaMergingUtils$.MODULE$.toFieldMap((Seq<StructField>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)structType2.fields()), false);
                            StructField[] normalizedFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)sourceField -> {
                                StructField tableField = SchemaUtils$.getMatchingTableField$1(sourceField, tableFields, sourceParentFields, tableSchema);
                                DataType normalizedDataType = MODULE$.normalizeColumnNamesInDataType(deltaLog, sourceField.dataType(), tableField.dataType(), (Seq<String>)((Seq)sourceParentFields.$colon$plus((Object)sourceField.name())), tableSchema);
                                String normalizedName = tableField.name();
                                return sourceField.copy(normalizedName, normalizedDataType, sourceField.copy$default$3(), sourceField.copy$default$4());
                            }, ClassTag$.MODULE$.apply(StructField.class));
                            return structType.copy(normalizedFields);
                        }
                    }
                }
                if (tuple2 != null) {
                    DataType sourceArray = (DataType)tuple2._1();
                    DataType tableArray = (DataType)tuple2._2();
                    if (sourceArray instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)sourceArray;
                        if (tableArray instanceof ArrayType) {
                            ArrayType arrayType2 = (ArrayType)tableArray;
                            DataType normalizedElementType = this.normalizeColumnNamesInDataType(deltaLog, arrayType.elementType(), arrayType2.elementType(), sourceParentFields, tableSchema);
                            return arrayType.copy(normalizedElementType, arrayType.copy$default$2());
                        }
                    }
                }
                if (tuple2 != null) {
                    DataType sourceMap = (DataType)tuple2._1();
                    DataType tableMap = (DataType)tuple2._2();
                    if (sourceMap instanceof MapType) {
                        MapType mapType = (MapType)sourceMap;
                        if (tableMap instanceof MapType) {
                            MapType mapType2 = (MapType)tableMap;
                            DataType normalizedKeyType = this.normalizeColumnNamesInDataType(deltaLog, mapType.keyType(), mapType2.keyType(), sourceParentFields, tableSchema);
                            DataType normalizedValueType = this.normalizeColumnNamesInDataType(deltaLog, mapType.valueType(), mapType2.valueType(), sourceParentFields, tableSchema);
                            return mapType.copy(normalizedKeyType, normalizedValueType, mapType.copy$default$3());
                        }
                    }
                }
                if (tuple2 != null && tuple2._1() instanceof NullType) {
                    return sourceDataType;
                }
                if (tuple2 != null && tuple2._1() instanceof AtomicType && tuple2._2() instanceof AtomicType) {
                    return sourceDataType;
                }
                if (!Utils$.MODULE$.isTesting()) break block11;
                DataType dataType = sourceDataType;
                DataType dataType2 = tableDataType;
                Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), (Function0 & Serializable)() -> new StringBuilder(43).append("Types without nesting should match but ").append(sourceDataType).append(" != ").append(tableDataType).toString());
                break block12;
            }
            DataType dataType = sourceDataType;
            DataType dataType3 = tableDataType;
            if (!(dataType == null ? dataType3 != null : !dataType.equals(dataType3))) break block12;
            this.recordDeltaEvent(deltaLog, "delta.assertions.schemaNormalization.nonNestedTypeMismatch", (scala.collection.immutable.Map<TagDefinition, String>)Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceDataType"), (Object)sourceDataType.json()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableDataType"), (Object)tableDataType.json())})), (Option<Path>)None$.MODULE$);
        }
        return sourceDataType;
    }

    public Dataset<Row> normalizeColumnNames(DeltaLog deltaLog, StructType baseSchema, Dataset<?> data) {
        scala.collection.immutable.Set tableFields;
        StructType dataSchema = data.schema();
        scala.collection.immutable.Set dataFields = SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(dataSchema).toSet();
        if (dataFields.subsetOf((Set)(tableFields = SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(baseSchema).toSet()))) {
            return data.toDF();
        }
        scala.collection.immutable.Set nonCdcFields = (scala.collection.immutable.Set)dataFields.filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$normalizeColumnNames$1(f)));
        if (nonCdcFields.subsetOf((Set)tableFields)) {
            return data.toDF();
        }
        scala.collection.immutable.Map<String, StructField> baseFields = SchemaMergingUtils$.MODULE$.toFieldMap((Seq<StructField>)baseSchema, false);
        Seq aliasExpressions = (Seq)dataSchema.map(arg_0 -> SchemaUtils$.$anonfun$normalizeColumnNames$2(baseFields, deltaLog, baseSchema, arg_0));
        QueryExecution queryExecution = data.queryExecution();
        if (queryExecution instanceof IncrementalExecution) {
            IncrementalExecution incrementalExecution = (IncrementalExecution)queryExecution;
            return DeltaStreamUtils$.MODULE$.selectFromStreamingDataFrame(incrementalExecution, (Dataset<Row>)data.toDF(), (Seq<Column>)aliasExpressions);
        }
        return data.select(aliasExpressions);
    }

    public boolean isPartitionCompatible(Seq<String> newPartitionColumns, Seq<String> oldPartitionColumns) {
        Seq<String> seq = newPartitionColumns;
        Seq<String> seq2 = oldPartitionColumns;
        return !(seq != null ? !seq.equals(seq2) : seq2 != null);
    }

    public Seq<String> isPartitionCompatible$default$1() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public Seq<String> isPartitionCompatible$default$2() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public boolean isReadCompatible(StructType existingSchema, StructType readSchema, boolean forbidTightenNullability, boolean allowMissingColumns, TypeWideningMode typeWideningMode, Seq<String> newPartitionColumns, Seq<String> oldPartitionColumns) {
        return this.isStructReadCompatible$1(existingSchema, readSchema, allowMissingColumns, newPartitionColumns, oldPartitionColumns, forbidTightenNullability, typeWideningMode);
    }

    public boolean isReadCompatible$default$3() {
        return false;
    }

    public boolean isReadCompatible$default$4() {
        return false;
    }

    public TypeWideningMode isReadCompatible$default$5() {
        return TypeWideningMode$NoTypeWidening$.MODULE$;
    }

    public Seq<String> isReadCompatible$default$6() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public Seq<String> isReadCompatible$default$7() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public Seq<String> reportDifferences(StructType existingSchema, StructType specifiedSchema) {
        return SchemaUtils$.structDifference$1(existingSchema, CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(specifiedSchema), "");
    }

    public Option<StructField> findNestedFieldIgnoreCase(StructType schema, Seq<String> fieldNames, boolean includeCollections) {
        return this.findRecursively$1((DataType)schema, fieldNames, includeCollections);
    }

    public boolean findNestedFieldIgnoreCase$default$3() {
        return false;
    }

    public Seq<Object> findColumnPosition(Seq<String> column, DataType schema, Function2<String, String, Object> resolver) {
        Seq seq;
        try {
            seq = this.findRecursively$2(column, schema, SchemaUtils$.findRecursively$default$3$1(), resolver, schema);
        }
        catch (DeltaAnalysisException e) {
            throw e;
        }
        catch (AnalysisException e) {
            throw DeltaErrors$.MODULE$.errorFindingColumnPosition(column, schema, e.getMessage());
        }
        return seq;
    }

    public Function2<String, String, Object> findColumnPosition$default$3() {
        return this.DELTA_COL_RESOLVER();
    }

    public StructField getNestedFieldFromPosition(StructField parent, Seq<Object> position) {
        DataType dataType;
        int fieldPos;
        while (true) {
            if (position.isEmpty()) {
                return parent;
            }
            fieldPos = BoxesRunTime.unboxToInt((Object)position.head());
            boolean bl = false;
            MapType mapType = null;
            dataType = parent.dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                if (fieldPos >= 0 && fieldPos < structType.size()) {
                    position = (Seq)position.tail();
                    parent = structType.apply(fieldPos);
                    continue;
                }
            }
            if (dataType instanceof MapType) {
                bl = true;
                mapType = (MapType)dataType;
                if (fieldPos == this.MAP_KEY_INDEX()) {
                    position = (Seq)position.tail();
                    parent = new StructField("key", mapType.keyType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    continue;
                }
            }
            if (bl && fieldPos == this.MAP_VALUE_INDEX()) {
                position = (Seq)position.tail();
                parent = new StructField("value", mapType.valueType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                continue;
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            if (fieldPos != this.ARRAY_ELEMENT_INDEX()) break;
            position = (Seq)position.tail();
            parent = new StructField("element", arrayType.elementType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        }
        if (dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType)) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Invalid child position ").append(fieldPos).append(" in ").append(parent.dataType()).toString());
        }
        throw new IllegalArgumentException(new StringBuilder(38).append("Invalid indexing into non-nested type ").append(dataType).toString());
    }

    public DataType getNestedTypeFromPosition(DataType schema, Seq<Object> position) {
        return this.getNestedFieldFromPosition(new StructField("schema", schema, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), position).dataType();
    }

    public String prettyFieldName(Seq<String> columnPath) {
        return new UnresolvedAttribute(columnPath).name();
    }

    public <T extends DataType> T addColumn(T parent, StructField column, Seq<Object> position) {
        if (position.isEmpty()) {
            throw DeltaErrors$.MODULE$.addColumnParentNotStructException(column, parent);
        }
        boolean bl = false;
        MapType mapType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        T t = parent;
        if (t instanceof StructType) {
            StructType structType = (StructType)t;
            return (T)this.addColumnToStruct(structType, column, position);
        }
        if (t instanceof MapType) {
            bl = true;
            mapType = (MapType)t;
            if (BoxesRunTime.unboxToInt((Object)position.head()) == this.MAP_KEY_INDEX()) {
                return (T)mapType.copy(this.addColumn(mapType.keyType(), column, (Seq<Object>)((Seq)position.tail())), mapType.copy$default$2(), mapType.copy$default$3());
            }
        }
        if (bl && BoxesRunTime.unboxToInt((Object)position.head()) == this.MAP_VALUE_INDEX()) {
            DataType x$1 = this.addColumn(mapType.valueType(), column, (Seq<Object>)((Seq)position.tail()));
            DataType x$2 = mapType.copy$default$1();
            boolean x$3 = mapType.copy$default$3();
            return (T)mapType.copy(x$2, x$1, x$3);
        }
        if (t instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)t;
            if (BoxesRunTime.unboxToInt((Object)position.head()) == this.ARRAY_ELEMENT_INDEX()) {
                return (T)arrayType.copy(this.addColumn(arrayType.elementType(), column, (Seq<Object>)((Seq)position.tail())), arrayType.copy$default$2());
            }
        }
        if (bl2) {
            throw DeltaErrors$.MODULE$.incorrectArrayAccess();
        }
        throw DeltaErrors$.MODULE$.addColumnParentNotStructException(column, t);
    }

    private StructType addColumnToStruct(StructType schema, StructField column, Seq<Object> position) {
        if (column.metadata().contains("CURRENT_DEFAULT")) {
            throw new DeltaAnalysisException("WRONG_COLUMN_DEFAULTS_FOR_DELTA_ALTER_TABLE_ADD_COLUMN_NOT_SUPPORTED", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3(), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        Predef$.MODULE$.require(position.nonEmpty(), (Function0 & Serializable)() -> new StringBuilder(35).append("Don't know where to add the column ").append(column).toString());
        int slicePosition = BoxesRunTime.unboxToInt((Object)position.head());
        if (slicePosition < 0) {
            throw DeltaErrors$.MODULE$.addColumnAtIndexLessThanZeroException(Integer.toString(slicePosition), column.toString());
        }
        int length = schema.length();
        if (slicePosition > length) {
            throw DeltaErrors$.MODULE$.indexLargerThanStruct(slicePosition, column, length);
        }
        if (slicePosition == length) {
            if (position.length() > 1) {
                throw DeltaErrors$.MODULE$.addColumnStructNotFoundException(Integer.toString(slicePosition));
            }
            return StructType$.MODULE$.apply((Seq)schema.$colon$plus((Object)column));
        }
        Tuple2 tuple2 = schema.splitAt(slicePosition);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq pre = (Seq)tuple2._1();
        Seq post = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pre, (Object)post);
        Seq pre2 = (Seq)tuple22._1();
        Seq post2 = (Seq)tuple22._2();
        if (position.length() > 1) {
            StructField field = (StructField)post2.head();
            if (!column.nullable() && field.nullable()) {
                throw DeltaErrors$.MODULE$.nullableParentWithNotNullNestedField();
            }
            DataType x$1 = this.addColumn(field.dataType(), column, (Seq<Object>)((Seq)position.tail()));
            String x$2 = field.copy$default$1();
            boolean x$3 = field.copy$default$3();
            Metadata x$4 = field.copy$default$4();
            StructField mid = field.copy(x$2, x$1, x$3, x$4);
            return StructType$.MODULE$.apply((Seq)((IterableOps)pre2.$plus$plus((IterableOnce)new .colon.colon((Object)mid, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)post2.tail()));
        }
        return StructType$.MODULE$.apply((Seq)((IterableOps)pre2.$plus$plus((IterableOnce)new .colon.colon((Object)column, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)post2));
    }

    public <T extends DataType> Tuple2<T, StructField> dropColumn(T parent, Seq<Object> position) {
        if (position.isEmpty()) {
            throw DeltaErrors$.MODULE$.dropNestedColumnsFromNonStructTypeException(parent);
        }
        boolean bl = false;
        MapType mapType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        T t = parent;
        if (t instanceof StructType) {
            StructType structType = (StructType)t;
            Tuple2<StructType, StructField> tuple2 = this.dropColumnInStruct(structType, position);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StructType t2 = (StructType)tuple2._1();
            StructField s = (StructField)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)t2, (Object)s);
            StructType t3 = (StructType)tuple22._1();
            StructField s2 = (StructField)tuple22._2();
            return new Tuple2((Object)t3, (Object)s2);
        }
        if (t instanceof MapType) {
            bl = true;
            mapType = (MapType)t;
            if (BoxesRunTime.unboxToInt((Object)position.head()) == this.MAP_KEY_INDEX()) {
                Tuple2<DataType, StructField> tuple2 = this.dropColumn(mapType.keyType(), (Seq<Object>)((Seq)position.tail()));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DataType newKeyType = (DataType)tuple2._1();
                StructField droppedColumn = (StructField)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)newKeyType, (Object)droppedColumn);
                DataType newKeyType2 = (DataType)tuple23._1();
                StructField droppedColumn2 = (StructField)tuple23._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapType.copy(newKeyType2, mapType.copy$default$2(), mapType.copy$default$3())), (Object)droppedColumn2);
            }
        }
        if (bl && BoxesRunTime.unboxToInt((Object)position.head()) == this.MAP_VALUE_INDEX()) {
            Tuple2<DataType, StructField> tuple2 = this.dropColumn(mapType.valueType(), (Seq<Object>)((Seq)position.tail()));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            DataType newValueType = (DataType)tuple2._1();
            StructField droppedColumn = (StructField)tuple2._2();
            Tuple2 tuple24 = new Tuple2((Object)newValueType, (Object)droppedColumn);
            DataType newValueType2 = (DataType)tuple24._1();
            StructField droppedColumn3 = (StructField)tuple24._2();
            DataType x$1 = newValueType2;
            DataType x$2 = mapType.copy$default$1();
            boolean x$3 = mapType.copy$default$3();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapType.copy(x$2, x$1, x$3)), (Object)droppedColumn3);
        }
        if (t instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)t;
            if (BoxesRunTime.unboxToInt((Object)position.head()) == this.ARRAY_ELEMENT_INDEX()) {
                Tuple2<DataType, StructField> tuple2 = this.dropColumn(arrayType.elementType(), (Seq<Object>)((Seq)position.tail()));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DataType newElementType = (DataType)tuple2._1();
                StructField droppedColumn = (StructField)tuple2._2();
                Tuple2 tuple25 = new Tuple2((Object)newElementType, (Object)droppedColumn);
                DataType newElementType2 = (DataType)tuple25._1();
                StructField droppedColumn4 = (StructField)tuple25._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)arrayType.copy(newElementType2, arrayType.copy$default$2())), (Object)droppedColumn4);
            }
        }
        if (bl2) {
            throw DeltaErrors$.MODULE$.incorrectArrayAccess();
        }
        throw DeltaErrors$.MODULE$.dropNestedColumnsFromNonStructTypeException(t);
    }

    private Tuple2<StructType, StructField> dropColumnInStruct(StructType schema, Seq<Object> position) {
        Predef$.MODULE$.require(position.nonEmpty(), (Function0 & Serializable)() -> "Don't know where to drop the column");
        int slicePosition = BoxesRunTime.unboxToInt((Object)position.head());
        if (slicePosition < 0) {
            throw DeltaErrors$.MODULE$.dropColumnAtIndexLessThanZeroException(slicePosition);
        }
        int length = schema.length();
        if (slicePosition >= length) {
            throw DeltaErrors$.MODULE$.indexLargerOrEqualThanStruct(slicePosition, length);
        }
        Tuple2 tuple2 = schema.splitAt(slicePosition);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq pre = (Seq)tuple2._1();
        Seq post = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pre, (Object)post);
        Seq pre2 = (Seq)tuple22._1();
        Seq post2 = (Seq)tuple22._2();
        StructField field = (StructField)post2.head();
        if (position.length() > 1) {
            Tuple2<DataType, StructField> tuple23 = this.dropColumn(field.dataType(), (Seq<Object>)((Seq)position.tail()));
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            DataType newType = (DataType)tuple23._1();
            StructField droppedColumn = (StructField)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)newType, (Object)droppedColumn);
            DataType newType2 = (DataType)tuple24._1();
            StructField droppedColumn2 = (StructField)tuple24._2();
            DataType x$1 = newType2;
            String x$2 = field.copy$default$1();
            boolean x$3 = field.copy$default$3();
            Metadata x$4 = field.copy$default$4();
            StructField mid = field.copy(x$2, x$1, x$3, x$4);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StructType$.MODULE$.apply((Seq)((IterableOps)pre2.$plus$plus((IterableOnce)new .colon.colon((Object)mid, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)post2.tail()))), (Object)droppedColumn2);
        }
        if (length == 1) {
            throw DeltaErrors$.MODULE$.dropColumnOnSingleFieldSchema(schema);
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StructType$.MODULE$.apply((Seq)pre2.$plus$plus((IterableOnce)post2.tail()))), (Object)field);
    }

    public Option<String> canChangeDataType(DataType from, DataType to, Function2<String, String, Object> resolver, DeltaColumnMappingMode columnMappingMode, Seq<String> columnPath, boolean failOnAmbiguousChanges, boolean allowTypeWidening) {
        Some some;
        try {
            this.check$1(from, to, columnPath, resolver, failOnAmbiguousChanges, columnMappingMode, allowTypeWidening);
            some = None$.MODULE$;
        }
        catch (AnalysisException e) {
            some = new Some((Object)e.message());
        }
        return some;
    }

    public Seq<String> canChangeDataType$default$5() {
        return Nil$.MODULE$;
    }

    public boolean canChangeDataType$default$6() {
        return false;
    }

    public boolean canChangeDataType$default$7() {
        return false;
    }

    public StructField changeFieldDataTypeCharVarcharSafe(StructField fromField, StructField toField, Function2<String, String, Object> resolver) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = BoxesRunTime.unboxToBoolean((Object)SparkSession$.MODULE$.active().conf().get(DeltaSQLConf$.MODULE$.DELTA_BYPASS_CHARVARCHAR_TO_STRING_FIX())) ? new Tuple2((Object)fromField, (Object)toField) : new Tuple2((Object)this.getRawFieldWithoutCharVarcharMetadata(fromField), (Object)this.getRawFieldWithoutCharVarcharMetadata(toField));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField safeFromField = (StructField)tuple2._1();
        StructField safeToField = (StructField)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)safeFromField, (Object)safeToField);
        StructField safeFromField2 = (StructField)tuple23._1();
        StructField safeToField2 = (StructField)tuple23._2();
        DataType newDataType = this.changeDataType(safeFromField2.dataType(), safeToField2.dataType(), resolver);
        return this.setFieldDataTypeCharVarcharSafe(fromField, newDataType);
    }

    public DataType changeDataType(DataType from, DataType to, Function2<String, String, Object> resolver) {
        Tuple2 tuple2 = new Tuple2((Object)from, (Object)to);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType fromElement = arrayType.elementType();
                boolean fn = arrayType.containsNull();
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType toElement = arrayType2.elementType();
                    return new ArrayType(this.changeDataType(fromElement, toElement, resolver), fn);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType fromKey = mapType.keyType();
                DataType fromValue = mapType.valueType();
                boolean fn = mapType.valueContainsNull();
                if (dataType3 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType3;
                    DataType toKey = mapType2.keyType();
                    DataType toValue = mapType2.valueType();
                    return new MapType(this.changeDataType(fromKey, toKey, resolver), this.changeDataType(fromValue, toValue, resolver), fn);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])toFields), (Function1 & Serializable)toField -> (StructField)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])fromFields), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$changeDataType$2(resolver, toField, field))).map((Function1 & Serializable)fromField -> {
                        StructField qual$1 = (StructField)toField.getComment().map((Function1 & Serializable)comment -> fromField.withComment(comment)).getOrElse((Function0 & Serializable)() -> fromField);
                        DataType x$1 = MODULE$.changeDataType(fromField.dataType(), toField.dataType(), resolver);
                        boolean x$2 = toField.nullable();
                        String x$3 = qual$1.copy$default$1();
                        Metadata x$4 = qual$1.copy$default$4();
                        return qual$1.copy(x$3, x$1, x$2, x$4);
                    }).getOrElse((Function0 & Serializable)() -> toField), ClassTag$.MODULE$.apply(StructField.class)));
                }
            }
        }
        if (tuple2 != null) {
            DataType toDataType = (DataType)tuple2._2();
            return toDataType;
        }
        throw new MatchError((Object)tuple2);
    }

    public StructType transformSchema(StructType schema, Option<String> colName, Function3<Seq<String>, DataType, Function2<String, String, Object>, DataType> tf) {
        return (StructType)this.transform$1((Seq)scala.package$.MODULE$.Seq().empty(), (DataType)schema, colName, tf);
    }

    public Option<String> transformSchema$default$2() {
        return None$.MODULE$;
    }

    public <E> StructType transformColumns(StructType schema, Seq<Tuple2<Seq<String>, E>> input, Function3<Seq<String>, StructField, Seq<Tuple2<Seq<String>, E>>, StructField> tf) {
        scala.collection.immutable.Map inputLookup = input.groupBy((Function1 & Serializable)x$21 -> (Seq)((IterableOps)x$21._1()).map((Function1 & Serializable)x$22 -> x$22.toLowerCase()));
        return SchemaMergingUtils$.MODULE$.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable)(path, field, resolver) -> {
            Seq fullPath = (Seq)path.$colon$plus((Object)field.name());
            Seq normalizedFullPath = (Seq)fullPath.map((Function1 & Serializable)x$23 -> x$23.toLowerCase());
            Seq matches = (Seq)Option$.MODULE$.option2Iterable(inputLookup.get((Object)normalizedFullPath)).toSeq().flatMap((Function1 & Serializable)x$24 -> (Seq)x$24.filter((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$transformColumns$6(fullPath, resolver, x$25))));
            if (matches.nonEmpty()) {
                return (StructField)tf.apply(path, field, (Object)matches);
            }
            return field;
        });
    }

    public void checkSchemaFieldNames(StructType schema, DeltaColumnMappingMode columnMappingMode) {
        DeltaColumnMappingMode deltaColumnMappingMode = columnMappingMode;
        NoMapping$ noMapping$ = NoMapping$.MODULE$;
        if (deltaColumnMappingMode == null ? noMapping$ != null : !deltaColumnMappingMode.equals(noMapping$)) {
            return;
        }
        Seq<String> invalidColumnNames = this.findInvalidColumnNames(SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(schema));
        if (invalidColumnNames.nonEmpty()) {
            throw DeltaErrors$.MODULE$.foundInvalidCharsInColumnNames(invalidColumnNames);
        }
    }

    public void checkFieldNames(Seq<String> names) {
        Seq<String> invalidColumnNames = this.findInvalidColumnNames(names);
        if (invalidColumnNames.nonEmpty()) {
            throw DeltaErrors$.MODULE$.invalidColumnName((String)invalidColumnNames.head());
        }
    }

    public Seq<String> findInvalidColumnNamesInSchema(StructType schema) {
        return this.findInvalidColumnNames(SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(schema));
    }

    private Seq<String> findInvalidColumnNames(Seq<String> columnNames) {
        Seq badChars = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{' ', ',', ';', '{', '}', '(', ')', '\n', '\t', '='}));
        return (Seq)columnNames.filter((Function1 & Serializable)colName -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findInvalidColumnNames$1(badChars, colName)));
    }

    public StructType removeUnenforceableNotNullConstraints(StructType schema, SQLConf conf) {
        boolean allowUnenforceableNotNulls = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.ALLOW_UNENFORCED_NOT_NULL_CONSTRAINTS()));
        return SchemaMergingUtils$.MODULE$.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable)(path, f, r) -> this.checkField$1((Seq)path, (StructField)f, (Function2)r, allowUnenforceableNotNulls));
    }

    public Column fieldToColumn(StructField field) {
        return ClassicColumnConversions$.MODULE$.ColumnConstructorExt(Column$.MODULE$).apply((Expression)UnresolvedAttribute$.MODULE$.quoted(field.name()));
    }

    public Column fieldNameToColumn(String field) {
        return functions$.MODULE$.col(this.quoteIdentifier(field));
    }

    public String quoteIdentifier(String part) {
        return new StringBuilder(2).append("`").append(part.replace("`", "``")).append("`").toString();
    }

    private Expression analyzeExpression(SparkSession spark, Expression expr, StructType schema) {
        LocalRelation relation = LocalRelation$.MODULE$.apply(schema);
        Expression x$1 = expr;
        String x$2 = "validate_column";
        ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, "validate_column");
        Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, "validate_column");
        Option x$5 = Alias$.MODULE$.apply$default$5(x$1, "validate_column");
        Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, "validate_column");
        Project relationWithExp = new Project((Seq)new .colon.colon((Object)new Alias(x$1, "validate_column", x$3, x$4, x$5, x$6), (List)Nil$.MODULE$), (LogicalPlan)relation);
        LogicalPlan analyzedPlan = spark.sessionState().analyzer().execute((LogicalPlan)relationWithExp);
        return (Expression)analyzedPlan.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                NamedExpression a;
                SeqOps seqOps;
                Project project;
                Seq seq;
                A1 A1 = x1;
                if (A1 instanceof Project && (seq = (project = (Project)A1).projectList()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (a = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Alias) {
                    Alias alias = (Alias)a;
                    if (project.child() instanceof LocalRelation) {
                        return (B1)alias.child();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                NamedExpression a;
                SeqOps seqOps;
                Project project;
                Seq seq;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof Project && (seq = (project = (Project)logicalPlan).projectList()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (a = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Alias && project.child() instanceof LocalRelation;
            }
        }).get();
    }

    private Seq<Seq<String>> collectUsedColumns(Expression expression) {
        ArrayBuffer result = new ArrayBuffer();
        SchemaUtils$.traverseAllPaths$1(expression, result).foreach((Function1 & Serializable)x$32 -> (ArrayBuffer)result.$plus$eq(x$32));
        return result.toSeq();
    }

    private boolean fallbackContainsDependentExpression(Expression expression, Seq<String> columnToChange, Function2<String, String, Object> resolver) {
        boolean bl;
        Object object = new Object();
        try {
            expression.foreach((Function1 & Serializable)x0$1 -> {
                SchemaUtils$.$anonfun$fallbackContainsDependentExpression$1(columnToChange, resolver, object, x0$1);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public boolean containsDependentExpression(SparkSession spark, Seq<String> columnToChange, String exprString, StructType schema, Function2<String, String, Object> resolver) {
        Expression expression = spark.sessionState().sqlParser().parseExpression(exprString);
        if (BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CHANGE_COLUMN_CHECK_DEPENDENT_EXPRESSIONS_USE_V2()))) {
            boolean bl;
            try {
                Expression analyzedExpr = this.analyzeExpression(spark, expression, schema);
                Seq<Seq<String>> exprColumns = this.collectUsedColumns(analyzedExpr);
                bl = exprColumns.exists((Function1 & Serializable)exprColumn -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$containsDependentExpression$1(columnToChange, resolver, exprColumn)));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    this.deltaAssert((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> false, "containsDependentExpression.checkV2Error", new StringBuilder(51).append("Exception during dependent expression V2 checking: ").append(throwable2.getMessage()).toString(), this.deltaAssert$default$4(), this.deltaAssert$default$5(), this.deltaAssert$default$6());
                    bl = this.fallbackContainsDependentExpression(expression, columnToChange, resolver);
                }
                throw throwable;
            }
            return bl;
        }
        return this.fallbackContainsDependentExpression(expression, columnToChange, resolver);
    }

    public Seq<UnsupportedDataTypeInfo> findUnsupportedDataTypes(StructType schema) {
        ArrayBuffer unsupportedDataTypes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.findUnsupportedDataTypesRecursively((ArrayBuffer<UnsupportedDataTypeInfo>)unsupportedDataTypes, (DataType)schema, this.findUnsupportedDataTypesRecursively$default$3());
        return unsupportedDataTypes.toSeq();
    }

    public boolean checkForTimestampNTZColumnsRecursively(StructType schema) {
        return this.typeExistsRecursively((DataType)schema, (Function1<DataType, Object>)(Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$checkForTimestampNTZColumnsRecursively$1(x$33)));
    }

    public boolean checkForVariantTypeColumnsRecursively(StructType schema) {
        return this.typeExistsRecursively((DataType)schema, (Function1<DataType, Object>)(Function1 & Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)VariantShims$.MODULE$.isVariantType(x$34)));
    }

    private void findUnsupportedDataTypesRecursively(ArrayBuffer<UnsupportedDataTypeInfo> unsupportedDataTypes, DataType dataType, Seq<String> columnPath) {
        block23: {
            DataType dataType2;
            while (true) {
                if (NullType$.MODULE$.equals(dataType2 = dataType)) {
                    break block23;
                }
                if (BooleanType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (ByteType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (ShortType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (IntegerType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (dataType2 instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
                    Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable)() -> "'columnPath' must not be empty");
                    unsupportedDataTypes.$plus$eq((Object)new UnsupportedDataTypeInfo(this.prettyFieldName(columnPath), (DataType)yearMonthIntervalType));
                    break block23;
                }
                if (LongType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (dataType2 instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
                    Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable)() -> "'columnPath' must not be empty");
                    unsupportedDataTypes.$plus$eq((Object)new UnsupportedDataTypeInfo(this.prettyFieldName(columnPath), (DataType)dayTimeIntervalType));
                    break block23;
                }
                if (FloatType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (DoubleType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (TimestampNTZType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (VariantShims$.MODULE$.isVariantType(dataType2)) {
                    break block23;
                }
                if (BinaryType$.MODULE$.equals(dataType2)) {
                    break block23;
                }
                if (dataType2 instanceof DecimalType) {
                    break block23;
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType2;
                    Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable)() -> "'columnPath' must not be empty");
                    columnPath = (Seq)((SeqOps)columnPath.dropRight(1)).$colon$plus((Object)new StringBuilder(2).append((String)columnPath.last()).append("[]").toString());
                    dataType = arrayType.elementType();
                    continue;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable)() -> "'columnPath' must not be empty");
                    this.findUnsupportedDataTypesRecursively(unsupportedDataTypes, mapType.keyType(), (Seq<String>)((Seq)((SeqOps)columnPath.dropRight(1)).$colon$plus((Object)new StringBuilder(5).append((String)columnPath.last()).append("[key]").toString())));
                    columnPath = (Seq)((SeqOps)columnPath.dropRight(1)).$colon$plus((Object)new StringBuilder(7).append((String)columnPath.last()).append("[value]").toString());
                    dataType = mapType.valueType();
                    continue;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> {
                        SchemaUtils$.MODULE$.findUnsupportedDataTypesRecursively((ArrayBuffer<UnsupportedDataTypeInfo>)unsupportedDataTypes, f.dataType(), (Seq<String>)((Seq)columnPath.$colon$plus((Object)f.name())));
                        return BoxedUnit.UNIT;
                    });
                    break block23;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            if (dataType2 != null) {
                DataType dataType3 = dataType2;
                Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable)() -> "'columnPath' must not be empty");
                unsupportedDataTypes.$plus$eq((Object)new UnsupportedDataTypeInfo(this.prettyFieldName(columnPath), dataType3));
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
    }

    private Seq<String> findUnsupportedDataTypesRecursively$default$3() {
        return Nil$.MODULE$;
    }

    public scala.collection.immutable.Map<String, String> findDependentGeneratedColumns(SparkSession sparkSession, Seq<String> targetColumn, Protocol protocol, StructType schema) {
        if (GeneratedColumn$.MODULE$.satisfyGeneratedColumnProtocol(protocol) && GeneratedColumn$.MODULE$.hasGeneratedColumns(schema)) {
            scala.collection.mutable.Map dependentGenCols = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            SchemaMergingUtils$.MODULE$.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable)(x$35, field, x$36) -> {
                GeneratedColumn$.MODULE$.getGenerationExpressionStr(field.metadata()).foreach((Function1 & Serializable)exprStr -> {
                    boolean needsToChangeExpr = MODULE$.containsDependentExpression(sparkSession, targetColumn, (String)exprStr, schema, (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
                    if (needsToChangeExpr) {
                        return dependentGenCols.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), exprStr));
                    }
                    return BoxedUnit.UNIT;
                });
                return field;
            });
            return dependentGenCols.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return Predef$.MODULE$.Map().empty();
    }

    public Seq<DataType> findUndefinedTypes(DataType dt) {
        DataType dataType;
        while (true) {
            if (NullType$.MODULE$.equals(dataType = dt)) {
                return Nil$.MODULE$;
            }
            if (BooleanType$.MODULE$.equals(dataType)) {
                return Nil$.MODULE$;
            }
            if (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)))) {
                return Nil$.MODULE$;
            }
            if (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : dataType instanceof DecimalType)) {
                return Nil$.MODULE$;
            }
            if (StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType)) {
                return Nil$.MODULE$;
            }
            if (DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType)) {
                return Nil$.MODULE$;
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> MODULE$.findUndefinedTypes(f.dataType()), ClassTag$.MODULE$.apply(DataType.class)));
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            dt = arrayType.elementType();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return (Seq)this.findUndefinedTypes(mapType.keyType()).$plus$plus(this.findUndefinedTypes(mapType.valueType()));
        }
        return new .colon.colon((Object)dataType, (List)Nil$.MODULE$);
    }

    public void recordUndefinedTypes(DeltaLog deltaLog, StructType schema) {
        try {
            ((IterableOnceOps)this.findUndefinedTypes((DataType)schema).map((Function1 & Serializable)x$37 -> x$37.getClass().getName())).toSet().foreach((Function1 & Serializable)className -> {
                SchemaUtils$.$anonfun$recordUndefinedTypes$2(deltaLog, className);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to log undefined types for table "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.PATH(), (Object)deltaLog.logPath())})))), throwable2);
            }
            throw throwable;
        }
    }

    public boolean areLogicalNamesEqual(Seq<String> col1, Seq<String> col2) {
        return col1.length() == col2.length() && ((IterableOnceOps)col1.zip(col2)).forall(this.DELTA_COL_RESOLVER().tupled());
    }

    public StructType removeExistsDefaultMetadata(StructType schema) {
        return this.transformSchema(schema, this.transformSchema$default$2(), (Function3<Seq<String>, DataType, Function2<String, String, Object>, DataType>)(Function3 & Serializable)(x0$1, x1$1, x2$1) -> {
            StructType structType;
            StructField[] fields;
            DataType dataType;
            Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
            if (tuple3 != null && (dataType = (DataType)tuple3._2()) instanceof StructType && ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields())), (Function1 & Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$removeExistsDefaultMetadata$2(x$38)))) {
                StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
                    MetadataBuilder builder = new MetadataBuilder().withMetadata(field.metadata()).remove(ResolveDefaultColumnsUtils$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
                    Metadata x$1 = builder.build();
                    String x$2 = field.copy$default$1();
                    DataType x$3 = field.copy$default$2();
                    boolean x$4 = field.copy$default$3();
                    return field.copy(x$2, x$3, x$4, x$1);
                }, ClassTag$.MODULE$.apply(StructField.class));
                return new StructType(newFields);
            }
            if (tuple3 != null) {
                DataType other = (DataType)tuple3._2();
                return other;
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private final Seq recurseIntoComplexTypes$1(DataType complexType, Seq columnStack, Function1 f$1, boolean checkComplexTypes$1) {
        DataType dataType;
        while (true) {
            if ((dataType = complexType) instanceof StructType) {
                StructType structType = (StructType)dataType;
                return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)sf -> {
                    Nil$ includeLevel = BoxesRunTime.unboxToBoolean((Object)f$1.apply(sf)) ? new .colon.colon((Object)new Tuple2((Object)columnStack, sf), (List)Nil$.MODULE$) : Nil$.MODULE$;
                    return (Seq)includeLevel.$plus$plus((IterableOnce)this.recurseIntoComplexTypes$1(sf.dataType(), (Seq)columnStack.$colon$plus((Object)sf.name()), f$1, checkComplexTypes$1));
                }, ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            if (!checkComplexTypes$1) break;
            columnStack = (Seq)columnStack.$colon$plus((Object)"element");
            complexType = arrayType.elementType();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            if (checkComplexTypes$1) {
                return (Seq)this.recurseIntoComplexTypes$1(mapType.keyType(), (Seq)columnStack.$colon$plus((Object)"key"), f$1, checkComplexTypes$1).$plus$plus((IterableOnce)this.recurseIntoComplexTypes$1(mapType.valueType(), (Seq)columnStack.$colon$plus((Object)"value"), f$1, checkComplexTypes$1));
            }
        }
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$findAnyTypeRecursively$3(DataType x$1) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$dropNullTypeColumns$1(DataType x$2) {
        return x$2 instanceof NullType;
    }

    public static final /* synthetic */ boolean $anonfun$dropNullTypeColumns$3(DataType x$3) {
        return x$3 instanceof NullType;
    }

    public static final /* synthetic */ boolean $anonfun$dropNullTypeColumns$4(DataType x$4) {
        return x$4 instanceof NullType;
    }

    private final Column generateSelectExpr$1(StructField sf, Seq nameStack) {
        MapType mapType;
        ArrayType arrayType;
        DataType dataType = sf.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Column[] nested = (Column[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> {
                if (f.dataType() instanceof NullType) {
                    return None$.MODULE$;
                }
                return new Some((Object)this.generateSelectExpr$1((StructField)f, (Seq)nameStack.$colon$plus((Object)sf.name())));
            }, ClassTag$.MODULE$.apply(Column.class));
            return functions$.MODULE$.struct((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)nested)).alias(sf.name());
        }
        if (dataType instanceof ArrayType && this.typeExistsRecursively((DataType)(arrayType = (ArrayType)dataType), (Function1<DataType, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$dropNullTypeColumns$3(x$3)))) {
            String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name())).name();
            throw new DeltaAnalysisException("DELTA_COMPLEX_TYPE_COLUMN_CONTAINS_NULL_TYPE", (String[])((Object[])new String[]{colName, "ArrayType"}), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3(), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        if (dataType instanceof MapType && this.typeExistsRecursively((DataType)(mapType = (MapType)dataType), (Function1<DataType, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$dropNullTypeColumns$4(x$4)))) {
            String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name())).name();
            throw new DeltaAnalysisException("DELTA_COMPLEX_TYPE_COLUMN_CONTAINS_NULL_TYPE", (String[])((Object[])new String[]{colName, "NullType"}), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3(), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name())).name();
        return functions$.MODULE$.col(colName).alias(sf.name());
    }

    private static final Seq recurseAndRemove$1(StructType struct) {
        return (Seq)struct.flatMap((Function1 & Serializable)x0$1 -> {
            DataType n;
            DataType s;
            StructField structField = x0$1;
            if (structField != null && (s = structField.dataType()) instanceof StructType) {
                StructType structType = (StructType)s;
                StructType x$1 = StructType$.MODULE$.apply(SchemaUtils$.recurseAndRemove$1(structType));
                String x$2 = structField.copy$default$1();
                boolean x$3 = structField.copy$default$3();
                Metadata x$4 = structField.copy$default$4();
                return new Some((Object)structField.copy(x$2, (DataType)x$1, x$3, x$4));
            }
            if (structField != null && (n = structField.dataType()) instanceof NullType) {
                return None$.MODULE$;
            }
            return new Some((Object)structField);
        });
    }

    private static final Option findNullTypeColumnRec$1(StructType s, Seq nameStack) {
        Seq nullFields = (Seq)s.flatMap((Function1 & Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                DataType n = structField.dataType();
                if (n instanceof NullType) {
                    return new Some((Object)((IterableOnceOps)nameStack.$colon$plus((Object)name)).mkString("."));
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType s = structField.dataType();
                if (s instanceof StructType) {
                    StructType structType = (StructType)s;
                    return SchemaUtils$.findNullTypeColumnRec$1(structType, (Seq)nameStack.$colon$plus((Object)name));
                }
            }
            return None$.MODULE$;
        });
        return nullFields.headOption();
    }

    public static final /* synthetic */ boolean $anonfun$findNullTypeColumn$2(DataType x$5) {
        return x$5 instanceof NullType;
    }

    private static final StructField getMatchingTableField$1(StructField sourceField, scala.collection.immutable.Map tableFields, Seq sourceParentFields$1, StructType tableSchema$1) {
        Option option = tableFields.get((Object)sourceField.name());
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField tableField = (StructField)some.value();
            return tableField;
        }
        if (None$.MODULE$.equals(option)) {
            String columnPath = ((IterableOnceOps)sourceParentFields$1.$plus$plus((IterableOnce)new .colon.colon((Object)sourceField.name(), (List)Nil$.MODULE$))).mkString(".");
            throw DeltaErrors$.MODULE$.cannotResolveColumn(columnPath, tableSchema$1);
        }
        throw new MatchError((Object)option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$normalizeColumnNames$1(String f) {
        String string = f;
        String string2 = CDCReader$.MODULE$.CDC_PARTITION_COL();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = f;
        String string4 = CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ DataType $anonfun$normalizeColumnNames$3(DataType normalizedDataType$1) {
        return normalizedDataType$1;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Column $anonfun$normalizeColumnNames$2(scala.collection.immutable.Map baseFields$1, DeltaLog deltaLog$2, StructType baseSchema$1, StructField field) {
        block10: {
            block9: {
                block8: {
                    var8_4 = false;
                    var9_5 = null;
                    var10_6 = baseFields$1.get((Object)field.name());
                    if (!(var10_6 instanceof Some)) break block8;
                    var11_7 = (Some)var10_6;
                    original = (StructField)var11_7.value();
                    normalizedDataType = SchemaUtils$.MODULE$.normalizeColumnNamesInDataType(deltaLog$2, field.dataType(), original.dataType(), (Seq<String>)new .colon.colon((Object)field.name(), (List)Nil$.MODULE$), baseSchema$1);
                    v0 = field.dataType();
                    var14_10 = normalizedDataType;
                    v1 = v0 == null ? var14_10 != null : v0.equals(var14_10) == false;
                    v2 = new Tuple2((Object)original.name(), (Object)Option$.MODULE$.when(v1, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$normalizeColumnNames$3(org.apache.spark.sql.types.DataType ), ()Lorg/apache/spark/sql/types/DataType;)((DataType)normalizedDataType)));
                    break block9;
                }
                if (!None$.MODULE$.equals(var10_6)) ** GOTO lbl-1000
                var8_4 = true;
                var9_5 = var10_6;
                v3 = field.name();
                var15_11 = CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME();
                if (!(v3 == null ? var15_11 != null : v3.equals(var15_11) == false)) ** GOTO lbl-1000
                v4 = field.name();
                var16_12 = CDCReader$.MODULE$.CDC_PARTITION_COL();
                if (!(v4 != null ? v4.equals(var16_12) == false : var16_12 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = new Tuple2((Object)field.name(), (Object)None$.MODULE$);
                } else if (var8_4 && RowId$RowIdMetadataStructField$.MODULE$.isRowIdColumn(field)) {
                    v2 = new Tuple2((Object)field.name(), (Object)None$.MODULE$);
                } else if (var8_4 && RowCommitVersion$MetadataStructField$.MODULE$.isRowCommitVersionColumn(field)) {
                    v2 = new Tuple2((Object)field.name(), (Object)None$.MODULE$);
                } else {
                    if (var8_4) {
                        throw DeltaErrors$.MODULE$.cannotResolveColumn(field.name(), baseSchema$1);
                    }
                    throw new MatchError((Object)var10_6);
                }
            }
            var7_13 = v2;
            if (var7_13 == null) {
                throw new MatchError((Object)var7_13);
            }
            originalCase = (String)var7_13._1();
            castDataType = (Option)var7_13._2();
            var6_16 = new Tuple2((Object)originalCase, (Object)castDataType);
            originalCase = (String)var6_16._1();
            castDataType = (Option)var6_16._2();
            expression = ObjectRef.create((Object)SchemaUtils$.MODULE$.fieldToColumn(field));
            castDataType.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$normalizeColumnNames$4$adapted(scala.runtime.ObjectRef org.apache.spark.sql.types.DataType ), (Lorg/apache/spark/sql/types/DataType;)Ljava/lang/Object;)((ObjectRef)expression));
            v5 = originalCase;
            var22_20 = field.name();
            if (!(v5 == null ? var22_20 != null : v5.equals(var22_20) == false)) break block10;
            expression.elem = ((Column)expression.elem).as(originalCase);
        }
        return (Column)expression.elem;
    }

    private static final boolean isNullabilityCompatible$1(boolean existingNullable, boolean readNullable, boolean forbidTightenNullability$1) {
        if (forbidTightenNullability$1) {
            return readNullable || !existingNullable;
        }
        return existingNullable || !readNullable;
    }

    private final boolean isDatatypeReadCompatible$1(DataType existing, DataType newtype, boolean forbidTightenNullability$1, TypeWideningMode typeWideningMode$1, boolean allowMissingColumns$1) {
        Tuple2 tuple2;
        block12: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)existing, (Object)newtype)) != null) {
                    DataType e = (DataType)tuple2._1();
                    DataType n = (DataType)tuple2._2();
                    if (e instanceof StructType) {
                        StructType structType = (StructType)e;
                        if (n instanceof StructType) {
                            StructType structType2 = (StructType)n;
                            StructType x$1 = structType;
                            StructType x$2 = structType2;
                            boolean x$3 = forbidTightenNullability$1;
                            TypeWideningMode x$4 = typeWideningMode$1;
                            boolean x$5 = allowMissingColumns$1;
                            Seq<String> x$6 = this.isReadCompatible$default$6();
                            Seq<String> x$7 = this.isReadCompatible$default$7();
                            return this.isReadCompatible(x$1, x$2, x$3, x$5, x$4, x$6, x$7);
                        }
                    }
                }
                if (tuple2 != null) {
                    DataType e = (DataType)tuple2._1();
                    DataType n = (DataType)tuple2._2();
                    if (e instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)e;
                        if (n instanceof ArrayType) {
                            ArrayType arrayType2 = (ArrayType)n;
                            if (SchemaUtils$.isNullabilityCompatible$1(arrayType.containsNull(), arrayType2.containsNull(), forbidTightenNullability$1)) {
                                newtype = arrayType2.elementType();
                                existing = arrayType.elementType();
                                continue;
                            }
                            return false;
                        }
                    }
                }
                if (tuple2 == null) break block12;
                DataType e = (DataType)tuple2._1();
                DataType n = (DataType)tuple2._2();
                if (!(e instanceof MapType)) break block12;
                MapType mapType = (MapType)e;
                if (!(n instanceof MapType)) break block12;
                MapType mapType2 = (MapType)n;
                if (!SchemaUtils$.isNullabilityCompatible$1(mapType.valueContainsNull(), mapType2.valueContainsNull(), forbidTightenNullability$1) || !this.isDatatypeReadCompatible$1(mapType.keyType(), mapType2.keyType(), forbidTightenNullability$1, typeWideningMode$1, allowMissingColumns$1)) break;
                newtype = mapType2.valueType();
                existing = mapType.valueType();
            }
            return false;
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType n = (DataType)tuple2._2();
            if (e instanceof AtomicType) {
                AtomicType atomicType;
                AtomicType atomicType2 = (AtomicType)e;
                if (n instanceof AtomicType && typeWideningMode$1.shouldWidenTo(atomicType2, atomicType = (AtomicType)n)) {
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            DataType a = (DataType)tuple2._1();
            DataType b = (DataType)tuple2._2();
            DataType dataType = a;
            DataType dataType2 = b;
            return !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isReadCompatible$6(SchemaUtils$ $this, StructField newField$1, boolean forbidTightenNullability$1, TypeWideningMode typeWideningMode$1, boolean allowMissingColumns$1, StructField existingField) {
        String string = existingField.name();
        String string2 = newField$1.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!SchemaUtils$.isNullabilityCompatible$1(existingField.nullable(), newField$1.nullable(), forbidTightenNullability$1)) return false;
        if (!$this.isDatatypeReadCompatible$1(existingField.dataType(), newField$1.dataType(), forbidTightenNullability$1, typeWideningMode$1, allowMissingColumns$1)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$isReadCompatible$5(SchemaUtils$ $this, scala.collection.immutable.Map existingFields$1, boolean forbidTightenNullability$1, TypeWideningMode typeWideningMode$1, boolean allowMissingColumns$1, StructField newField) {
        return existingFields$1.get((Object)newField.name()).forall((Function1 & Serializable)existingField -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$isReadCompatible$6($this, newField, forbidTightenNullability$1, typeWideningMode$1, allowMissingColumns$1, existingField)));
    }

    private final boolean isStructReadCompatible$1(StructType existing, StructType newtype, boolean allowMissingColumns$1, Seq newPartitionColumns$1, Seq oldPartitionColumns$1, boolean forbidTightenNullability$1, TypeWideningMode typeWideningMode$1) {
        scala.collection.immutable.Map<String, StructField> existingFields = SchemaMergingUtils$.MODULE$.toFieldMap((Seq<StructField>)existing, SchemaMergingUtils$.MODULE$.toFieldMap$default$2());
        scala.collection.immutable.Set existingFieldNames = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])existing.fieldNames()), (Function1 & Serializable)x$7 -> x$7.toLowerCase(), ClassTag$.MODULE$.apply(String.class))).toSet();
        Predef$.MODULE$.assert(existingFieldNames.size() == existing.length(), (Function0 & Serializable)() -> "Delta tables don't allow field names that only differ by case");
        scala.collection.immutable.Set newFields = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])newtype.fieldNames()), (Function1 & Serializable)x$8 -> x$8.toLowerCase(), ClassTag$.MODULE$.apply(String.class))).toSet();
        Predef$.MODULE$.assert(newFields.size() == newtype.length(), (Function0 & Serializable)() -> "Delta tables don't allow field names that only differ by case");
        if (!(allowMissingColumns$1 || existingFieldNames.subsetOf((Set)newFields) && this.isPartitionCompatible((Seq<String>)newPartitionColumns$1, (Seq<String>)oldPartitionColumns$1))) {
            return false;
        }
        return newtype.forall((Function1 & Serializable)newField -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$isReadCompatible$5(this, existingFields, forbidTightenNullability$1, typeWideningMode$1, allowMissingColumns$1, newField)));
    }

    private static final String canOrNot$1(boolean can) {
        if (can) {
            return "can";
        }
        return "can not";
    }

    private static final String isOrNon$1(boolean b) {
        if (b) {
            return "";
        }
        return "non-";
    }

    private static final String missingFieldsMessage$1(scala.collection.immutable.Set fields) {
        return new StringBuilder(38).append("Specified schema is missing field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String additionalFieldsMessage$1(scala.collection.immutable.Set fields) {
        return new StringBuilder(42).append("Specified schema has additional field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String fieldNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(71).append("Field ").append(field).append(" is ").append(SchemaUtils$.isOrNon$1(specified)).append("nullable in specified ").append("schema but ").append(SchemaUtils$.isOrNon$1(existing)).append("nullable in existing schema.").toString();
    }

    private static final String arrayNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(70).append("Array field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null in specified schema ").append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString();
    }

    private static final String valueNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(75).append("Map field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null values in specified schema ").append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString();
    }

    private static final Metadata removeGenerationExpressionMetadata$1(Metadata metadata) {
        return new MetadataBuilder().withMetadata(metadata).remove(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY()).build();
    }

    private static final String metadataDifferentMessage$1(String field, Metadata specified, Metadata existing) {
        String metadataDiffMessage;
        block2: {
            Option<String> specifiedGenerationExpr = GeneratedColumn$.MODULE$.getGenerationExpressionStr(specified);
            Option<String> existingGenerationExpr = GeneratedColumn$.MODULE$.getGenerationExpressionStr(existing);
            metadataDiffMessage = "";
            Option<String> option = specifiedGenerationExpr;
            Option<String> option2 = existingGenerationExpr;
            if (option == null ? option2 != null : !option.equals(option2)) {
                metadataDiffMessage = new StringBuilder(0).append(metadataDiffMessage).append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(129).append("Specified generation expression for field ").append(field).append(" is different from existing schema:\n             |Specified: ").append(specifiedGenerationExpr.getOrElse((Function0 & Serializable)() -> "")).append("\n             |Existing:  ").append(existingGenerationExpr.getOrElse((Function0 & Serializable)() -> "")).toString()))).toString();
            }
            Metadata specifiedMetadataWithoutGenerationExpr = SchemaUtils$.removeGenerationExpressionMetadata$1(specified);
            Metadata existingMetadataWithoutGenerationExpr = SchemaUtils$.removeGenerationExpressionMetadata$1(existing);
            Metadata metadata = specifiedMetadataWithoutGenerationExpr;
            Metadata metadata2 = existingMetadataWithoutGenerationExpr;
            if (!(metadata == null ? metadata2 != null : !metadata.equals(metadata2))) break block2;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(metadataDiffMessage))) {
                metadataDiffMessage = new StringBuilder(1).append(metadataDiffMessage).append("\n").toString();
            }
            metadataDiffMessage = new StringBuilder(0).append(metadataDiffMessage).append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(116).append("Specified metadata for field ").append(field).append(" is different from existing schema:\n             |Specified: ").append(specifiedMetadataWithoutGenerationExpr).append("\n             |Existing:  ").append(existingMetadataWithoutGenerationExpr).toString()))).toString();
        }
        return metadataDiffMessage;
    }

    private static final String typeDifferenceMessage$1(String field, DataType specified, DataType existing) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(98).append("Specified type for ").append(field).append(" is different from existing schema:\n         |Specified: ").append(specified.typeName()).append("\n         |Existing:  ").append(existing.typeName()).toString()));
    }

    private static final Seq structDifference$1(StructType existing, StructType specified, String prefix) {
        scala.collection.immutable.Set specifiedFieldNames;
        scala.collection.immutable.Set existingFieldNames = Predef$.MODULE$.wrapRefArray((Object[])existing.fieldNames()).toSet();
        scala.collection.immutable.Set missingFields = (scala.collection.immutable.Set)existingFieldNames.diff((Set)(specifiedFieldNames = Predef$.MODULE$.wrapRefArray((Object[])specified.fieldNames()).toSet()));
        Nil$ missingFieldsDiffs = missingFields.isEmpty() ? Nil$.MODULE$ : new .colon.colon((Object)SchemaUtils$.missingFieldsMessage$1((scala.collection.immutable.Set)missingFields.map((Function1 & Serializable)x$9 -> new StringBuilder(0).append(prefix).append((String)x$9).toString())), (List)Nil$.MODULE$);
        scala.collection.immutable.Set extraFields = (scala.collection.immutable.Set)specifiedFieldNames.diff((Set)existingFieldNames);
        Nil$ extraFieldsDiffs = extraFields.isEmpty() ? Nil$.MODULE$ : new .colon.colon((Object)SchemaUtils$.additionalFieldsMessage$1((scala.collection.immutable.Set)extraFields.map((Function1 & Serializable)x$10 -> new StringBuilder(0).append(prefix).append((String)x$10).toString())), (List)Nil$.MODULE$);
        scala.collection.immutable.Map<String, StructField> existingFields = SchemaMergingUtils$.MODULE$.toFieldMap((Seq<StructField>)existing, SchemaMergingUtils$.MODULE$.toFieldMap$default$2());
        scala.collection.immutable.Map<String, StructField> specifiedFields = SchemaMergingUtils$.MODULE$.toFieldMap((Seq<StructField>)specified, SchemaMergingUtils$.MODULE$.toFieldMap$default$2());
        scala.collection.immutable.Set fieldsDiffs = (scala.collection.immutable.Set)existingFieldNames.intersect((Set)specifiedFieldNames).flatMap((Function1 & Serializable)name -> SchemaUtils$.fieldDifference$1((StructField)existingFields.apply(name), (StructField)specifiedFields.apply(name), prefix));
        return (Seq)((IterableOps)missingFieldsDiffs.$plus$plus((IterableOnce)extraFieldsDiffs)).$plus$plus((IterableOnce)fieldsDiffs);
    }

    private static final Seq fieldDifference$1(StructField existing, StructField specified, String prefix) {
        String name = new StringBuilder(0).append(prefix).append(existing.name()).toString();
        Nil$ nullabilityDiffs = existing.nullable() == specified.nullable() ? Nil$.MODULE$ : new .colon.colon((Object)SchemaUtils$.fieldNullabilityMessage$1(String.valueOf(name), specified.nullable(), existing.nullable()), (List)Nil$.MODULE$);
        Metadata metadata = existing.metadata();
        Metadata metadata2 = specified.metadata();
        Nil$ metadataDiffs = !(metadata != null ? !metadata.equals(metadata2) : metadata2 != null) ? Nil$.MODULE$ : new .colon.colon((Object)SchemaUtils$.metadataDifferentMessage$1(String.valueOf(name), specified.metadata(), existing.metadata()), (List)Nil$.MODULE$);
        Seq typeDiffs = SchemaUtils$.typeDifference$1(existing.dataType(), specified.dataType(), name);
        return (Seq)((IterableOps)nullabilityDiffs.$plus$plus((IterableOnce)metadataDiffs)).$plus$plus((IterableOnce)typeDiffs);
    }

    private static final Seq typeDifference$1(DataType existing, DataType specified, String field) {
        Tuple2 tuple2 = new Tuple2((Object)existing, (Object)specified);
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof StructType) {
                StructType structType = (StructType)e;
                if (s instanceof StructType) {
                    StructType structType2 = (StructType)s;
                    return SchemaUtils$.structDifference$1(structType, structType2, new StringBuilder(1).append(field).append(".").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)e;
                if (s instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)s;
                    return SchemaUtils$.arrayDifference$1(arrayType, arrayType2, new StringBuilder(2).append(field).append("[]").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof MapType) {
                MapType mapType = (MapType)e;
                if (s instanceof MapType) {
                    MapType mapType2 = (MapType)s;
                    return SchemaUtils$.mapDifference$1(mapType, mapType2, String.valueOf(field));
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            DataType dataType = e;
            DataType dataType2 = s;
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                return new .colon.colon((Object)SchemaUtils$.typeDifferenceMessage$1(field, s, e), (List)Nil$.MODULE$);
            }
        }
        return Nil$.MODULE$;
    }

    private static final Seq arrayDifference$1(ArrayType existing, ArrayType specified, String field) {
        Seq elementDiffs = SchemaUtils$.typeDifference$1(existing.elementType(), specified.elementType(), field);
        Nil$ nullabilityDiffs = existing.containsNull() == specified.containsNull() ? Nil$.MODULE$ : new .colon.colon((Object)SchemaUtils$.arrayNullabilityMessage$1(field, specified.containsNull(), existing.containsNull()), (List)Nil$.MODULE$);
        return (Seq)elementDiffs.$plus$plus((IterableOnce)nullabilityDiffs);
    }

    private static final Seq mapDifference$1(MapType existing, MapType specified, String field) {
        Seq keyDiffs = SchemaUtils$.typeDifference$1(existing.keyType(), specified.keyType(), new StringBuilder(5).append(field).append("[key]").toString());
        Seq valueDiffs = SchemaUtils$.typeDifference$1(existing.valueType(), specified.valueType(), new StringBuilder(7).append(field).append("[value]").toString());
        Nil$ nullabilityDiffs = existing.valueContainsNull() == specified.valueContainsNull() ? Nil$.MODULE$ : new .colon.colon((Object)SchemaUtils$.valueNullabilityMessage$1(field, specified.valueContainsNull(), existing.valueContainsNull()), (List)Nil$.MODULE$);
        return (Seq)((IterableOps)keyDiffs.$plus$plus((IterableOnce)valueDiffs)).$plus$plus((IterableOnce)nullabilityDiffs);
    }

    public static final /* synthetic */ boolean $anonfun$findNestedFieldIgnoreCase$1(String fieldName$1, StructField x$11) {
        return x$11.name().equalsIgnoreCase(fieldName$1);
    }

    private final Option findRecursively$1(DataType dataType, Seq fieldNames, boolean includeCollections) {
        while (true) {
            SeqOps seqOps;
            boolean bl;
            Tuple3 tuple3;
            if ((tuple3 = new Tuple3((Object)fieldNames, (Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)includeCollections))) != null) {
                SeqOps seqOps2;
                Seq seq = (Seq)tuple3._1();
                DataType struct = (DataType)tuple3._2();
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) >= 0) {
                    String fieldName = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                    Seq names = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                    if (struct instanceof StructType) {
                        StructType structType = (StructType)struct;
                        Option field = structType.find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findNestedFieldIgnoreCase$1(fieldName, x$11)));
                        if (names.isEmpty() || field.isEmpty()) {
                            return field;
                        }
                        fieldNames = names;
                        dataType = ((StructField)field.get()).dataType();
                        continue;
                    }
                }
            }
            if (tuple3 != null && !(bl = BoxesRunTime.unboxToBoolean((Object)tuple3._3()))) {
                return None$.MODULE$;
            }
            if (tuple3 != null) {
                String string;
                SeqOps seqOps3;
                Seq seq = (Seq)tuple3._1();
                DataType dataType2 = (DataType)tuple3._2();
                boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && "key".equals(string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) && dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    DataType keyType = mapType.keyType();
                    if (bl2) {
                        return new Some((Object)new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()));
                    }
                }
            }
            if (tuple3 != null) {
                SeqOps seqOps4;
                Seq seq = (Seq)tuple3._1();
                DataType dataType3 = (DataType)tuple3._2();
                boolean bl3 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1) >= 0) {
                    String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0);
                    Seq names = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1);
                    if ("key".equals(string) && dataType3 instanceof MapType) {
                        MapType mapType = (MapType)dataType3;
                        DataType keyType = mapType.keyType();
                        if (bl3) {
                            fieldNames = names;
                            dataType = keyType;
                            continue;
                        }
                    }
                }
            }
            if (tuple3 != null) {
                String string;
                SeqOps seqOps5;
                Seq seq = (Seq)tuple3._1();
                DataType dataType4 = (DataType)tuple3._2();
                boolean bl4 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1) == 0 && "value".equals(string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0)) && dataType4 instanceof MapType) {
                    MapType mapType = (MapType)dataType4;
                    DataType valueType = mapType.valueType();
                    boolean isNullable = mapType.valueContainsNull();
                    if (bl4) {
                        return new Some((Object)new StructField("value", valueType, isNullable, StructField$.MODULE$.apply$default$4()));
                    }
                }
            }
            if (tuple3 != null) {
                SeqOps seqOps6;
                Seq seq = (Seq)tuple3._1();
                DataType dataType5 = (DataType)tuple3._2();
                boolean bl5 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1) >= 0) {
                    String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0);
                    Seq names = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1);
                    if ("value".equals(string) && dataType5 instanceof MapType) {
                        MapType mapType = (MapType)dataType5;
                        DataType valueType = mapType.valueType();
                        if (bl5) {
                            fieldNames = names;
                            dataType = valueType;
                            continue;
                        }
                    }
                }
            }
            if (tuple3 != null) {
                String string;
                SeqOps seqOps7;
                Seq seq = (Seq)tuple3._1();
                DataType dataType6 = (DataType)tuple3._2();
                boolean bl6 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps7 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 1) == 0 && "element".equals(string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 0)) && dataType6 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType6;
                    DataType elementType = arrayType.elementType();
                    boolean isNullable = arrayType.containsNull();
                    if (bl6) {
                        return new Some((Object)new StructField("element", elementType, isNullable, StructField$.MODULE$.apply$default$4()));
                    }
                }
            }
            if (tuple3 == null) break;
            Seq seq = (Seq)tuple3._1();
            DataType dataType7 = (DataType)tuple3._2();
            boolean bl7 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) < 0) break;
            String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Seq names = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!"element".equals(string) || !(dataType7 instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType7;
            DataType elementType = arrayType.elementType();
            if (!bl7) break;
            fieldNames = names;
            dataType = elementType;
        }
        return None$.MODULE$;
    }

    private static final /* synthetic */ String columnPath$lzycompute$1(LazyRef columnPath$lzy$1, Seq currentPathWithNestedField$1) {
        String string;
        LazyRef lazyRef = columnPath$lzy$1;
        synchronized (lazyRef) {
            string = columnPath$lzy$1.initialized() ? (String)columnPath$lzy$1.value() : (String)columnPath$lzy$1.initialize((Object)new UnresolvedAttribute(currentPathWithNestedField$1).name());
        }
        return string;
    }

    private static final String columnPath$1(LazyRef columnPath$lzy$1, Seq currentPathWithNestedField$1) {
        if (columnPath$lzy$1.initialized()) {
            return (String)columnPath$lzy$1.value();
        }
        return SchemaUtils$.columnPath$lzycompute$1(columnPath$lzy$1, currentPathWithNestedField$1);
    }

    public static final /* synthetic */ boolean $anonfun$findColumnPosition$1(Function2 resolver$1, String currentFieldName$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)currentFieldName$1));
    }

    private final Seq findRecursively$2(Seq searchPath, DataType currentType, Seq currentPath, Function2 resolver$1, DataType schema$1) {
        DataType struct;
        if (searchPath.isEmpty()) {
            return Nil$.MODULE$;
        }
        String currentFieldName = (String)searchPath.head();
        Seq currentPathWithNestedField = (Seq)currentPath.$colon$plus((Object)currentFieldName);
        Tuple2 tuple2 = new Tuple2((Object)currentType, (Object)currentFieldName);
        if (tuple2 != null && (struct = (DataType)tuple2._1()) instanceof StructType) {
            StructType structType = (StructType)struct;
            LazyRef columnPath$lzy = new LazyRef();
            int pos = structType.indexWhere((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findColumnPosition$1(resolver$1, currentFieldName, f)));
            if (pos == -1) {
                throw DeltaErrors$.MODULE$.columnNotInSchemaException(SchemaUtils$.columnPath$1(columnPath$lzy, currentPathWithNestedField), schema$1);
            }
            Seq childPosition = this.findRecursively$2((Seq)searchPath.tail(), structType.apply(pos).dataType(), currentPathWithNestedField, resolver$1, schema$1);
            int n = pos;
            return (Seq)childPosition.$plus$colon((Object)BoxesRunTime.boxToInteger((int)n));
        }
        if (tuple2 != null) {
            DataType map = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (map instanceof MapType) {
                MapType mapType = (MapType)map;
                if ("key".equals(string)) {
                    Seq childPosition = this.findRecursively$2((Seq)searchPath.tail(), mapType.keyType(), currentPathWithNestedField, resolver$1, schema$1);
                    int n = this.MAP_KEY_INDEX();
                    return (Seq)childPosition.$plus$colon((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        if (tuple2 != null) {
            DataType map = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (map instanceof MapType) {
                MapType mapType = (MapType)map;
                if ("value".equals(string)) {
                    Seq childPosition = this.findRecursively$2((Seq)searchPath.tail(), mapType.valueType(), currentPathWithNestedField, resolver$1, schema$1);
                    int n = this.MAP_VALUE_INDEX();
                    return (Seq)childPosition.$plus$colon((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof MapType) {
            throw DeltaErrors$.MODULE$.foundMapTypeColumnException(this.prettyFieldName((Seq<String>)((Seq)currentPath.$colon$plus((Object)"key"))), this.prettyFieldName((Seq<String>)((Seq)currentPath.$colon$plus((Object)"value"))), schema$1);
        }
        if (tuple2 != null) {
            DataType array = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (array instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)array;
                if ("element".equals(string)) {
                    Seq childPosition = this.findRecursively$2((Seq)searchPath.tail(), arrayType.elementType(), currentPathWithNestedField, resolver$1, schema$1);
                    int n = this.ARRAY_ELEMENT_INDEX();
                    return (Seq)childPosition.$plus$colon((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof ArrayType) {
            throw DeltaErrors$.MODULE$.incorrectArrayAccessByName(this.prettyFieldName((Seq<String>)((Seq)currentPath.$colon$plus((Object)"element"))), this.prettyFieldName((Seq<String>)currentPath), schema$1);
        }
        throw DeltaErrors$.MODULE$.columnPathNotNested(currentFieldName, currentType, (Seq<String>)currentPath, schema$1);
    }

    private static final Seq findRecursively$default$3$1() {
        return Nil$.MODULE$;
    }

    private static final void verify$1(boolean cond, Function0 err) {
        if (!cond) {
            throw DeltaErrors$.MODULE$.cannotChangeDataType((String)err.apply());
        }
    }

    private static final void verifyNullability$1(boolean fn, boolean tn, Seq columnPath) {
        SchemaUtils$.verify$1(tn || !fn, (Function0 & Serializable)() -> new StringBuilder(26).append("tightening nullability of ").append(new UnresolvedAttribute(columnPath).name()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$canChangeDataType$3(Function2 resolver$2, StructField toField$1, StructField field) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$2.apply((Object)field.name(), (Object)toField$1.name()));
    }

    public static final /* synthetic */ void $anonfun$canChangeDataType$2(SchemaUtils$ $this, StructField[] fromFields$1, Function2 resolver$2, scala.collection.mutable.Set remainingFields$1, Seq columnPath$3, BooleanRef addingColumns$1, boolean failOnAmbiguousChanges$1, DeltaColumnMappingMode columnMappingMode$1, boolean allowTypeWidening$1, StructField toField) {
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])fromFields$1), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$canChangeDataType$3(resolver$2, toField, field)));
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField fromField = (StructField)some.value();
            remainingFields$1.$minus$eq((Object)fromField);
            Seq newPath = (Seq)columnPath$3.$colon$plus((Object)fromField.name());
            SchemaUtils$.verifyNullability$1(fromField.nullable(), toField.nullable(), newPath);
            $this.check$1(fromField.dataType(), toField.dataType(), newPath, resolver$2, failOnAmbiguousChanges$1, columnMappingMode$1, allowTypeWidening$1);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            addingColumns$1.elem = true;
            SchemaUtils$.verify$1(toField.nullable(), (Function0 & Serializable)() -> new StringBuilder(27).append("adding non-nullable column ").append(new UnresolvedAttribute((Seq)columnPath$3.$colon$plus((Object)toField.name())).name()).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void check$1(DataType fromDt, DataType toDt, Seq columnPath, Function2 resolver$2, boolean failOnAmbiguousChanges$1, DeltaColumnMappingMode columnMappingMode$1, boolean allowTypeWidening$1) {
        Tuple2 tuple2;
        while (true) {
            if ((tuple2 = new Tuple2((Object)fromDt, (Object)toDt)) != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType fromElement = arrayType.elementType();
                    boolean fn = arrayType.containsNull();
                    if (dataType2 instanceof ArrayType) {
                        ArrayType arrayType2 = (ArrayType)dataType2;
                        DataType toElement = arrayType2.elementType();
                        boolean tn = arrayType2.containsNull();
                        SchemaUtils$.verifyNullability$1(fn, tn, columnPath);
                        columnPath = (Seq)columnPath.$colon$plus((Object)"element");
                        toDt = toElement;
                        fromDt = fromElement;
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            DataType fromKey = mapType.keyType();
            DataType fromValue = mapType.valueType();
            boolean fn = mapType.valueContainsNull();
            if (!(dataType3 instanceof MapType)) break;
            MapType mapType2 = (MapType)dataType3;
            DataType toKey = mapType2.keyType();
            DataType toValue = mapType2.valueType();
            boolean tn = mapType2.valueContainsNull();
            SchemaUtils$.verifyNullability$1(fn, tn, columnPath);
            this.check$1(fromKey, toKey, (Seq)columnPath.$colon$plus((Object)"key"), resolver$2, failOnAmbiguousChanges$1, columnMappingMode$1, allowTypeWidening$1);
            columnPath = (Seq)columnPath.$colon$plus((Object)"value");
            toDt = toValue;
            fromDt = fromValue;
        }
        if (tuple2 != null) {
            DataType f = (DataType)tuple2._1();
            DataType t = (DataType)tuple2._2();
            if (f instanceof StructType) {
                StructType structType = (StructType)f;
                StructField[] fromFields = structType.fields();
                if (t instanceof StructType) {
                    StructType structType2 = (StructType)t;
                    StructField[] toFields = structType2.fields();
                    scala.collection.mutable.Set remainingFields = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
                    remainingFields.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])fromFields));
                    BooleanRef addingColumns = BooleanRef.create((boolean)false);
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])toFields), (Function1 & Serializable)toField -> {
                        SchemaUtils$.$anonfun$canChangeDataType$2(this, fromFields, resolver$2, remainingFields, columnPath, addingColumns, failOnAmbiguousChanges$1, columnMappingMode$1, allowTypeWidening$1, toField);
                        return BoxedUnit.UNIT;
                    });
                    String columnName = new UnresolvedAttribute(columnPath).name();
                    if (failOnAmbiguousChanges$1 && remainingFields.nonEmpty() && addingColumns.elem) {
                        throw DeltaErrors$.MODULE$.ambiguousDataTypeChange(columnName, structType, structType2);
                    }
                    DeltaColumnMappingMode deltaColumnMappingMode = columnMappingMode$1;
                    NoMapping$ noMapping$ = NoMapping$.MODULE$;
                    if (deltaColumnMappingMode == null) {
                        if (noMapping$ != null) {
                            return;
                        }
                    } else if (!deltaColumnMappingMode.equals(noMapping$)) return;
                    SchemaUtils$.verify$1(remainingFields.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(21).append("dropping column(s) [").append(((IterableOnceOps)remainingFields.map((Function1 & Serializable)x$19 -> x$19.name())).mkString(", ")).append("]").append((Object)(columnPath.nonEmpty() ? new StringBuilder(6).append(" from ").append(columnName).toString() : "")).toString());
                    return;
                }
            }
        }
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            if (fromDataType instanceof AtomicType) {
                AtomicType atomicType = (AtomicType)fromDataType;
                if (toDataType instanceof AtomicType) {
                    AtomicType atomicType2 = (AtomicType)toDataType;
                    if (allowTypeWidening$1) {
                        SchemaUtils$.verify$1(TypeWidening$.MODULE$.isTypeChangeSupported(atomicType, atomicType2), (Function0 & Serializable)() -> new StringBuilder(32).append("changing data type of ").append(new UnresolvedAttribute(columnPath).name()).append(" ").append("from ").append(atomicType).append(" to ").append(atomicType2).toString());
                        return;
                    }
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        DataType fromDataType = (DataType)tuple2._1();
        DataType toDataType = (DataType)tuple2._2();
        DataType dataType = fromDataType;
        DataType dataType4 = toDataType;
        SchemaUtils$.verify$1(!(dataType != null ? !dataType.equals(dataType4) : dataType4 != null), (Function0 & Serializable)() -> new StringBuilder(32).append("changing data type of ").append(new UnresolvedAttribute(columnPath).name()).append(" ").append("from ").append(fromDataType).append(" to ").append(toDataType).toString());
    }

    public static final /* synthetic */ boolean $anonfun$changeDataType$2(Function2 resolver$3, StructField toField$2, StructField field) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$3.apply((Object)field.name(), (Object)toField$2.name()));
    }

    private final DataType transform$1(Seq path, DataType dt, Option colName$1, Function3 tf$1) {
        DataType dataType;
        DataType dataType2 = dt;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            StructType newStruct = colName$1.isEmpty() || ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)colName$1.contains((Object)f.name()))) ? (StructType)tf$1.apply((Object)path, (Object)structType, this.DELTA_COL_RESOLVER()) : structType;
            dataType = new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])newStruct.fields()), (Function1 & Serializable)field -> {
                DataType x$1 = this.transform$1((Seq)path.$colon$plus((Object)field.name()), field.dataType(), colName$1, tf$1);
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            }, ClassTag$.MODULE$.apply(StructField.class)));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            ArrayType newArray = colName$1.isEmpty() || colName$1.contains((Object)"element") ? (ArrayType)tf$1.apply((Object)path, (Object)arrayType, this.DELTA_COL_RESOLVER()) : arrayType;
            dataType = newArray.copy(this.transform$1((Seq)path.$colon$plus((Object)"element"), newArray.elementType(), colName$1, tf$1), newArray.copy$default$2());
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            MapType newMap = colName$1.isEmpty() || colName$1.contains((Object)"key") || colName$1.contains((Object)"value") ? (MapType)tf$1.apply((Object)path, (Object)mapType, this.DELTA_COL_RESOLVER()) : mapType;
            dataType = newMap.copy(this.transform$1((Seq)path.$colon$plus((Object)"key"), newMap.keyType(), colName$1, tf$1), this.transform$1((Seq)path.$colon$plus((Object)"value"), newMap.valueType(), colName$1, tf$1), newMap.copy$default$3());
        } else {
            dataType = dataType2;
        }
        DataType newDt = dataType;
        return newDt;
    }

    public static final /* synthetic */ boolean $anonfun$transformColumns$6(Seq fullPath$1, Function2 resolver$4, Tuple2 x$25) {
        return ((IterableOnceOps)((IterableOps)x$25._1()).zip((IterableOnce)fullPath$1)).forall(resolver$4.tupled());
    }

    public static final /* synthetic */ String $anonfun$findInvalidColumnNames$2(char x$26) {
        return Character.toString(x$26);
    }

    public static final /* synthetic */ boolean $anonfun$findInvalidColumnNames$1(Seq badChars$1, String colName) {
        return ((IterableOnceOps)badChars$1.map((Function1 & Serializable)x$26 -> SchemaUtils$.$anonfun$findInvalidColumnNames$2(BoxesRunTime.unboxToChar((Object)x$26)))).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)colName.contains(x$1)));
    }

    private final StructField checkField$1(Seq path, StructField f, Function2 r, boolean allowUnenforceableNotNulls$1) {
        StructField structField = f;
        if (structField != null) {
            String name = structField.name();
            DataType dataType = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata metadata = structField.metadata();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                DataType nullableElementType = this.typeAsNullable(elementType);
                DataType dataType2 = elementType;
                DataType dataType3 = nullableElementType;
                if ((dataType2 == null ? dataType3 != null : !dataType2.equals(dataType3)) && !allowUnenforceableNotNulls$1) {
                    throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)f.name()))), elementType, "element");
                }
                return new StructField(name, (DataType)new ArrayType(nullableElementType, containsNull), nullable, metadata);
            }
        }
        if (structField != null) {
            String name = structField.name();
            DataType dataType = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata metadata = structField.metadata();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean containsNull = mapType.valueContainsNull();
                DataType nullableKeyType = this.typeAsNullable(keyType);
                DataType nullableValueType = this.typeAsNullable(valueType);
                DataType dataType4 = keyType;
                DataType dataType5 = nullableKeyType;
                if ((dataType4 == null ? dataType5 != null : !dataType4.equals(dataType5)) && !allowUnenforceableNotNulls$1) {
                    throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)structField.name()))), keyType, "key");
                }
                DataType dataType6 = valueType;
                DataType dataType7 = nullableValueType;
                if ((dataType6 == null ? dataType7 != null : !dataType6.equals(dataType7)) && !allowUnenforceableNotNulls$1) {
                    throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)structField.name()))), valueType, "value");
                }
                return new StructField(name, (DataType)new MapType(nullableKeyType, nullableValueType, containsNull), nullable, metadata);
            }
        }
        if (structField != null) {
            StructField structField2 = structField;
            return structField2;
        }
        throw new MatchError((Object)structField);
    }

    public static final /* synthetic */ void $anonfun$collectUsedColumns$6(ArrayBuffer result$1, Expression child) {
        SchemaUtils$.traverseAllPaths$1(child, result$1).foreach((Function1 & Serializable)x$31 -> (ArrayBuffer)result$1.$plus$eq(x$31));
    }

    private static final Option traverseAllPaths$1(Expression exp, ArrayBuffer result$1) {
        Expression expression = exp;
        if (expression instanceof GetStructField) {
            GetStructField getStructField = (GetStructField)expression;
            Expression child2 = getStructField.child();
            Option option = getStructField.name();
            if (option instanceof Some) {
                Some some = (Some)option;
                String name = (String)some.value();
                return SchemaUtils$.traverseAllPaths$1(child2, result$1).map((Function1 & Serializable)x$27 -> (Seq)x$27.$colon$plus((Object)name));
            }
        }
        if (expression instanceof GetMapValue) {
            GetMapValue getMapValue = (GetMapValue)expression;
            Expression child3 = getMapValue.child();
            Expression key = getMapValue.key();
            SchemaUtils$.traverseAllPaths$1(key, result$1).foreach((Function1 & Serializable)x$28 -> (ArrayBuffer)result$1.$plus$eq(x$28));
            return SchemaUtils$.traverseAllPaths$1(child3, result$1).map((Function1 & Serializable)childPath -> {
                result$1.$plus$eq(childPath.$colon$plus((Object)"key"));
                return (Seq)childPath.$colon$plus((Object)"value");
            });
        }
        if (expression instanceof GetArrayItem) {
            GetArrayItem getArrayItem = (GetArrayItem)expression;
            return SchemaUtils$.traverseAllPaths$1(getArrayItem.child(), result$1).map((Function1 & Serializable)x$29 -> (Seq)x$29.$colon$plus((Object)"element"));
        }
        if (expression instanceof GetArrayStructFields) {
            GetArrayStructFields getArrayStructFields = (GetArrayStructFields)expression;
            return SchemaUtils$.traverseAllPaths$1(getArrayStructFields.child(), result$1).map((Function1 & Serializable)x$30 -> (Seq)((SeqOps)x$30.$colon$plus((Object)"element")).$colon$plus((Object)getArrayStructFields.field().name()));
        }
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            return new Some((Object)new .colon.colon((Object)attributeReference.name(), (List)Nil$.MODULE$));
        }
        exp.children().foreach((Function1 & Serializable)child -> {
            SchemaUtils$.$anonfun$collectUsedColumns$6(result$1, child);
            return BoxedUnit.UNIT;
        });
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$fallbackContainsDependentExpression$2(Function2 resolver$5, Tuple2 pair) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$5.apply(pair._1(), pair._2()));
    }

    public static final /* synthetic */ void $anonfun$fallbackContainsDependentExpression$1(Seq columnToChange$1, Function2 resolver$5, Object nonLocalReturnKey1$1, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof UnresolvedAttribute) {
            boolean prefixMatched;
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            boolean bl = prefixMatched = columnToChange$1.size() <= unresolvedAttribute.nameParts().size() && ((IterableOnceOps)unresolvedAttribute.nameParts().zip((IterableOnce)columnToChange$1)).forall((Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$fallbackContainsDependentExpression$2(resolver$5, pair)));
            if (prefixMatched) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$containsDependentExpression$2(Function2 resolver$6, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String exprFieldName = (String)tuple2._1();
            String changedFieldName = (String)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)resolver$6.apply((Object)exprFieldName, (Object)changedFieldName));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$containsDependentExpression$1(Seq columnToChange$2, Function2 resolver$6, Seq exprColumn) {
        return ((IterableOnceOps)exprColumn.zip((IterableOnce)columnToChange$2)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$containsDependentExpression$2(resolver$6, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$checkForTimestampNTZColumnsRecursively$1(DataType x$33) {
        return x$33 instanceof TimestampNTZType;
    }

    public static final /* synthetic */ void $anonfun$recordUndefinedTypes$2(DeltaLog deltaLog$3, String className) {
        DeltaLog x$1 = deltaLog$3;
        String x$2 = "delta.undefined.type";
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)}));
        scala.collection.immutable.Map<TagDefinition, String> x$4 = MODULE$.recordDeltaEvent$default$3();
        Option<Path> x$5 = MODULE$.recordDeltaEvent$default$5();
        MODULE$.recordDeltaEvent(x$1, "delta.undefined.type", x$4, x$3, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$removeExistsDefaultMetadata$2(StructField x$38) {
        return x$38.metadata().contains(ResolveDefaultColumnsUtils$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
    }

    private SchemaUtils$() {
    }

    public static final /* synthetic */ Object $anonfun$normalizeColumnNames$4$adapted(ObjectRef expression$1, DataType castType) {
        expression$1.elem = ((Column)expression$1.elem).cast(castType);
        return BoxedUnit.UNIT;
    }
}

