/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.delta.util.TimestampFormatter;

public final class DateTimeUtils$ {
    public static final DateTimeUtils$ MODULE$ = new DateTimeUtils$();
    private static final long NANOS_PER_MICROS = 1000L;
    private static final long MICROS_PER_MILLIS = 1000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long MICROS_PER_SECOND = MODULE$.MILLIS_PER_SECOND() * MODULE$.MICROS_PER_MILLIS();
    private static final long NANOS_PER_MILLIS = MODULE$.NANOS_PER_MICROS() * MODULE$.MICROS_PER_MILLIS();
    private static final long NANOS_PER_SECOND = MODULE$.NANOS_PER_MICROS() * MODULE$.MICROS_PER_SECOND();
    private static final long MICROS_PER_DAY = MODULE$.SECONDS_PER_DAY() * MODULE$.MICROS_PER_SECOND();
    private static final long MILLIS_PER_MINUTE = 60L * MODULE$.MILLIS_PER_SECOND();
    private static final long MILLIS_PER_HOUR = 60L * MODULE$.MILLIS_PER_MINUTE();
    private static final long MILLIS_PER_DAY = MODULE$.SECONDS_PER_DAY() * MODULE$.MILLIS_PER_SECOND();

    public final long NANOS_PER_MICROS() {
        return NANOS_PER_MICROS;
    }

    public final long MICROS_PER_MILLIS() {
        return MICROS_PER_MILLIS;
    }

    public final long MILLIS_PER_SECOND() {
        return MILLIS_PER_SECOND;
    }

    public final long SECONDS_PER_DAY() {
        return SECONDS_PER_DAY;
    }

    public final long MICROS_PER_SECOND() {
        return MICROS_PER_SECOND;
    }

    public final long NANOS_PER_MILLIS() {
        return NANOS_PER_MILLIS;
    }

    public final long NANOS_PER_SECOND() {
        return NANOS_PER_SECOND;
    }

    public final long MICROS_PER_DAY() {
        return MICROS_PER_DAY;
    }

    public final long MILLIS_PER_MINUTE() {
        return MILLIS_PER_MINUTE;
    }

    public final long MILLIS_PER_HOUR() {
        return MILLIS_PER_HOUR;
    }

    public final long MILLIS_PER_DAY() {
        return MILLIS_PER_DAY;
    }

    public TimeZone defaultTimeZone() {
        return TimeZone.getDefault();
    }

    public TimeZone getTimeZone(String timeZoneId) {
        ZoneId zoneId = ZoneId.of(timeZoneId, ZoneId.SHORT_IDS);
        return TimeZone.getTimeZone(zoneId);
    }

    public String timestampToString(TimestampFormatter tf, long us) {
        return tf.format(us);
    }

    public long instantToMicros(Instant instant) {
        long us = Math.multiplyExact(instant.getEpochSecond(), this.MICROS_PER_SECOND());
        long result = Math.addExact(us, TimeUnit.NANOSECONDS.toMicros(instant.getNano()));
        return result;
    }

    public Instant microsToInstant(long us) {
        long secs = Math.floorDiv(us, this.MICROS_PER_SECOND());
        long mos = Math.floorMod(us, this.MICROS_PER_SECOND());
        return Instant.ofEpochSecond(secs, mos * this.NANOS_PER_MICROS());
    }

    public int instantToDays(Instant instant) {
        long seconds = instant.getEpochSecond();
        long days = Math.floorDiv(seconds, this.SECONDS_PER_DAY());
        return (int)days;
    }

    public long fromJavaTimestamp(Timestamp t) {
        if (t != null) {
            return TimeUnit.MILLISECONDS.toMicros(t.getTime()) + TimeUnit.NANOSECONDS.toMicros(t.getNanos()) % this.NANOS_PER_MICROS();
        }
        return 0L;
    }

    private DateTimeUtils$() {
    }
}

