/*
 * Decompiled with CFR 0.152.
 */
package io.frama.parisni.spark.dataframe;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.LazyLogging$class;
import com.typesafe.scalalogging.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class DFTool$
implements LazyLogging {
    public static final DFTool$ MODULE$;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DFTool$();
    }

    private Logger logger$lzycompute() {
        DFTool$ dFTool$ = this;
        synchronized (dFTool$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public Dataset<Row> applySchema(Dataset<Row> df, StructType schema) {
        StructType mandatoryColumns = this.getMandatoryColumns(schema);
        StructType optionalColumns = this.getOptionalColumns(schema);
        this.existColumns(df, mandatoryColumns);
        Dataset<Row> dfWithCol = this.addMissingColumns(df, optionalColumns);
        Dataset<Row> dfReorder = this.reorderColumns(dfWithCol, schema);
        Dataset<Row> result2 = this.castColumns(dfReorder, schema);
        return result2;
    }

    public Dataset<Row> reorderColumns(Dataset<Row> df, StructType schema) {
        String[] reorderedColumnNames = schema.fieldNames();
        return df.select((String)Predef$.MODULE$.refArrayOps((Object[])reorderedColumnNames).head(), Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])reorderedColumnNames).tail()));
    }

    public Dataset<Row> castColumns(Dataset<Row> df, StructType schema) {
        Dataset<Row> newDf = this.validateNull(df, schema);
        Dataset<Row> trDf = Predef$.MODULE$.refArrayOps((Object[])newDf.schema().fields()).foldLeft(df, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Dataset<Row> apply(Dataset<Row> df, StructField s2) {
                return df.withColumn(s2.name(), df.apply(s2.name()).cast(s2.dataType()));
            }
        });
        return this.validateNull(trDf, schema);
    }

    public Dataset<Row> validateNull(Dataset<Row> df, StructType schema) {
        return df.sparkSession().createDataFrame(df.rdd(), schema);
    }

    public void existColumns(Dataset<Row> df, StructType columnsNeeded) {
        ObjectRef<String> tmp = ObjectRef.create("");
        String[] columns = df.columns();
        Predef$.MODULE$.refArrayOps((Object[])columnsNeeded.fieldNames()).foreach(new Serializable(tmp, columns){
            public static final long serialVersionUID = 0L;
            private final ObjectRef tmp$1;
            private final String[] columns$1;

            public final void apply(String column) {
                if (!Predef$.MODULE$.refArrayOps((Object[])this.columns$1).contains(column)) {
                    this.tmp$1.elem = new StringBuilder().append((Object)((String)this.tmp$1.elem)).append((Object)new StringBuilder().append((Object)column).append((Object)", ").toString()).toString();
                }
            }
            {
                this.tmp$1 = tmp$1;
                this.columns$1 = columns$1;
            }
        });
        String string2 = (String)tmp.elem;
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return;
        }
        String arg$macro$1 = (String)tmp.elem;
        throw new Exception(new StringOps("Missing columns in the data: [%s]").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1})));
    }

    public StructType getMandatoryColumns(StructType schema) {
        return StructType$.MODULE$.apply((Seq)schema.filter((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField f) {
                return !f.metadata().contains("default");
            }
        })));
    }

    public StructType getOptionalColumns(StructType schema) {
        return StructType$.MODULE$.apply((Seq)schema.filter((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField f) {
                return f.metadata().contains("default");
            }
        })));
    }

    public Dataset<Row> addMissingColumns(Dataset<Row> df, StructType missingSchema) {
        ObjectRef<Dataset<Row>> result2 = ObjectRef.create(df);
        Predef$.MODULE$.refArrayOps((Object[])missingSchema.fields()).foreach(new Serializable(df, result2){
            public static final long serialVersionUID = 0L;
            private final Dataset df$1;
            private final ObjectRef result$1;

            public final void apply(StructField f) {
                BoxedUnit boxedUnit;
                if (DFTool$.MODULE$.logger().underlying().isDebugEnabled()) {
                    String arg$macro$2 = f.name();
                    DFTool$.MODULE$.logger().underlying().debug(new StringOps("Added %s column").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$2})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (!Predef$.MODULE$.refArrayOps((Object[])this.df$1.columns()).contains(f.name())) {
                    this.result$1.elem = ((Dataset)this.result$1.elem).withColumn(f.name(), functions$.MODULE$.lit((Object)f.metadata().getString("default")).cast(f.dataType()));
                }
            }
            {
                this.df$1 = df$1;
                this.result$1 = result$1;
            }
        });
        return (Dataset)result2.elem;
    }

    public Dataset<Row> createEmptyDataFrame(SparkSession spark, StructType schema) {
        return spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), schema);
    }

    public Dataset<Row> removeNullRows(Dataset<Row> df, String column) {
        BoxedUnit boxedUnit;
        df.createOrReplaceTempView("nullTmp");
        SparkSession spark = df.sparkSession();
        String arg$macro$3 = column;
        Dataset nulltmp = spark.sql(new StringOps("select * from nullTmp where %s IS NULL").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$3})));
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringBuilder().append(nulltmp.count()).append((Object)" missing rows").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String arg$macro$4 = column;
        String arg$macro$5 = column;
        return spark.sql(new StringOps("select * from nullTmp where %s IS NOT NULL and trim(%s) !=''").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$4, arg$macro$5})));
    }

    /*
     * WARNING - void declaration
     */
    public Dataset<Row> removeDuplicate(Dataset<Row> df, Seq<String> column) {
        void var3_3;
        Dataset tmp = df.dropDuplicates(column);
        long diff2 = df.count() - tmp.count();
        if (diff2 > 0L) {
            Long arg$macro$6 = BoxesRunTime.boxToLong(diff2);
            Predef$.MODULE$.println(new StringOps("removed %s rows").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$6})));
            df.except(tmp).show();
        }
        return var3_3;
    }

    public Dataset<Row> dfAddHash(Dataset<Row> df, List<String> columnsToExclude) {
        return df.withColumn("hash", functions$.MODULE$.hash(Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.columns()).filter(new Serializable(columnsToExclude){
            public static final long serialVersionUID = 0L;
            private final List columnsToExclude$1;

            public final boolean apply(String x) {
                return !this.columnsToExclude$1.contains(x);
            }
            {
                this.columnsToExclude$1 = columnsToExclude$1;
            }
        })).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String x) {
                return functions$.MODULE$.col(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))));
    }

    public List<String> dfAddHash$default$2() {
        return Nil$.MODULE$;
    }

    private DFTool$() {
        MODULE$ = this;
        LazyLogging$class.$init$(this);
    }
}

