/*
 * Decompiled with CFR 0.152.
 */
package io.frama.parisni.spark.postgres;

import io.frama.parisni.spark.postgres.ExactPartitioner;
import io.frama.parisni.spark.postgres.PGTool;
import io.frama.parisni.spark.postgres.PGTool$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.postgresql.copy.CopyManager;
import org.postgresql.copy.PGCopyInputStream;
import org.postgresql.core.BaseConnection;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class PGTool$
implements Serializable {
    public static final PGTool$ MODULE$;

    static {
        new PGTool$();
    }

    public PGTool apply(SparkSession spark, String url, String tmpPath) {
        return new PGTool(spark, url, new StringBuilder().append((Object)tmpPath).append((Object)"/").append((Object)UUID.randomUUID().toString()).toString()).setPassword("");
    }

    private String dbPassword(String hostname, String port, String database, String username) {
        FileSystem fs = FileSystem.get((URI)new URI("file:///"), (Configuration)new Configuration());
        FSDataInputStream file = fs.open(new Path((String)scala.sys.package$.MODULE$.env().apply("HOME"), ".pgpass"));
        String content = package$.MODULE$.Iterator().continually(new scala.Serializable(file){
            public static final long serialVersionUID = 0L;
            private final FSDataInputStream file$1;

            public final String apply() {
                return this.file$1.readLine();
            }
            {
                this.file$1 = file$1;
            }
        }).takeWhile((Function1<String, Object>)((Object)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1 != null;
            }
        })).mkString("\n");
        ObjectRef<String> passwd = ObjectRef.create("");
        Predef$.MODULE$.refArrayOps((Object[])content.split("\n")).foreach(new scala.Serializable(hostname, port, database, username, passwd){
            public static final long serialVersionUID = 0L;
            private final String hostname$1;
            private final String port$1;
            private final String database$1;
            private final String username$1;
            private final ObjectRef passwd$1;

            public final void apply(String line) {
                block4: {
                    String[] connCfg;
                    block5: {
                        connCfg = line.split(":");
                        String string2 = this.hostname$1;
                        String string3 = connCfg[0];
                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block4;
                        String string4 = this.port$1;
                        String string5 = connCfg[1];
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                        String string6 = this.database$1;
                        String string7 = connCfg[2];
                        if (!(string6 == null ? string7 != null : !string6.equals(string7))) break block5;
                        String string8 = this.database$1;
                        String string9 = "*";
                        if (string8 != null ? !string8.equals(string9) : string9 != null) break block4;
                    }
                    String string10 = this.username$1;
                    String string11 = connCfg[3];
                    if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                        this.passwd$1.elem = connCfg[4];
                    }
                }
            }
            {
                this.hostname$1 = hostname$1;
                this.port$1 = port$1;
                this.database$1 = database$1;
                this.username$1 = username$1;
                this.passwd$1 = passwd$1;
            }
        });
        file.close();
        return (String)passwd.elem;
    }

    public String passwordFromConn(String url, String password) {
        if (password.isEmpty()) {
            String string2;
            Regex pattern = new StringOps(Predef$.MODULE$.augmentString("jdbc:postgresql://(.*):(\\d+)/(\\w+)[?]user=(\\w+).*")).r();
            Option<List<String>> option = pattern.unapplySeq(string2 = url);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
                Tuple4<String, String, String, String> tuple4;
                String host = (String)((LinearSeqOptimized)option.get()).apply(0);
                String port = (String)((LinearSeqOptimized)option.get()).apply(1);
                String database = (String)((LinearSeqOptimized)option.get()).apply(2);
                String username = (String)((LinearSeqOptimized)option.get()).apply(3);
                Tuple4<String, String, String, String> tuple42 = tuple4 = new Tuple4<String, String, String, String>(host, port, database, username);
                String host2 = tuple42._1();
                String port2 = tuple42._2();
                String database2 = tuple42._3();
                String username2 = tuple42._4();
                return this.dbPassword(host2, port2, database2, username2);
            }
            throw new MatchError((Object)string2);
        }
        return password;
    }

    public Connection connOpen(String url, String password) {
        Properties prop = new Properties();
        prop.put("password", this.passwordFromConn(url, password));
        Connection dbc = DriverManager.getConnection(url, prop);
        return dbc;
    }

    public String connOpen$default$2() {
        return "";
    }

    private StructType getSchemaTable(SparkSession spark, String url, String table) {
        String query = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" select * from ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{table}));
        return this.getSchemaQuery(spark, url, query, this.getSchemaQuery$default$4());
    }

    private StructType getSchemaQuery(SparkSession spark, String url, String query, String password) {
        String queryStr = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(SELECT * FROM (", ") as tmp1 LIMIT 0) as tmp"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{query}));
        return spark.read().format("jdbc").option("url", url).option("password", this.passwordFromConn(url, password)).option("driver", "org.postgresql.Driver").option("dbtable", queryStr).load().schema();
    }

    private String getSchemaQuery$default$4() {
        return "";
    }

    private String getCreateStmtFromSchema(StructType struct, String table, List<String> excludeColumns) {
        ObjectRef<String> columns = ObjectRef.create("");
        BooleanRef begin = BooleanRef.create(true);
        struct.foreach((Function1)((Object)new scala.Serializable(excludeColumns, columns, begin){
            public static final long serialVersionUID = 0L;
            private final List excludeColumns$1;
            private final ObjectRef columns$2;
            private final BooleanRef begin$1;

            public final void apply(StructField col) {
                if (!this.excludeColumns$1.contains(col.name())) {
                    String dataType;
                    if (!this.begin$1.elem) {
                        this.columns$2.elem = new StringBuilder().append((Object)((String)this.columns$2.elem)).append((Object)",\n").toString();
                    }
                    String string2 = dataType = col.dataType().sql();
                    String string3 = "STRING";
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        dataType = "text";
                    }
                    String arg$macro$1 = col.name();
                    String arg$macro$2 = dataType;
                    this.columns$2.elem = new StringBuilder().append((Object)((String)this.columns$2.elem)).append((Object)new StringOps("%s %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1, arg$macro$2}))).toString();
                    if (this.begin$1.elem) {
                        this.begin$1.elem = false;
                    }
                }
            }
            {
                this.excludeColumns$1 = excludeColumns$1;
                this.columns$2 = columns$2;
                this.begin$1 = begin$1;
            }
        }));
        String arg$macro$3 = table;
        String arg$macro$4 = (String)columns.elem;
        return new StringOps("create table %s (\n%s)").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$3, arg$macro$4}));
    }

    public void tableTruncate(String url, String table, String password) {
        Connection conn = this.connOpen(url, password);
        PreparedStatement st = conn.prepareStatement(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{table})));
        st.executeUpdate();
        conn.close();
    }

    public String tableTruncate$default$3() {
        return "";
    }

    public void tableDrop(String url, String table, String password) {
        Connection conn = this.connOpen(url, password);
        PreparedStatement st = conn.prepareStatement(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{table})));
        st.executeUpdate();
        conn.close();
    }

    public String tableDrop$default$3() {
        return "";
    }

    public void sqlExec(String url, String query, String password) {
        Connection conn = this.connOpen(url, password);
        PreparedStatement st = conn.prepareStatement(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{query})));
        st.executeUpdate();
        conn.close();
    }

    public String sqlExec$default$3() {
        return "";
    }

    public void tableCopy(String url, String tableSrc, String tableTarg, String password, boolean isUnlogged) {
        Connection conn = this.connOpen(url, password);
        String unlogged = isUnlogged ? "UNLOGGED" : "";
        String queryCreate = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE ", " TABLE ", " (LIKE ", "  INCLUDING DEFAULTS)"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{unlogged, tableTarg, tableSrc}));
        PreparedStatement st = conn.prepareStatement(queryCreate);
        st.executeUpdate();
        conn.close();
    }

    public String tableCopy$default$4() {
        return "";
    }

    public boolean tableCopy$default$5() {
        return true;
    }

    public void tableMove(String url, String tableSrc, String tableTarg, String password) {
        Connection conn = this.connOpen(url, password);
        String queryCreate = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " RENAME TO ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tableSrc, tableTarg}));
        PreparedStatement st = conn.prepareStatement(queryCreate);
        st.executeUpdate();
        conn.close();
    }

    public String tableMove$default$4() {
        return "";
    }

    private Tuple2<Object, Object> getMinMaxForColumn(SparkSession spark, String url, String query, String partitionColumn, String password) {
        String min_max_query = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(SELECT coalesce(cast(min(", ") as bigint), 0) as min, coalesce(cast(max(", ") as bigint),0) as max FROM ", ") AS tmp1"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{partitionColumn, partitionColumn, query}));
        Row row = (Row)spark.read().format("jdbc").option("url", url).option("driver", "org.postgresql.Driver").option("dbtable", min_max_query).option("password", this.passwordFromConn(url, password)).load().first();
        long lowerBound = row.getLong(0);
        long upperBound = row.getLong(1);
        return new Tuple2$mcJJ$sp(lowerBound, upperBound);
    }

    private String getMinMaxForColumn$default$5() {
        return "";
    }

    private RDD<Tuple2<Object, String>> getPartitions(SparkSession spark, long lowerBound, long upperBound, int numPartitions, int splitFactor) {
        BigInt length = package$.MODULE$.BigInt().apply(1).$plus(BigInt$.MODULE$.long2bigInt(upperBound)).$minus(BigInt$.MODULE$.long2bigInt(lowerBound));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_frama_parisni_spark_postgres_PGTool$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                U $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), $m.staticClass("scala.Tuple2"), (List<Types.TypeApi>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), $m.staticModule("scala.Predef")), $u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), Nil$.MODULE$)})));
            }

            public Io_frama_parisni_spark_postgres_PGTool$$typecreator13$1() {
            }
        }
        RDD partitions = RDD$.MODULE$.rddToPairRDDFunctions(spark.implicits().localSeqToDatasetHolder((Seq)((TraversableLike)((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions * splitFactor).map(new scala.Serializable(lowerBound, numPartitions, splitFactor, length){
            public static final long serialVersionUID = 0L;
            private final long lowerBound$1;
            private final int numPartitions$1;
            private final int splitFactor$1;
            private final BigInt length$1;

            public final String apply(int i) {
                BigInt start = BigInt$.MODULE$.long2bigInt(this.lowerBound$1).$plus(BigInt$.MODULE$.int2bigInt(i).$times(this.length$1).$div(BigInt$.MODULE$.int2bigInt(this.numPartitions$1)).$div(BigInt$.MODULE$.int2bigInt(this.splitFactor$1)));
                BigInt end = BigInt$.MODULE$.long2bigInt(this.lowerBound$1).$plus(BigInt$.MODULE$.int2bigInt(i + 1).$times(this.length$1).$div(BigInt$.MODULE$.int2bigInt(this.numPartitions$1)).$div(BigInt$.MODULE$.int2bigInt(this.splitFactor$1))).$minus(BigInt$.MODULE$.int2bigInt(1));
                BigInt arg$macro$5 = start;
                BigInt arg$macro$6 = end;
                return new StringOps("between %s AND %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$5, arg$macro$6}));
            }
            {
                this.lowerBound$1 = lowerBound$1;
                this.numPartitions$1 = numPartitions$1;
                this.splitFactor$1 = splitFactor$1;
                this.length$1 = length$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String a = tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Tuple2<Object, String> tuple22 = new Tuple2<Object, String>(BoxesRunTime.boxToInteger(index), a);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), spark.implicits().newProductEncoder(((TypeTags)((Object)$u)).TypeTag().apply((Mirror)((Object)$m), new Io_frama_parisni_spark_postgres_PGTool$$typecreator13$1()))).toDS().rdd(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering$Int$.MODULE$).partitionBy(new ExactPartitioner(numPartitions));
        return partitions;
    }

    private int getPartitions$default$5() {
        return 1;
    }

    public Dataset<Row> inputQueryDf(SparkSession spark, String url, String query, int numPartitions, String partitionColumn, String password) {
        Tuple2<Object, Object> tuple2;
        block4: {
            Dataset dataset;
            block3: {
                Tuple2$mcJJ$sp tuple2$mcJJ$sp;
                String queryStr;
                block2: {
                    queryStr = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") as tmp"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{query}));
                    String string2 = partitionColumn;
                    String string3 = "";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    dataset = spark.read().format("jdbc").option("url", url).option("dbtable", queryStr).option("driver", "org.postgresql.Driver").option("fetchsize", 50000L).option("password", this.passwordFromConn(url, password)).load();
                    break block3;
                }
                tuple2 = this.getMinMaxForColumn(spark, url, queryStr, partitionColumn, this.getMinMaxForColumn$default$5());
                if (tuple2 == null) break block4;
                long lowerBound = tuple2._1$mcJ$sp();
                long upperBound = tuple2._2$mcJ$sp();
                Tuple2$mcJJ$sp tuple2$mcJJ$sp2 = tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(lowerBound, upperBound);
                long lowerBound2 = ((Tuple2)tuple2$mcJJ$sp2)._1$mcJ$sp();
                long upperBound2 = ((Tuple2)tuple2$mcJJ$sp2)._2$mcJ$sp();
                dataset = spark.read().format("jdbc").option("url", url).option("dbtable", queryStr).option("driver", "org.postgresql.Driver").option("partitionColumn", partitionColumn).option("lowerBound", lowerBound2).option("upperBound", upperBound2).option("numPartitions", (long)numPartitions).option("fetchsize", 50000L).option("password", this.passwordFromConn(url, password)).load();
            }
            return dataset;
        }
        throw new MatchError(tuple2);
    }

    public String inputQueryDf$default$6() {
        return "";
    }

    public void outputBulkCsv(SparkSession spark, String url, String table, Dataset<Row> df, String path, int numPartitions, String password) {
        String columns = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x) {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x.name()}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        Dataset<Row> dfTmp = this.dataframeToPgCsv(spark, df, df.schema());
        dfTmp.write().format("csv").option("delimiter", ",").option("header", false).option("nullValue", null).option("emptyValue", "\"\"").option("quote", "\"").option("escape", "\"").option("ignoreLeadingWhiteSpace", false).option("ignoreTrailingWhiteSpace", false).mode(SaveMode.Overwrite).save(path);
        this.outputBulkCsvLow(spark, url, table, columns, path, numPartitions, ",", ".*.csv", password);
    }

    public void outputBulkCsvLow(SparkSession spark, String url, String table, String columns, String path, int numPartitions, String delimiter, String csvPattern, String password) {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_frama_parisni_spark_postgres_PGTool$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                U $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), $m.staticClass("scala.Tuple2"), (List<Types.TypeApi>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Io_frama_parisni_spark_postgres_PGTool$$typecreator5$1() {
            }
        }
        RDD rdd = RDD$.MODULE$.rddToPairRDDFunctions(spark.implicits().localSeqToDatasetHolder((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(path))).filter(new scala.Serializable(csvPattern){
            public static final long serialVersionUID = 0L;
            private final String csvPattern$1;

            public final boolean apply(FileStatus x) {
                return x.getPath().toString().matches(new StringBuilder().append((Object)"^.*/").append((Object)this.csvPattern$1).append((Object)"$").toString());
            }
            {
                this.csvPattern$1 = csvPattern$1;
            }
        })).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x) {
                return x.getPath().toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList().zipWithIndex(List$.MODULE$.canBuildFrom()).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String a = tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Tuple2<Object, String> tuple22 = new Tuple2<Object, String>(BoxesRunTime.boxToInteger(i), a);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom()), spark.implicits().newProductEncoder(((TypeTags)((Object)$u)).TypeTag().apply((Mirror)((Object)$m), new Io_frama_parisni_spark_postgres_PGTool$$typecreator5$1()))).toDS().rdd(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering$Int$.MODULE$).partitionBy(new ExactPartitioner(numPartitions));
        rdd.foreachPartition((Function1)((Object)new scala.Serializable(url, table, columns, delimiter, password){
            public static final long serialVersionUID = 0L;
            private final String url$1;
            public final String table$1;
            public final String columns$1;
            public final String delimiter$1;
            private final String password$1;

            public final void apply(Iterator<Tuple2<Object, String>> x) {
                Connection conn = PGTool$.MODULE$.connOpen(this.url$1, this.password$1);
                x.foreach(new scala.Serializable(this, conn){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.outputBulkCsvLow.1 $outer;
                    private final Connection conn$1;

                    public final long apply(Tuple2<Object, String> s2) {
                        InputStream stream = FileSystem.get((Configuration)new Configuration()).open(new Path(s2._2())).getWrappedStream();
                        CopyManager copyManager = new CopyManager((BaseConnection)this.conn$1);
                        return copyManager.copyIn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY ", " (", ") FROM STDIN WITH CSV DELIMITER '", "'  NULL '' ESCAPE '\"' QUOTE '\"' "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.table$1, this.$outer.columns$1, this.$outer.delimiter$1})), stream);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.conn$1 = conn$1;
                    }
                });
                conn.close();
                x.toIterator();
            }
            {
                this.url$1 = url$1;
                this.table$1 = table$1;
                this.columns$1 = columns$1;
                this.delimiter$1 = delimiter$1;
                this.password$1 = password$1;
            }
        }));
    }

    public void output(String url, String table, Dataset<Row> df, int batchsize, String password) {
        df.coalesce(8).write().mode(SaveMode.Overwrite).format("jdbc").option("url", url).option("dbtable", table).option("batchsize", (long)batchsize).option("password", this.passwordFromConn(url, password)).option("driver", "org.postgresql.Driver").save();
    }

    public int outputBulkCsv$default$6() {
        return 8;
    }

    public String outputBulkCsv$default$7() {
        return "";
    }

    public int outputBulkCsvLow$default$6() {
        return 8;
    }

    public String outputBulkCsvLow$default$7() {
        return ",";
    }

    public String outputBulkCsvLow$default$8() {
        return ".*.csv";
    }

    public String outputBulkCsvLow$default$9() {
        return "";
    }

    public int output$default$4() {
        return 50000;
    }

    public String output$default$5() {
        return "";
    }

    public void inputQueryPartBulkCsv(SparkSession spark, String fsConf, String url, String query, String path, int numPartitions, String partitionColumn, int splitFactor, String password) {
        String queryStr = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") as tmp"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{query}));
        Tuple2<Object, Object> tuple2 = this.getMinMaxForColumn(spark, url, queryStr, partitionColumn, this.getMinMaxForColumn$default$5());
        if (tuple2 != null) {
            Tuple2$mcJJ$sp tuple2$mcJJ$sp;
            long lowerBound = tuple2._1$mcJ$sp();
            long upperBound = tuple2._2$mcJ$sp();
            Tuple2$mcJJ$sp tuple2$mcJJ$sp2 = tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(lowerBound, upperBound);
            long lowerBound2 = ((Tuple2)tuple2$mcJJ$sp2)._1$mcJ$sp();
            long upperBound2 = ((Tuple2)tuple2$mcJJ$sp2)._2$mcJ$sp();
            RDD<Tuple2<Object, String>> rdd = this.getPartitions(spark, lowerBound2, upperBound2, numPartitions, splitFactor);
            rdd.foreachPartition((Function1)((Object)new scala.Serializable(fsConf, url, path, partitionColumn, password, queryStr){
                public static final long serialVersionUID = 0L;
                public final String fsConf$1;
                private final String url$2;
                public final String path$1;
                public final String partitionColumn$1;
                private final String password$2;
                public final String queryStr$1;

                public final void apply(Iterator<Tuple2<Object, String>> x) {
                    Connection conn = PGTool$.MODULE$.connOpen(this.url$2, this.password$2);
                    x.foreach(new scala.Serializable(this, conn){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.9 $outer;
                        private final Connection conn$2;

                        public final void apply(Tuple2<Object, String> s2) {
                            String queryPart = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM ", " WHERE ", " ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.queryStr$1, this.$outer.partitionColumn$1, s2._2()}));
                            PGTool$.MODULE$.inputQueryBulkCsv(this.$outer.fsConf$1, this.conn$2, queryPart, this.$outer.path$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.conn$2 = conn$2;
                        }
                    });
                    conn.close();
                    x.toIterator();
                }
                {
                    this.fsConf$1 = fsConf$1;
                    this.url$2 = url$2;
                    this.path$1 = path$1;
                    this.partitionColumn$1 = partitionColumn$1;
                    this.password$2 = password$2;
                    this.queryStr$1 = queryStr$1;
                }
            }));
            BoxedUnit tmp = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError(tuple2);
    }

    public int inputQueryPartBulkCsv$default$8() {
        return 1;
    }

    public String inputQueryPartBulkCsv$default$9() {
        return "";
    }

    public void inputQueryBulkCsv(String fsConf, Connection conn, String query, String path) {
        String sqlStr = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" COPY (", ") TO STDOUT  WITH DELIMITER AS ',' CSV NULL '' ENCODING 'UTF-8' QUOTE '\"' ESCAPE '\"' "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{query}));
        PGCopyInputStream copyInputStream = new PGCopyInputStream((BaseConnection)conn, sqlStr);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", fsConf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream output = fs.create(new Path(path, new StringBuilder().append((Object)"part-").append((Object)UUID.randomUUID().toString()).append((Object)".csv").toString()));
        boolean flag = true;
        while (flag) {
            int t = copyInputStream.read();
            if (t > 0) {
                output.write(t);
                output.write(copyInputStream.readFromCopy());
                continue;
            }
            output.close();
            flag = false;
        }
    }

    public Dataset<Row> inputQueryBulkDf(SparkSession spark, String url, String query, String path, boolean isMultiline, int numPartitions, String partitionColumn, int splitFactor, String password) {
        String defaultFSConf = spark.sessionState().newHadoopConf().get("fs.defaultFS");
        String fsConf = path.startsWith("file:") ? "file:///" : defaultFSConf;
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", fsConf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(new Path(path), true);
        StructType schemaQueryComplex = this.getSchemaQuery(spark, url, query, password);
        if (numPartitions == 1) {
            Connection conn = this.connOpen(url, password);
            this.inputQueryBulkCsv(fsConf, conn, query, path);
            conn.close();
        } else {
            this.inputQueryPartBulkCsv(spark, fsConf, url, query, path, numPartitions, partitionColumn, splitFactor, password);
        }
        StructType schemaQuerySimple = this.schemaSimplify(schemaQueryComplex);
        Dataset dfSimple = spark.read().format("csv").schema(schemaQuerySimple).option("multiline", isMultiline).option("delimiter", ",").option("header", false).option("quote", "\"").option("escape", "\"").option("nullValue", null).option("emptyValue", "\"\"").option("ignoreLeadingWhiteSpace", false).option("ignoreTrailingWhiteSpace", false).option("timestampFormat", "yyyy-MM-dd HH:mm:ss").option("dateFormat", "yyyy-MM-dd").option("mode", "FAILFAST").load(path);
        Dataset<Row> dfComplex = this.dataframeFromPgCsv(spark, (Dataset<Row>)dfSimple, schemaQueryComplex);
        return dfComplex;
    }

    public boolean inputQueryBulkDf$default$5() {
        return false;
    }

    public int inputQueryBulkDf$default$6() {
        return 1;
    }

    public String inputQueryBulkDf$default$7() {
        return "";
    }

    public int inputQueryBulkDf$default$8() {
        return 1;
    }

    public String inputQueryBulkDf$default$9() {
        return "";
    }

    public StructType schemaSimplify(StructType schema) {
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(StructField field2) {
                StructField structField;
                DataType dataType = field2.dataType();
                if (dataType instanceof BooleanType) {
                    StringType$ x$5 = StringType$.MODULE$;
                    String x$6 = field2.copy$default$1();
                    boolean x$7 = field2.copy$default$3();
                    Metadata x$8 = field2.copy$default$4();
                    structField = field2.copy(x$6, (DataType)x$5, x$7, x$8);
                } else if (dataType instanceof ArrayType) {
                    StringType$ x$9 = StringType$.MODULE$;
                    String x$10 = field2.copy$default$1();
                    boolean x$11 = field2.copy$default$3();
                    Metadata x$12 = field2.copy$default$4();
                    structField = field2.copy(x$10, (DataType)x$9, x$11, x$12);
                } else {
                    structField = field2;
                }
                return structField;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public Dataset<Row> dataframeFromPgCsv(SparkSession spark, Dataset<Row> dfSimple, StructType schemaQueryComplex) {
        String tableTmp = new StringBuilder().append((Object)"table_").append((Object)UUID.randomUUID().toString().replaceAll(".*-", "")).toString();
        dfSimple.registerTempTable(tableTmp);
        String sqlQuery = new StringBuilder().append((Object)"SELECT ").append((Object)((TraversableOnce)schemaQueryComplex.map((Function1)((Object)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField a) {
                String string2 = a.dataType().simpleString();
                String string3 = "boolean";
                return !(string2 != null ? !string2.equals(string3) : string3 != null) ? new StringBuilder().append((Object)"CAST(").append((Object)a.name()).append((Object)" as boolean) as ").append((Object)a.name()).toString() : (a.dataType().simpleString().indexOf("array") == 0 ? new StringBuilder().append((Object)"CAST(SPLIT(REGEXP_REPLACE(").append((Object)a.name()).append((Object)", '^[{]|[}]$', ''), ',') AS ").append((Object)a.dataType().simpleString()).append((Object)") as ").append((Object)a.name()).toString() : a.name());
            }
        }), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append((Object)" FROM ").append((Object)tableTmp).toString();
        return spark.sql(sqlQuery);
    }

    public Dataset<Row> dataframeToPgCsv(SparkSession spark, Dataset<Row> dfSimple, StructType schemaQueryComplex) {
        String tableTmp = new StringBuilder().append((Object)"table_").append((Object)UUID.randomUUID().toString().replaceAll(".*-", "")).toString();
        dfSimple.registerTempTable(tableTmp);
        String sqlQuery = new StringBuilder().append((Object)"SELECT ").append((Object)((TraversableOnce)schemaQueryComplex.map((Function1)((Object)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField a) {
                return a.dataType().simpleString().indexOf("array") == 0 ? new StringBuilder().append((Object)"REGEXP_REPLACE(REGEXP_REPLACE(CAST(").append((Object)a.name()).append((Object)" AS string), '^.', '{'), '.$', '}') AS ").append((Object)a.name()).toString() : a.name();
            }
        }), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append((Object)" FROM ").append((Object)tableTmp).toString();
        return spark.sql(sqlQuery);
    }

    public void outputBulkDfScd1Hash(SparkSession spark, String url, String table, List<String> key, Dataset<Row> df, int numPartitions, String hash, String insertDatetime, String updateDatetime, String deleteDatetime, String path, boolean isDelete, String password) {
        String updateDate;
        String string2;
        String insertDate;
        String string3;
        df.cache();
        String selectColumns = ((TraversableOnce)key.map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f.", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x}));
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ");
        String selectColumnsBasic = key.mkString(", ");
        String joinColumns = ((TraversableOnce)key.map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"df.", " = f.", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x, x}));
            }
        }, List$.MODULE$.canBuildFrom())).mkString(" AND ");
        String rand = UUID.randomUUID().toString().replaceAll(".*-", "");
        String tableUpdTmp = new StringBuilder().append((Object)"table_upd_").append((Object)rand).toString();
        String tableDelTmp = new StringBuilder().append((Object)"table_del_").append((Object)rand).toString();
        this.tableCopy(url, table, tableUpdTmp, password, this.tableCopy$default$5());
        String arg$macro$10 = selectColumnsBasic;
        String arg$macro$11 = table;
        this.sqlExec(url, this.getCreateStmtFromSchema(this.getSchemaQuery(spark, url, new StringOps("select %s from %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$10, arg$macro$11})), password), tableDelTmp, Nil$.MODULE$), password);
        String arg$macro$7 = selectColumnsBasic;
        String arg$macro$8 = hash;
        String arg$macro$9 = table;
        String query = new StringOps("select %s, %s from %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$7, arg$macro$8, arg$macro$9}));
        String arg$macro$12 = rand;
        df.registerTempTable(new StringOps("df_%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$12})));
        SparkSession x$13 = spark;
        String x$14 = url;
        String x$15 = query;
        String x$16 = path;
        boolean x$17 = false;
        int x$18 = 1;
        String x$19 = password;
        String x$20 = this.inputQueryBulkDf$default$7();
        int x$21 = this.inputQueryBulkDf$default$8();
        Dataset fetch = this.inputQueryBulkDf(x$13, x$14, x$15, x$16, x$17, x$18, x$20, x$21, x$19).cache();
        String arg$macro$13 = rand;
        fetch.registerTempTable(new StringOps("fetch_%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$13})));
        if (isDelete) {
            string3 = "";
        } else {
            String arg$macro$14 = insertDatetime;
            string3 = new StringOps(", current_timestamp as %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$14}));
        }
        String arg$macro$15 = insertDate = string3;
        String arg$macro$16 = rand;
        String arg$macro$17 = rand;
        String arg$macro$18 = joinColumns;
        String arg$macro$19 = key.apply(0);
        Dataset insDf = spark.sql(new StringOps("select df.* %s from df_%s df        left join fetch_%s f     on (%s) where f.%s is null").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$15, arg$macro$16, arg$macro$17, arg$macro$18, arg$macro$19})));
        if (isDelete) {
            string2 = "";
        } else {
            String arg$macro$20 = updateDatetime;
            string2 = new StringOps(", current_timestamp as %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$20}));
        }
        String arg$macro$21 = updateDate = string2;
        String arg$macro$22 = rand;
        String arg$macro$23 = rand;
        String arg$macro$24 = joinColumns;
        String arg$macro$25 = hash;
        String arg$macro$26 = hash;
        Dataset updDf = spark.sql(new StringOps("select df.* %s from df_%s df        join fetch_%s f          on (%s) where f.%s IS DISTINCT FROM df.%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$21, arg$macro$22, arg$macro$23, arg$macro$24, arg$macro$25, arg$macro$26})));
        String arg$macro$27 = selectColumns;
        String arg$macro$28 = rand;
        String arg$macro$29 = rand;
        String arg$macro$30 = joinColumns;
        String arg$macro$31 = hash;
        Dataset delDf = spark.sql(new StringOps("select %s                             from fetch_%s f  left join  df_%s df          on (%s) where df.%s is null").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$27, arg$macro$28, arg$macro$29, arg$macro$30, arg$macro$31})));
        this.outputBulkCsv(spark, url, tableUpdTmp, (Dataset<Row>)updDf, new StringBuilder().append((Object)path).append((Object)"/upd").toString(), numPartitions, password);
        this.outputBulkCsv(spark, url, tableDelTmp, (Dataset<Row>)delDf, new StringBuilder().append((Object)path).append((Object)"/del").toString(), numPartitions, password);
        this.scd1Update(url, table, tableUpdTmp, key, df.schema(), Nil$.MODULE$, Nil$.MODULE$, false, password);
        if (isDelete) {
            String arg$macro$32 = table;
            String arg$macro$33 = tableDelTmp;
            String arg$macro$34 = joinColumns;
            this.sqlExec(url, new StringOps("delete from %s df using %s f where %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$32, arg$macro$33, arg$macro$34})), password);
        } else {
            String arg$macro$35 = table;
            String arg$macro$36 = deleteDatetime;
            String arg$macro$37 = tableDelTmp;
            String arg$macro$38 = joinColumns;
            this.sqlExec(url, new StringOps("update %s df set %s = now() from %s f where %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$35, arg$macro$36, arg$macro$37, arg$macro$38})), password);
        }
        this.outputBulkCsv(spark, url, table, (Dataset<Row>)insDf, new StringBuilder().append((Object)path).append((Object)"/ins").toString(), numPartitions, password);
        this.tableDrop(url, tableUpdTmp, password);
        this.tableDrop(url, tableDelTmp, password);
    }

    public int outputBulkDfScd1Hash$default$6() {
        return 8;
    }

    public String outputBulkDfScd1Hash$default$13() {
        return "";
    }

    public void scd1Update(String url, String table, String tableTarg, List<String> key, StructType rddSchema, List<String> excludeColumns, List<String> includeColumns, boolean isCompare, String password) {
        Connection conn = this.connOpen(url, password);
        String joinColumns = ((TraversableOnce)key.map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"targ.", " = tmp.", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x, x}));
            }
        }, List$.MODULE$.canBuildFrom())).mkString(" AND ");
        String updSet = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).filter(new scala.Serializable(key){
            public static final long serialVersionUID = 0L;
            private final List key$1;

            public final boolean apply(StructField x) {
                return !this.key$1.contains(x.name());
            }
            {
                this.key$1 = key$1;
            }
        })).filter(new scala.Serializable(excludeColumns){
            public static final long serialVersionUID = 0L;
            private final List excludeColumns$2;

            public final boolean apply(StructField x) {
                return !this.excludeColumns$2.contains(x.name());
            }
            {
                this.excludeColumns$2 = excludeColumns$2;
            }
        })).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x) {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = tmp.", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x.name(), x.name()}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        String updIsDistinct = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).filter(new scala.Serializable(key){
            public static final long serialVersionUID = 0L;
            private final List key$1;

            public final boolean apply(StructField x) {
                return !this.key$1.contains(x.name());
            }
            {
                this.key$1 = key$1;
            }
        })).filter(new scala.Serializable(excludeColumns){
            public static final long serialVersionUID = 0L;
            private final List excludeColumns$2;

            public final boolean apply(StructField x) {
                return !this.excludeColumns$2.contains(x.name());
            }
            {
                this.excludeColumns$2 = excludeColumns$2;
            }
        })).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x) {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tmp.", " IS DISTINCT FROM tmp.", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x.name(), x.name()}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(" OR ");
        if (includeColumns.size() != 0) {
            updIsDistinct = ((TraversableOnce)includeColumns.map(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tmp.", " IS DISTINCT FROM tmp.", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x, x}));
                }
            }, List$.MODULE$.canBuildFrom())).mkString(" OR ");
        }
        if (!isCompare) {
            updIsDistinct = "1 = 1";
        }
        String upd = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    UPDATE ", " as targ\n    SET ", "\n    FROM ", " as tmp\n    WHERE TRUE\n    AND (", ")\n    AND (", ")\n    "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{table, updSet, tableTarg, joinColumns, updIsDistinct}));
        conn.prepareStatement(upd).executeUpdate();
        conn.close();
    }

    public List<String> scd1Update$default$6() {
        return Nil$.MODULE$;
    }

    public List<String> scd1Update$default$7() {
        return Nil$.MODULE$;
    }

    public boolean scd1Update$default$8() {
        return true;
    }

    public String scd1Update$default$9() {
        return "";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PGTool$() {
        MODULE$ = this;
    }
}

