/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.convert.StringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum JDKStringConverter implements StringConverter<Object>
{
    STRING((Class)String.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return string2;
        }
    }
    ,
    CHAR_SEQUENCE((Class)CharSequence.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return string2;
        }
    }
    ,
    STRING_BUFFER((Class)StringBuffer.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new StringBuffer(string2);
        }
    }
    ,
    STRING_BUILDER((Class)StringBuilder.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new StringBuilder(string2);
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new Long(string2);
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new Integer(string2);
        }
    }
    ,
    SHORT((Class)Short.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new Short(string2);
        }
    }
    ,
    BYTE((Class)Byte.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new Byte(string2);
        }
    }
    ,
    CHARACTER((Class)Character.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            if (string2.length() != 1) {
                throw new IllegalArgumentException("Character value must be a string length 1");
            }
            return new Character(string2.charAt(0));
        }
    }
    ,
    BOOLEAN((Class)Boolean.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            if ("true".equalsIgnoreCase(string2)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string2)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new Double(string2);
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new Float(string2);
        }
    }
    ,
    BIG_INTEGER((Class)BigInteger.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new BigInteger(string2);
        }
    }
    ,
    BIG_DECIMAL((Class)BigDecimal.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new BigDecimal(string2);
        }
    }
    ,
    ATOMIC_LONG((Class)AtomicLong.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            long l = Long.parseLong(string2);
            return new AtomicLong(l);
        }
    }
    ,
    ATOMIC_INTEGER((Class)AtomicInteger.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            int n = Integer.parseInt(string2);
            return new AtomicInteger(n);
        }
    }
    ,
    ATOMIC_BOOLEAN((Class)AtomicBoolean.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            if ("true".equalsIgnoreCase(string2)) {
                return new AtomicBoolean(true);
            }
            if ("false".equalsIgnoreCase(string2)) {
                return new AtomicBoolean(false);
            }
            throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
        }
    }
    ,
    LOCALE((Class)Locale.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            String[] stringArray = string2.split("_", 3);
            switch (stringArray.length) {
                case 1: {
                    return new Locale(stringArray[0]);
                }
                case 2: {
                    return new Locale(stringArray[0], stringArray[1]);
                }
                case 3: {
                    return new Locale(stringArray[0], stringArray[1], stringArray[2]);
                }
            }
            throw new IllegalArgumentException("Unable to parse Locale: " + string2);
        }
    }
    ,
    CLASS((Class)Class.class){

        @Override
        public String convertToString(Object object) {
            return ((Class)object).getName();
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            try {
                return this.getClass().getClassLoader().loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Unable to create class: " + string2, classNotFoundException);
            }
        }
    }
    ,
    PACKAGE((Class)Package.class){

        @Override
        public String convertToString(Object object) {
            return ((Package)object).getName();
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return Package.getPackage(string2);
        }
    }
    ,
    CURRENCY((Class)Currency.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return Currency.getInstance(string2);
        }
    }
    ,
    TIME_ZONE((Class)TimeZone.class){

        @Override
        public String convertToString(Object object) {
            return ((TimeZone)object).getID();
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return TimeZone.getTimeZone(string2);
        }
    }
    ,
    UUID((Class)UUID.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return java.util.UUID.fromString(string2);
        }
    }
    ,
    URL((Class)URL.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            try {
                return new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException.getMessage(), malformedURLException);
            }
        }
    }
    ,
    URI((Class)URI.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return java.net.URI.create(string2);
        }
    }
    ,
    INET_ADDRESS((Class)InetAddress.class){

        @Override
        public String convertToString(Object object) {
            return ((InetAddress)object).getHostAddress();
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            try {
                return InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException(unknownHostException);
            }
        }
    }
    ,
    FILE((Class)File.class){

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            return new File(string2);
        }
    }
    ,
    DATE((Class)Date.class){

        @Override
        public String convertToString(Object object) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String string2 = simpleDateFormat.format(object);
            return string2.substring(0, 26) + ":" + string2.substring(26);
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            if (string2.length() != 29) {
                throw new IllegalArgumentException("Unable to parse date: " + string2);
            }
            string2 = string2.substring(0, 26) + string2.substring(27);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            try {
                return simpleDateFormat.parseObject(string2);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
    }
    ,
    CALENDAR((Class)Calendar.class){

        @Override
        public String convertToString(Object object) {
            if (!(object instanceof GregorianCalendar)) {
                throw new RuntimeException("Unable to convert calendar as it is not a GregorianCalendar");
            }
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            simpleDateFormat.setCalendar(gregorianCalendar);
            String string2 = simpleDateFormat.format(gregorianCalendar.getTime());
            return string2.substring(0, 26) + ":" + string2.substring(26) + "[" + gregorianCalendar.getTimeZone().getID() + "]";
        }

        @Override
        public Object convertFromString(Class<?> clazz, String string2) {
            if (string2.length() < 31 || string2.charAt(26) != ':' || string2.charAt(29) != '[' || string2.charAt(string2.length() - 1) != ']') {
                throw new IllegalArgumentException("Unable to parse date: " + string2);
            }
            TimeZone timeZone = TimeZone.getTimeZone(string2.substring(30, string2.length() - 1));
            string2 = string2.substring(0, 26) + string2.substring(27, 29);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setTimeInMillis(0L);
            simpleDateFormat.setCalendar(gregorianCalendar);
            try {
                simpleDateFormat.parseObject(string2);
                return simpleDateFormat.getCalendar();
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
    }
    ,
    ENUM((Class)Enum.class){

        public String convertToString(Object object) {
            return ((Enum)object).name();
        }

        public Object convertFromString(Class clazz, String string2) {
            return Enum.valueOf(clazz, string2);
        }
    };

    private Class<?> type;

    private JDKStringConverter(Class<?> clazz) {
        this.type = clazz;
    }

    Class<?> getType() {
        return this.type;
    }

    @Override
    public String convertToString(Object object) {
        return object.toString();
    }
}

