/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.copy;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyOut;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGCopyInputStream
extends InputStream
implements CopyOut {
    private CopyOut op;
    private byte[] buf;
    private int at;
    private int len;

    public PGCopyInputStream(PGConnection connection, String sql) throws SQLException {
        this(connection.getCopyAPI().copyOut(sql));
    }

    public PGCopyInputStream(CopyOut op) {
        this.op = op;
    }

    private boolean gotBuf() throws IOException {
        if (this.at >= this.len) {
            try {
                this.buf = this.op.readFromCopy();
            }
            catch (SQLException sqle) {
                throw new IOException(GT.tr("Copying from database failed: {0}", sqle));
            }
            if (this.buf == null) {
                this.at = -1;
                return false;
            }
            this.at = 0;
            this.len = this.buf.length;
            return true;
        }
        return this.buf != null;
    }

    private void checkClosed() throws IOException {
        if (this.op == null) {
            throw new IOException(GT.tr("This copy stream is closed.", new Object[0]));
        }
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return this.buf != null ? this.len - this.at : 0;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        return this.gotBuf() ? this.buf[this.at++] : -1;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int siz) throws IOException {
        this.checkClosed();
        int got = 0;
        boolean didReadSomething = false;
        while (got < siz && (didReadSomething = this.gotBuf())) {
            buf[off + got++] = this.buf[this.at++];
        }
        return got == 0 && !didReadSomething ? -1 : got;
    }

    @Override
    public byte[] readFromCopy() throws SQLException {
        byte[] result2 = this.buf;
        try {
            if (this.gotBuf()) {
                if (this.at > 0 || this.len < this.buf.length) {
                    byte[] ba = new byte[this.len - this.at];
                    for (int i = this.at; i < this.len; ++i) {
                        ba[i - this.at] = this.buf[i];
                    }
                    result2 = ba;
                }
                this.at = this.len;
            }
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Read from copy failed.", new Object[0]), PSQLState.CONNECTION_FAILURE);
        }
        return result2;
    }

    @Override
    public byte[] readFromCopy(boolean block) throws SQLException {
        return this.readFromCopy();
    }

    @Override
    public void close() throws IOException {
        if (this.op == null) {
            return;
        }
        if (this.op.isActive()) {
            try {
                this.op.cancelCopy();
            }
            catch (SQLException se) {
                IOException ioe = new IOException("Failed to close copy reader.");
                ioe.initCause(se);
                throw ioe;
            }
        }
        this.op = null;
    }

    @Override
    public void cancelCopy() throws SQLException {
        this.op.cancelCopy();
    }

    @Override
    public int getFormat() {
        return this.op.getFormat();
    }

    @Override
    public int getFieldFormat(int field2) {
        return this.op.getFieldFormat(field2);
    }

    @Override
    public int getFieldCount() {
        return this.op.getFieldCount();
    }

    @Override
    public boolean isActive() {
        return this.op != null && this.op.isActive();
    }

    @Override
    public long getHandledRowCount() {
        return this.op.getHandledRowCount();
    }
}

