/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.postgresql.PGProperty;
import org.postgresql.ssl.LibPQFactory;
import org.postgresql.util.GT;
import org.postgresql.util.ObjectFactory;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info2) throws PSQLException {
        String socketFactoryClassName = PGProperty.SOCKET_FACTORY.get(info2);
        if (socketFactoryClassName == null) {
            return SocketFactory.getDefault();
        }
        try {
            return (SocketFactory)ObjectFactory.instantiate(socketFactoryClassName, info2, true, PGProperty.SOCKET_FACTORY_ARG.get(info2));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info2) throws PSQLException {
        String classname = PGProperty.SSL_FACTORY.get(info2);
        if (classname == null || "org.postgresql.ssl.jdbc4.LibPQFactory".equals(classname) || "org.postgresql.ssl.LibPQFactory".equals(classname)) {
            return new LibPQFactory(info2);
        }
        try {
            return (SSLSocketFactory)ObjectFactory.instantiate(classname, info2, true, PGProperty.SSL_FACTORY_ARG.get(info2));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

