/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporters.logging;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingSpanExporter
implements SpanExporter {
    private static final Logger logger = Logger.getLogger(LoggingSpanExporter.class.getName());

    public CompletableResultCode export(Collection<SpanData> spans) {
        for (SpanData span : spans) {
            logger.log(Level.INFO, "span: {0}", span);
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        CompletableResultCode resultCode = new CompletableResultCode();
        for (Handler handler : logger.getHandlers()) {
            try {
                handler.flush();
            }
            catch (Throwable t) {
                resultCode.fail();
            }
        }
        return resultCode.succeed();
    }

    public CompletableResultCode shutdown() {
        return this.flush();
    }
}

