/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.Types;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;

class BeanResolverImpl
implements BeanResolver {
    protected final BeanDeployment beanDeployment;
    private final Map<InjectionPointInfo.TypeAndQualifiers, List<BeanInfo>> resolved;

    BeanResolverImpl(BeanDeployment beanDeployment) {
        this.beanDeployment = beanDeployment;
        this.resolved = new ConcurrentHashMap<InjectionPointInfo.TypeAndQualifiers, List<BeanInfo>>();
    }

    @Override
    public Set<BeanInfo> resolveBeans(Type requiredType, Set<AnnotationInstance> requiredQualifiers) {
        Objects.requireNonNull(requiredType, "Required type must not be null");
        InjectionPointInfo.TypeAndQualifiers typeAndQualifiers = new InjectionPointInfo.TypeAndQualifiers(requiredType, requiredQualifiers);
        List<BeanInfo> beans = this.findMatching(typeAndQualifiers);
        Set<BeanInfo> ret = beans.isEmpty() ? Set.of() : (beans.size() == 1 ? Set.of(beans.get(0)) : new HashSet<BeanInfo>(beans));
        return ret;
    }

    @Override
    public BeanInfo resolveAmbiguity(Set<BeanInfo> beans) {
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        if (beans.size() > 1) {
            BeanInfo selected = Beans.resolveAmbiguity(beans);
            if (selected != null) {
                return selected;
            }
            throw new AmbiguousResolutionException(beans.toString());
        }
        return beans.iterator().next();
    }

    @Override
    public boolean matches(BeanInfo bean, InjectionPointInfo.TypeAndQualifiers typeAndQualifiers) {
        return this.matches(bean, typeAndQualifiers.type, typeAndQualifiers.qualifiers);
    }

    @Override
    public boolean matches(BeanInfo bean, Type requiredType, Set<AnnotationInstance> requiredQualifiers) {
        return this.matchesType(bean, requiredType) && Beans.hasQualifiers(bean, requiredQualifiers);
    }

    @Override
    public boolean matchesType(BeanInfo bean, Type requiredType) {
        BeanResolver beanResolver = this.getBeanResolver(bean);
        for (Type beanType : bean.getTypes()) {
            if (!beanResolver.matches(requiredType, beanType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasQualifier(Collection<AnnotationInstance> qualifiers, AnnotationInstance requiredQualifier) {
        return Beans.hasQualifier(this.beanDeployment, requiredQualifier, qualifiers);
    }

    protected BeanResolver getBeanResolver(BeanInfo bean) {
        return bean.getDeployment().beanResolver;
    }

    List<BeanInfo> resolve(InjectionPointInfo.TypeAndQualifiers typeAndQualifiers) {
        return this.resolved.computeIfAbsent(typeAndQualifiers, this::findMatching);
    }

    private List<BeanInfo> findMatching(InjectionPointInfo.TypeAndQualifiers typeAndQualifiers) {
        ArrayList resolved = new ArrayList();
        Collection<BeanInfo> potentialBeans = this.potentialBeans(typeAndQualifiers.type);
        for (BeanInfo b : potentialBeans) {
            if (!this.matches(b, typeAndQualifiers)) continue;
            resolved.add(b);
        }
        return resolved.isEmpty() ? Collections.emptyList() : resolved;
    }

    List<BeanInfo> findTypeMatching(Type type) {
        ArrayList resolved = new ArrayList();
        Collection<BeanInfo> potentialBeans = this.potentialBeans(type);
        for (BeanInfo b : potentialBeans) {
            if (!this.matchesType(b, type)) continue;
            resolved.add(b);
        }
        return resolved.isEmpty() ? Collections.emptyList() : resolved;
    }

    List<BeanInfo> findUnrestrictedTypeMatching(InjectionPointInfo.TypeAndQualifiers typeAndQualifiers) {
        ArrayList resolved = new ArrayList();
        block0: for (BeanInfo b : this.beanDeployment.getBeans()) {
            if (!Beans.hasQualifiers(b, typeAndQualifiers.qualifiers)) continue;
            for (Type type : b.getUnrestrictedTypes()) {
                if (!this.matches(typeAndQualifiers.type, type)) continue;
                resolved.add(b);
                continue block0;
            }
        }
        return resolved.isEmpty() ? Collections.emptyList() : resolved;
    }

    Collection<BeanInfo> potentialBeans(Type type) {
        if (!(type.kind() != Type.Kind.CLASS && type.kind() != Type.Kind.PARAMETERIZED_TYPE || type.name().equals((Object)DotNames.OBJECT))) {
            return this.beanDeployment.getBeansByRawType(type.name());
        }
        return this.beanDeployment.getBeans();
    }

    @Override
    public boolean matches(Type requiredType, Type beanType) {
        return this.matchesNoBoxing(Types.box(requiredType), Types.box(beanType));
    }

    boolean matchesNoBoxing(Type requiredType, Type beanType) {
        if (requiredType == beanType) {
            return true;
        }
        if (Type.Kind.ARRAY.equals((Object)requiredType.kind())) {
            if (Type.Kind.ARRAY.equals((Object)beanType.kind())) {
                return this.matchesNoBoxing(requiredType.asArrayType().constituent(), beanType.asArrayType().constituent());
            }
        } else if (Type.Kind.CLASS.equals((Object)requiredType.kind())) {
            if (Type.Kind.CLASS.equals((Object)beanType.kind())) {
                return requiredType.name().equals((Object)beanType.name());
            }
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)beanType.kind())) {
                if (!requiredType.name().equals((Object)beanType.asParameterizedType().name())) {
                    return false;
                }
                return BeanResolverImpl.containsUnboundedTypeVariablesOrObjects(beanType.asParameterizedType().arguments());
            }
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)requiredType.kind())) {
            if (Type.Kind.CLASS.equals((Object)beanType.kind())) {
                if (!beanType.name().equals((Object)requiredType.asParameterizedType().name())) {
                    return false;
                }
                return BeanResolverImpl.containsUnboundedTypeVariablesOrObjects(requiredType.asParameterizedType().arguments());
            }
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)beanType.kind())) {
                if (!requiredType.name().equals((Object)beanType.name())) {
                    return false;
                }
                List requiredTypeArguments = requiredType.asParameterizedType().arguments();
                List beanTypeArguments = beanType.asParameterizedType().arguments();
                if (requiredTypeArguments.size() != beanTypeArguments.size()) {
                    throw new IllegalArgumentException("Invalid argument combination " + String.valueOf(requiredType) + "; " + String.valueOf(beanType));
                }
                for (int i = 0; i < requiredTypeArguments.size(); ++i) {
                    if (this.matchTypeArguments((Type)requiredTypeArguments.get(i), (Type)beanTypeArguments.get(i))) continue;
                    return false;
                }
                return true;
            }
        } else if (Type.Kind.WILDCARD_TYPE.equals((Object)requiredType.kind())) {
            return this.matchTypeArguments(requiredType, beanType);
        }
        return false;
    }

    @Override
    public boolean matchTypeArguments(Type requiredParameter, Type beanParameter) {
        if (BeanResolverImpl.isActualType(requiredParameter) && BeanResolverImpl.isActualType(beanParameter)) {
            return this.matches(requiredParameter, beanParameter);
        }
        if (Type.Kind.WILDCARD_TYPE.equals((Object)requiredParameter.kind()) && BeanResolverImpl.isActualType(beanParameter)) {
            return this.parametersMatch(requiredParameter.asWildcardType(), beanParameter);
        }
        if (Type.Kind.WILDCARD_TYPE.equals((Object)requiredParameter.kind()) && Type.Kind.TYPE_VARIABLE.equals((Object)beanParameter.kind())) {
            return this.parametersMatch(requiredParameter.asWildcardType(), beanParameter.asTypeVariable());
        }
        if (BeanResolverImpl.isActualType(requiredParameter) && Type.Kind.TYPE_VARIABLE.equals((Object)beanParameter.kind())) {
            return this.parametersMatch(requiredParameter, beanParameter.asTypeVariable());
        }
        if (Type.Kind.TYPE_VARIABLE.equals((Object)requiredParameter.kind()) && Type.Kind.TYPE_VARIABLE.equals((Object)beanParameter.kind())) {
            return this.parametersMatch(requiredParameter.asTypeVariable(), beanParameter.asTypeVariable());
        }
        return false;
    }

    boolean parametersMatch(WildcardType requiredParameter, Type beanParameter) {
        return this.lowerBoundsOfWildcardMatch(beanParameter, requiredParameter) && this.upperBoundsOfWildcardMatch(requiredParameter, beanParameter);
    }

    boolean parametersMatch(WildcardType requiredParameter, TypeVariable beanParameter) {
        List<Type> beanParameterBounds = this.getUppermostTypeVariableBounds(beanParameter);
        if (!this.lowerBoundsOfWildcardMatch(beanParameterBounds, requiredParameter)) {
            return false;
        }
        List<Type> requiredUpperBounds = Collections.singletonList(requiredParameter.extendsBound());
        return this.boundsMatch(requiredUpperBounds, beanParameterBounds) || this.boundsMatch(beanParameterBounds, requiredUpperBounds);
    }

    boolean parametersMatch(Type requiredParameter, TypeVariable beanParameter) {
        for (Type bound : this.getUppermostTypeVariableBounds(beanParameter)) {
            if (this.beanDeployment.getAssignabilityCheck().isAssignableFrom(bound, requiredParameter)) continue;
            return false;
        }
        return true;
    }

    boolean parametersMatch(TypeVariable requiredParameter, TypeVariable beanParameter) {
        return this.boundsMatch(this.getUppermostTypeVariableBounds(beanParameter), this.getUppermostTypeVariableBounds(requiredParameter));
    }

    boolean boundsMatch(List<Type> bounds, List<Type> stricterBounds) {
        bounds = this.getUppermostBounds(bounds);
        stricterBounds = this.getUppermostBounds(stricterBounds);
        for (Type bound : bounds) {
            if (this.isAssignableFromAtLeastOne(bound, stricterBounds)) continue;
            return false;
        }
        return true;
    }

    boolean isAssignableFromAtLeastOne(Type type1, List<Type> types2) {
        for (Type type2 : types2) {
            if (!this.beanDeployment.getAssignabilityCheck().isAssignableFrom(type1, type2)) continue;
            return true;
        }
        return false;
    }

    boolean lowerBoundsOfWildcardMatch(Type parameter, WildcardType requiredParameter) {
        return this.lowerBoundsOfWildcardMatch(Collections.singletonList(parameter), requiredParameter);
    }

    boolean lowerBoundsOfWildcardMatch(List<Type> beanParameterBounds, WildcardType requiredParameter) {
        return requiredParameter.superBound() == null || this.boundsMatch(beanParameterBounds, Collections.singletonList(requiredParameter.superBound()));
    }

    boolean upperBoundsOfWildcardMatch(WildcardType requiredParameter, Type parameter) {
        return this.boundsMatch(Collections.singletonList(requiredParameter.extendsBound()), Collections.singletonList(parameter));
    }

    List<Type> getUppermostTypeVariableBounds(TypeVariable bound) {
        if (Type.Kind.TYPE_VARIABLE.equals((Object)((Type)bound.bounds().get(0)).kind())) {
            return this.getUppermostTypeVariableBounds(((Type)bound.bounds().get(0)).asTypeVariable());
        }
        return bound.bounds();
    }

    List<Type> getUppermostBounds(List<Type> bounds) {
        if (Type.Kind.TYPE_VARIABLE.equals((Object)bounds.get(0).kind())) {
            return this.getUppermostTypeVariableBounds(bounds.get(0).asTypeVariable());
        }
        return bounds;
    }

    static boolean isActualType(Type type) {
        return Type.Kind.CLASS.equals((Object)type.kind()) || Type.Kind.PARAMETERIZED_TYPE.equals((Object)type.kind()) || Type.Kind.ARRAY.equals((Object)type.kind());
    }

    static boolean containsUnboundedTypeVariablesOrObjects(List<Type> types) {
        for (Type type : types) {
            List bounds;
            if (ClassType.OBJECT_TYPE.equals((Object)type) || Type.Kind.TYPE_VARIABLE.equals((Object)type.kind()) && ((bounds = type.asTypeVariable().bounds()).isEmpty() || bounds.size() == 1 && ClassType.OBJECT_TYPE.equals(bounds.get(0)))) continue;
            return false;
        }
        return true;
    }
}

