/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.Mockable;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AsmUtil;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ClientProxyGenerator
extends AbstractGenerator {
    static final String CLIENT_PROXY_SUFFIX = "_ClientProxy";
    static final String DELEGATE_METHOD_NAME = "arc$delegate";
    static final String SET_MOCK_METHOD_NAME = "arc$setMock";
    static final String CLEAR_MOCK_METHOD_NAME = "arc$clearMock";
    static final String GET_CONTEXTUAL_INSTANCE_METHOD_NAME = "arc_contextualInstance";
    static final String GET_BEAN = "arc_bean";
    static final String BEAN_FIELD = "bean";
    static final String MOCK_FIELD = "mock";
    static final String CONTEXT_FIELD = "context";
    private final Predicate<DotName> applicationClassPredicate;
    private final boolean mockable;
    private final Set<String> existingClasses;
    private final Set<DotName> singleContextNormalScopes;

    public ClientProxyGenerator(Predicate<DotName> applicationClassPredicate, boolean generateSources, boolean mockable, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Set<DotName> singleContextNormalScopes) {
        super(generateSources, reflectionRegistration);
        this.applicationClassPredicate = applicationClassPredicate;
        this.mockable = mockable;
        this.existingClasses = existingClasses;
        this.singleContextNormalScopes = singleContextNormalScopes;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean, String beanClassName, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        if (bean.getDeployment().hasRuntimeDeferredUnproxyableError(bean)) {
            return Collections.emptySet();
        }
        BeanGenerator.ProviderType providerType = new BeanGenerator.ProviderType(bean.getProviderType());
        ClassInfo providerClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getBeanArchiveIndex(), providerType.name());
        String baseName = this.getBaseName(beanClassName);
        String targetPackage = bean.getClientProxyPackageName();
        String generatedName = ClientProxyGenerator.generatedNameFromTarget(targetPackage, baseName, CLIENT_PROXY_SUFFIX);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(this.getApplicationClassTestName(bean)) || bean.hasBoundDecoratorWhichIsApplicationClass(this.applicationClassPredicate);
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.CLIENT_PROXY : null, this.generateSources);
        ArrayList<String> interfaces = new ArrayList<String>();
        String superClass = Object.class.getName();
        interfaces.add(ClientProxy.class.getName());
        boolean isInterface = false;
        if (Modifier.isInterface(providerClass.flags())) {
            isInterface = true;
            interfaces.add(providerType.className());
        } else {
            superClass = providerType.className();
        }
        if (this.mockable) {
            interfaces.add(Mockable.class.getName());
        }
        ClassCreator clientProxy = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).superClass(superClass).interfaces(interfaces.toArray(new String[0])).build();
        if (!providerClass.typeParameters().isEmpty()) {
            clientProxy.setSignature(AsmUtil.getGeneratedSubClassSignature(providerClass, bean.getProviderType()));
        }
        Map<ClassInfo, Map<String, Type>> resolvedTypeVariables = Types.resolvedTypeVariables(providerClass, bean.getDeployment());
        FieldCreator beanField = (FieldCreator)clientProxy.getFieldCreator(BEAN_FIELD, InjectableBean.class).setModifiers(18);
        if (this.mockable) {
            clientProxy.getFieldCreator(MOCK_FIELD, providerType.descriptorName()).setModifiers(66);
        }
        FieldCreator contextField = null;
        if (BuiltinScope.APPLICATION.is(bean.getScope()) || this.singleContextNormalScopes.contains(bean.getScope().getDotName())) {
            contextField = (FieldCreator)clientProxy.getFieldCreator(CONTEXT_FIELD, InjectableContext.class).setModifiers(18);
        }
        this.createConstructor(clientProxy, superClass, beanField.getFieldDescriptor(), contextField != null ? contextField.getFieldDescriptor() : null);
        this.implementDelegate(clientProxy, providerType, beanField.getFieldDescriptor(), bean);
        this.implementGetContextualInstance(clientProxy, providerType);
        this.implementGetBean(clientProxy, beanField.getFieldDescriptor());
        if (this.mockable) {
            this.implementMockMethods(clientProxy, providerType);
        }
        for (MethodInfo method : this.getDelegatingMethods(bean, bytecodeTransformerConsumer, transformUnproxyableClasses)) {
            ResultHandle ret;
            MethodDescriptor originalMethodDescriptor = MethodDescriptor.of((MethodInfo)method);
            MethodCreator forward = clientProxy.getMethodCreator(originalMethodDescriptor);
            if (method.requiresGenericSignature()) {
                Map<String, Type> methodClassVariables = resolvedTypeVariables.get(method.declaringClass());
                String signature = method.genericSignature(typeVariable -> {
                    if (methodClassVariables != null) {
                        return (Type)methodClassVariables.get(typeVariable);
                    }
                    return null;
                });
                forward.setSignature(signature);
            }
            for (Type exception : method.exceptions()) {
                forward.addException(exception.name().toString());
            }
            ResultHandle[] params = new ResultHandle[method.parametersCount()];
            for (int i = 0; i < method.parametersCount(); ++i) {
                params[i] = forward.getMethodParam(i);
            }
            if (!superClass.equals(Object.class.getName())) {
                BytecodeCreator notConstructed = forward.ifNull(forward.readInstanceField(beanField.getFieldDescriptor(), forward.getThis())).trueBranch();
                if (method.isAbstract()) {
                    notConstructed.throwException(IllegalStateException.class, "Cannot invoke abstract method");
                } else {
                    MethodDescriptor superDescriptor = MethodDescriptor.ofMethod((Object)superClass, (String)method.name(), (Object)method.returnType().name().toString(), (Object[])method.parameterTypes().stream().map(p -> p.name().toString()).toArray());
                    notConstructed.returnValue(notConstructed.invokeSpecialMethod(superDescriptor, notConstructed.getThis(), params));
                }
            }
            ResultHandle delegate = forward.invokeVirtualMethod(MethodDescriptor.ofMethod((String)generatedName, (String)DELEGATE_METHOD_NAME, (String)providerType.descriptorName(), (String[])new String[0]), forward.getThis(), new ResultHandle[0]);
            if (Methods.isObjectToString(method)) {
                ret = forward.invokeVirtualMethod(originalMethodDescriptor, delegate, params);
            } else if (isInterface) {
                virtualMethod = MethodDescriptor.ofMethod((String)providerType.className(), (String)originalMethodDescriptor.getName(), (String)originalMethodDescriptor.getReturnType(), (String[])originalMethodDescriptor.getParameterTypes());
                ret = forward.invokeInterfaceMethod(virtualMethod, delegate, params);
            } else if (this.isReflectionFallbackNeeded(method, targetPackage)) {
                ResultHandle paramTypesArray = forward.newArray(Class.class, forward.load(method.parametersCount()));
                int idx = 0;
                for (Type param : method.parameterTypes()) {
                    forward.writeArrayValue(paramTypesArray, idx++, forward.loadClass(param.name().toString()));
                }
                ResultHandle argsArray = forward.newArray(Object.class, forward.load(params.length));
                idx = 0;
                for (ResultHandle argHandle : params) {
                    forward.writeArrayValue(argsArray, idx++, argHandle);
                }
                this.reflectionRegistration.registerMethod(method);
                ret = forward.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{forward.loadClass(method.declaringClass().name().toString()), forward.load(method.name()), paramTypesArray, delegate, argsArray});
            } else {
                virtualMethod = MethodDescriptor.ofMethod((String)providerType.className(), (String)originalMethodDescriptor.getName(), (String)originalMethodDescriptor.getReturnType(), (String[])originalMethodDescriptor.getParameterTypes());
                ret = forward.invokeVirtualMethod(virtualMethod, delegate, params);
            }
            forward.returnValue(ret);
        }
        clientProxy.close();
        return classOutput.getResources();
    }

    private void implementMockMethods(ClassCreator clientProxy, BeanGenerator.ProviderType providerType) {
        MethodCreator clear = clientProxy.getMethodCreator(MethodDescriptor.ofMethod((Object)clientProxy.getClassName(), (String)CLEAR_MOCK_METHOD_NAME, Void.TYPE, (Object[])new Object[0]));
        clear.writeInstanceField(FieldDescriptor.of((String)clientProxy.getClassName(), (String)MOCK_FIELD, (String)providerType.descriptorName()), clear.getThis(), clear.loadNull());
        clear.returnValue(null);
        MethodCreator set = clientProxy.getMethodCreator(MethodDescriptor.ofMethod((Object)clientProxy.getClassName(), (String)SET_MOCK_METHOD_NAME, Void.TYPE, (Object[])new Object[]{Object.class}));
        set.writeInstanceField(FieldDescriptor.of((String)clientProxy.getClassName(), (String)MOCK_FIELD, (String)providerType.descriptorName()), set.getThis(), set.getMethodParam(0));
        set.returnValue(null);
    }

    void createConstructor(ClassCreator clientProxy, String superClasName, FieldDescriptor beanField, FieldDescriptor contextField) {
        MethodCreator creator = clientProxy.getMethodCreator("<init>", Void.TYPE, new Class[]{String.class});
        creator.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)superClasName, (String[])new String[0]), creator.getThis(), new ResultHandle[0]);
        ResultHandle containerHandle = creator.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
        ResultHandle beanIdentifierHandle = creator.getMethodParam(0);
        ResultHandle beanHandle = creator.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{beanIdentifierHandle});
        creator.writeInstanceField(beanField, creator.getThis(), beanHandle);
        if (contextField != null) {
            ResultHandle contextList = creator.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_GET_CONTEXTS, containerHandle, new ResultHandle[]{creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InjectableBean.class, (String)"getScope", Class.class, (Class[])new Class[0]), beanHandle, new ResultHandle[0])});
            creator.writeInstanceField(contextField, creator.getThis(), creator.invokeInterfaceMethod(MethodDescriptors.LIST_GET, contextList, new ResultHandle[]{creator.load(0)}));
        }
        creator.returnValue(null);
    }

    void implementDelegate(ClassCreator clientProxy, BeanGenerator.ProviderType providerType, FieldDescriptor beanField, BeanInfo bean) {
        MethodCreator creator = (MethodCreator)clientProxy.getMethodCreator(DELEGATE_METHOD_NAME, providerType.descriptorName(), new String[0]).setModifiers(2);
        if (this.mockable) {
            ResultHandle mock = creator.readInstanceField(FieldDescriptor.of((String)clientProxy.getClassName(), (String)MOCK_FIELD, (String)providerType.descriptorName()), creator.getThis());
            BytecodeCreator falseBranch = creator.ifNull(mock).falseBranch();
            falseBranch.returnValue(mock);
        }
        ResultHandle beanHandle = creator.readInstanceField(beanField, creator.getThis());
        if (BuiltinScope.APPLICATION.is(bean.getScope())) {
            creator.returnValue(creator.invokeStaticMethod(MethodDescriptors.CLIENT_PROXIES_GET_APP_SCOPED_DELEGATE, new ResultHandle[]{creator.readInstanceField(FieldDescriptor.of((String)clientProxy.getClassName(), (String)CONTEXT_FIELD, InjectableContext.class), creator.getThis()), beanHandle}));
        } else if (this.singleContextNormalScopes.contains(bean.getScope().getDotName())) {
            creator.returnValue(creator.invokeStaticMethod(MethodDescriptors.CLIENT_PROXIES_GET_SINGLE_CONTEXT_DELEGATE, new ResultHandle[]{creator.readInstanceField(FieldDescriptor.of((String)clientProxy.getClassName(), (String)CONTEXT_FIELD, InjectableContext.class), creator.getThis()), beanHandle}));
        } else {
            creator.returnValue(creator.invokeStaticMethod(MethodDescriptors.CLIENT_PROXIES_GET_DELEGATE, new ResultHandle[]{beanHandle}));
        }
    }

    void implementGetContextualInstance(ClassCreator clientProxy, BeanGenerator.ProviderType providerType) {
        MethodCreator creator = (MethodCreator)clientProxy.getMethodCreator(GET_CONTEXTUAL_INSTANCE_METHOD_NAME, Object.class, new Class[0]).setModifiers(1);
        creator.returnValue(creator.invokeVirtualMethod(MethodDescriptor.ofMethod((String)clientProxy.getClassName(), (String)DELEGATE_METHOD_NAME, (String)providerType.descriptorName(), (String[])new String[0]), creator.getThis(), new ResultHandle[0]));
    }

    void implementGetBean(ClassCreator clientProxy, FieldDescriptor beanField) {
        MethodCreator creator = (MethodCreator)clientProxy.getMethodCreator(GET_BEAN, InjectableBean.class, new Class[0]).setModifiers(1);
        creator.returnValue(creator.readInstanceField(beanField, creator.getThis()));
    }

    Collection<MethodInfo> getDelegatingMethods(BeanInfo bean, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        HashMap<Methods.MethodKey, MethodInfo> methods = new HashMap<Methods.MethodKey, MethodInfo>();
        IndexView index = bean.getDeployment().getBeanArchiveIndex();
        if (bean.isClassBean()) {
            HashMap<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal = new HashMap<String, Set<Methods.MethodKey>>();
            ClassInfo classInfo = bean.getTarget().get().asClass();
            this.addDelegatesAndTransformIfNecessary(bytecodeTransformerConsumer, transformUnproxyableClasses, methods, index, methodsFromWhichToRemoveFinal, classInfo);
        } else if (bean.isProducerMethod()) {
            HashMap<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal = new HashMap<String, Set<Methods.MethodKey>>();
            MethodInfo producerMethod = bean.getTarget().get().asMethod();
            ClassInfo returnTypeClass = IndexClassLookupUtils.getClassByName(index, producerMethod.returnType());
            this.addDelegatesAndTransformIfNecessary(bytecodeTransformerConsumer, transformUnproxyableClasses, methods, index, methodsFromWhichToRemoveFinal, returnTypeClass);
        } else if (bean.isProducerField()) {
            HashMap<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal = new HashMap<String, Set<Methods.MethodKey>>();
            FieldInfo producerField = bean.getTarget().get().asField();
            ClassInfo fieldClass = IndexClassLookupUtils.getClassByName(index, producerField.type());
            this.addDelegatesAndTransformIfNecessary(bytecodeTransformerConsumer, transformUnproxyableClasses, methods, index, methodsFromWhichToRemoveFinal, fieldClass);
        } else if (bean.isSynthetic()) {
            Methods.addDelegatingMethods(index, bean.getImplClazz(), methods, null, transformUnproxyableClasses);
        }
        return methods.values();
    }

    private void addDelegatesAndTransformIfNecessary(Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses, Map<Methods.MethodKey, MethodInfo> methods, IndexView index, Map<String, Set<Methods.MethodKey>> methodsFromWhichToRemoveFinal, ClassInfo fieldClass) {
        Methods.addDelegatingMethods(index, fieldClass, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
        if (!methodsFromWhichToRemoveFinal.isEmpty()) {
            for (Map.Entry<String, Set<Methods.MethodKey>> entry : methodsFromWhichToRemoveFinal.entrySet()) {
                String className = entry.getKey();
                bytecodeTransformerConsumer.accept(new BytecodeTransformer(className, new Methods.RemoveFinalFromMethod(entry.getValue())));
            }
        }
    }

    private DotName getApplicationClassTestName(BeanInfo bean) {
        DotName testedName = bean.isProducerField() ? bean.getTarget().get().asField().type().name() : (bean.isProducerMethod() ? bean.getTarget().get().asMethod().returnType().name() : bean.getBeanClass());
        return testedName;
    }
}

