package io.quarkus.deployment.sbom;

import java.util.ArrayList;
import java.util.List;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.sbom.ApplicationManifest;

public class ApplicationManifestsBuildStep {

    /**
     * Aggregates application manifest configurations and creates application manifests from which
     * SBOMs could be generated by SBOM generating build steps.
     *
     * @param artifactResultBuildItems artifact results
     * @return application manifests for SBOM generation
     */
    @BuildStep
    public ApplicationManifestsBuildItem generate(List<ArtifactResultBuildItem> artifactResultBuildItems) {
        final List<ApplicationManifest> manifests = new ArrayList<>(artifactResultBuildItems.size());
        for (var artifactResult : artifactResultBuildItems) {
            var manifestConfig = artifactResult.getManifestConfig();
            if (manifestConfig != null) {
                manifests.add(ApplicationManifest.fromConfig(manifestConfig));
            }
        }
        return new ApplicationManifestsBuildItem(List.copyOf(manifests));
    }
}
