/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi;

import java.util.HashMap;
import java.util.Map;

public class DevUIContent {
    private final String fileName;
    private final byte[] template;
    private final Map<String, Object> data;
    private final Map<String, String> descriptions;
    private final Map<String, String> mcpDefaultEnabled;
    private final Map<String, String> contentTypes;

    private DevUIContent(Builder builder) {
        this.fileName = builder.fileName;
        this.template = builder.template;
        this.data = builder.data;
        this.descriptions = builder.descriptions;
        this.mcpDefaultEnabled = builder.mcpDefaultEnabled;
        this.contentTypes = builder.contentTypes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getTemplate() {
        return this.template;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public Map<String, String> getMcpDefaultEnables() {
        return this.mcpDefaultEnabled;
    }

    public Map<String, String> getContentTypes() {
        return this.contentTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String fileName;
        private byte[] template;
        private Map<String, Object> data = new HashMap<String, Object>();
        private Map<String, String> descriptions;
        private Map<String, String> contentTypes;
        private Map<String, String> mcpDefaultEnabled;
        private static final String ERROR = "Not enough information to create Dev UI content.";
        private static final byte[] DEFAULT_TEMPLATE = "Here the template of your page. Set your own by providing the template() in the DevUIContent".getBytes();

        private Builder() {
        }

        public Builder fileName(String fileName) {
            if (fileName == null || fileName.isEmpty()) {
                throw new RuntimeException("Invalid fileName");
            }
            this.fileName = fileName;
            return this;
        }

        public Builder template(byte[] template) {
            if (template == null || template.length == 0) {
                throw new RuntimeException("Invalid template");
            }
            this.template = template;
            return this;
        }

        public Builder addData(Map<String, Object> data) {
            this.data.putAll(data);
            return this;
        }

        public Builder addData(String key, Object value) {
            this.data.put(key, value);
            return this;
        }

        public Builder descriptions(Map<String, String> descriptions) {
            this.descriptions = descriptions;
            return this;
        }

        public Builder mcpDefaultEnables(Map<String, String> mcpDefaultEnabled) {
            this.mcpDefaultEnabled = mcpDefaultEnabled;
            return this;
        }

        public Builder contentTypes(Map<String, String> contentTypes) {
            this.contentTypes = contentTypes;
            return this;
        }

        public DevUIContent build() {
            if (this.fileName == null) {
                throw new RuntimeException("Not enough information to create Dev UI content. FileName is mandatory, for example 'index.html'");
            }
            if (this.template == null) {
                this.template = DEFAULT_TEMPLATE;
            }
            return new DevUIContent(this);
        }
    }
}

