/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.mutiny.common.runtime;

import io.quarkus.resteasy.mutiny.common.runtime.MultiRxInvoker;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.SyncInvoker;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.sse.SseEventSource;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.plugins.providers.sse.InboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceImpl;

public class MultiRxInvokerImpl
implements MultiRxInvoker {
    private static Object monitor = new Object();
    private ClientInvocationBuilder syncInvoker;
    private ScheduledExecutorService executorService;
    private BackPressureStrategy backpressureStrategy = BackPressureStrategy.BUFFER;

    public MultiRxInvokerImpl(SyncInvoker syncInvoker, ExecutorService executorService) {
        if (!(syncInvoker instanceof ClientInvocationBuilder)) {
            throw new ProcessingException("Expected a ClientInvocationBuilder");
        }
        this.syncInvoker = (ClientInvocationBuilder)syncInvoker;
        if (executorService instanceof ScheduledExecutorService) {
            this.executorService = (ScheduledExecutorService)executorService;
        }
    }

    @Override
    public BackPressureStrategy getBackPressureStrategy() {
        return this.backpressureStrategy;
    }

    @Override
    public void setBackPressureStrategy(BackPressureStrategy strategy) {
        this.backpressureStrategy = strategy;
    }

    public Multi<?> get() {
        return this.eventSourceToMulti(this.getEventSource(), String.class, "GET", null, this.getAccept());
    }

    public <R> Multi<?> get(Class<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "GET", null, this.getAccept());
    }

    public <R> Multi<?> get(GenericType<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "GET", null, this.getAccept());
    }

    public Multi<?> put(Entity<?> entity) {
        return this.eventSourceToMulti(this.getEventSource(), String.class, "PUT", entity, this.getAccept());
    }

    public <R> Multi<?> put(Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "PUT", entity, this.getAccept());
    }

    public <R> Multi<?> put(Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "PUT", entity, this.getAccept());
    }

    public Multi<?> post(Entity<?> entity) {
        return this.eventSourceToMulti(this.getEventSource(), String.class, "POST", entity, this.getAccept());
    }

    public <R> Multi<?> post(Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "POST", entity, this.getAccept());
    }

    public <R> Multi<?> post(Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "POST", entity, this.getAccept());
    }

    public Multi<?> delete() {
        return this.eventSourceToMulti(this.getEventSource(), String.class, "DELETE", null, this.getAccept());
    }

    public <R> Multi<?> delete(Class<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "DELETE", null, this.getAccept());
    }

    public <R> Multi<?> delete(GenericType<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "DELETE", null, this.getAccept());
    }

    public Multi<?> head() {
        return this.eventSourceToMulti(this.getEventSource(), String.class, "HEAD", null, this.getAccept());
    }

    public Multi<?> options() {
        return this.eventSourceToMulti(this.getEventSource(), String.class, "OPTIONS", null, this.getAccept());
    }

    public <R> Multi<?> options(Class<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "OPTIONS", null, this.getAccept());
    }

    public <R> Multi<?> options(GenericType<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "OPTIONS", null, this.getAccept());
    }

    public Multi<?> trace() {
        return this.eventSourceToMulti(this.getEventSource(), String.class, "TRACE", null, this.getAccept());
    }

    public <R> Multi<?> trace(Class<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "TRACE", null, this.getAccept());
    }

    public <R> Multi<?> trace(GenericType<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, "TRACE", null, this.getAccept());
    }

    public Multi<?> method(String name) {
        return this.eventSourceToMulti(this.getEventSource(), String.class, name, null, this.getAccept());
    }

    public <R> Multi<?> method(String name, Class<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, name, null, this.getAccept());
    }

    public <R> Multi<?> method(String name, GenericType<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, name, null, this.getAccept());
    }

    public Multi<?> method(String name, Entity<?> entity) {
        return this.eventSourceToMulti(this.getEventSource(), String.class, name, entity, this.getAccept());
    }

    public <R> Multi<?> method(String name, Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, name, entity, this.getAccept());
    }

    public <R> Multi<?> method(String name, Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToMulti(this.getEventSource(), responseType, name, entity, this.getAccept());
    }

    private <T> Multi<T> eventSourceToMulti(SseEventSourceImpl sseEventSource, Class<T> clazz, String verb, Entity<?> entity, MediaType[] mediaTypes) {
        return this.eventSourceToMulti(sseEventSource, (InboundSseEventImpl e) -> e.readData(clazz, e.getMediaType()), verb, entity, mediaTypes);
    }

    private <T> Multi<T> eventSourceToMulti(SseEventSourceImpl sseEventSource, GenericType<T> type, String verb, Entity<?> entity, MediaType[] mediaTypes) {
        return this.eventSourceToMulti(sseEventSource, (InboundSseEventImpl e) -> e.readData(type, e.getMediaType()), verb, entity, mediaTypes);
    }

    private <T> Multi<T> eventSourceToMulti(SseEventSourceImpl sseEventSource, Function<InboundSseEventImpl, T> tSupplier, String verb, Entity<?> entity, MediaType[] mediaTypes) {
        Multi multi = Multi.createFrom().emitter(emitter -> {
            sseEventSource.register(e -> emitter.emit(tSupplier.apply((InboundSseEventImpl)e)), t -> emitter.fail(t), () -> emitter.complete());
            Object object = monitor;
            synchronized (object) {
                if (!sseEventSource.isOpen()) {
                    sseEventSource.open(null, verb, entity, mediaTypes);
                }
            }
        }, this.backpressureStrategy);
        return multi;
    }

    private SseEventSourceImpl getEventSource() {
        SseEventSourceImpl.SourceBuilder builder = (SseEventSourceImpl.SourceBuilder)SseEventSource.target((WebTarget)this.syncInvoker.getTarget());
        if (this.executorService != null) {
            builder.executor(this.executorService);
        }
        SseEventSourceImpl sseEventSource = (SseEventSourceImpl)builder.alwaysReconnect(false).build();
        return sseEventSource;
    }

    private MediaType[] getAccept() {
        if (this.syncInvoker != null) {
            ClientInvocationBuilder builder = this.syncInvoker;
            List accept = builder.getHeaders().getAcceptableMediaTypes();
            return accept.toArray(new MediaType[0]);
        }
        return null;
    }
}

