package io.vertx.mutiny.core;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.VertxOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A builder for creating Vert.x instances, allowing to configure Vert.x plugins:
 *
 * <ul>
 *   <li>metrics</li>
 *   <li>tracing</li>
 *   <li>cluster manager</li>
 * </ul>
 *
 * Example usage:
 *
 * <pre><code>
 *   Vertx vertx = Vertx.builder().with(options).withMetrics(metricsFactory).build();
 * </code></pre>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.VertxBuilder original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.VertxBuilder.class)
public class VertxBuilder {

  public static final io.smallrye.mutiny.vertx.TypeArg<VertxBuilder> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new VertxBuilder((io.vertx.core.VertxBuilder) obj),
    VertxBuilder::getDelegate
  );

  private final io.vertx.core.VertxBuilder delegate;
  
  public VertxBuilder(io.vertx.core.VertxBuilder delegate) {
    this.delegate = delegate;
  }

  public VertxBuilder(Object delegate) {
    this.delegate = (io.vertx.core.VertxBuilder)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  VertxBuilder() {
    this.delegate = null;
  }

  public io.vertx.core.VertxBuilder getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VertxBuilder that = (VertxBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param options the Vert.x options
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.VertxBuilder with(io.vertx.core.VertxOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * @return the instance
   */
  public io.vertx.mutiny.core.Vertx build() { 
    io.vertx.mutiny.core.Vertx ret = io.vertx.mutiny.core.Vertx.newInstance((io.vertx.core.Vertx)delegate.build());
    return ret;
  }

  /**
   * Creates a clustered instance.
   * <p>
   * The instance is created asynchronously and the returned future is completed with the result when it is ready.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.Vertx> buildClustered() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.buildClustered(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.Vertx.newInstance((io.vertx.core.Vertx)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.VertxBuilder#buildClustered}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Vertx instance produced by the operation.
   */
  public io.vertx.mutiny.core.Vertx buildClusteredAndAwait() { 
    return (io.vertx.mutiny.core.Vertx) buildClustered().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.VertxBuilder#buildClustered} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.VertxBuilder#buildClustered}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.VertxBuilder#buildClustered} but you don't need to compose it with other operations.
   */
  public void buildClusteredAndForget() { 
    buildClustered().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param factory the metrics factory
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.VertxBuilder withMetrics(io.vertx.core.spi.VertxMetricsFactory factory) { 
    delegate.withMetrics(factory);
    return this;
  }

  /**
   * @param factory the tracer factory
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.VertxBuilder withTracer(io.vertx.core.spi.VertxTracerFactory factory) { 
    delegate.withTracer(factory);
    return this;
  }

  /**
   * @param clusterManager the cluster manager
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.VertxBuilder withClusterManager(io.vertx.core.spi.cluster.ClusterManager clusterManager) { 
    delegate.withClusterManager(clusterManager);
    return this;
  }

  public static  VertxBuilder newInstance(io.vertx.core.VertxBuilder arg) {
    return arg != null ? new VertxBuilder(arg) : null;
  }

}
