package io.vertx.mutiny.core.parsetools;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A parser class which allows to incrementally parse json elements and emit json parse events instead of parsing a json
 * element fully. This parser is convenient for parsing large json structures.
 * <p/>
 * The parser also parses concatenated json streams or line delimited json streams.
 * <p/>
 * The parser can also parse entire object or array when it is convenient, for instance a very large array
 * of small objects can be parsed efficiently by handling array <i>start</i>/<i>end</i> and <i>object</i>
 * events.
 * <p/>
 * Whenever the parser fails to parse or process the stream, the {@link io.vertx.mutiny.core.parsetools.JsonParser#exceptionHandler} is called with
 * the cause of the failure and the current handling stops. After such event, the parser should not handle data
 * anymore.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.JsonParser original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.parsetools.JsonParser.class)
public class JsonParser implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.parsetools.JsonEvent>, io.vertx.core.Handler<io.vertx.mutiny.core.buffer.Buffer>, java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<JsonParser> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JsonParser((io.vertx.core.parsetools.JsonParser) obj),
    JsonParser::getDelegate
  );

  private final io.vertx.core.parsetools.JsonParser delegate;
  
  public JsonParser(io.vertx.core.parsetools.JsonParser delegate) {
    this.delegate = delegate;
  }

  public JsonParser(Object delegate) {
    this.delegate = (io.vertx.core.parsetools.JsonParser)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JsonParser() {
    this.delegate = null;
  }

  public io.vertx.core.parsetools.JsonParser getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.parsetools.JsonEvent> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.parsetools.JsonEvent>(o1 -> io.vertx.mutiny.core.parsetools.JsonEvent.newInstance((io.vertx.core.parsetools.JsonEvent)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonParser that = (JsonParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param event the event to handle
   */
  public void handle(io.vertx.mutiny.core.buffer.Buffer event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.parsetools.JsonEvent> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.parsetools.JsonEvent> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.parsetools.JsonEvent> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.parsetools.JsonEvent> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.parsetools.JsonEvent> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.JsonParser newParser() { 
    io.vertx.mutiny.core.parsetools.JsonParser ret = io.vertx.mutiny.core.parsetools.JsonParser.newInstance((io.vertx.core.parsetools.JsonParser)io.vertx.core.parsetools.JsonParser.newParser());
    return ret;
  }

  /**
   * @param stream 
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.JsonParser newParser(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.JsonParser ret = io.vertx.mutiny.core.parsetools.JsonParser.newInstance((io.vertx.core.parsetools.JsonParser)io.vertx.core.parsetools.JsonParser.newParser(stream.getDelegate()));
    return ret;
  }

  /**
   * @param stream 
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.JsonParser newParser(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.JsonParser ret = io.vertx.mutiny.core.parsetools.JsonParser.newInstance((io.vertx.core.parsetools.JsonParser)io.vertx.core.parsetools.JsonParser.newParser(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * @param buffer 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.parsetools.JsonParser write(io.vertx.mutiny.core.buffer.Buffer buffer) { 
    delegate.write(buffer.getDelegate());
    return this;
  }

  /**
   */
  public void end() { 
    delegate.end();
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.parsetools.JsonParser objectEventMode() { 
    delegate.objectEventMode();
    return this;
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.parsetools.JsonParser objectValueMode() { 
    delegate.objectValueMode();
    return this;
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.parsetools.JsonParser arrayEventMode() { 
    delegate.arrayEventMode();
    return this;
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.parsetools.JsonParser arrayValueMode() { 
    delegate.arrayValueMode();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.parsetools.JsonParser pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.parsetools.JsonParser resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.parsetools.JsonParser fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.parsetools.JsonParser __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.parsetools.JsonParser endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  @Fluent
  private io.vertx.mutiny.core.parsetools.JsonParser __handler(Handler<io.vertx.mutiny.core.parsetools.JsonEvent> handler) { 
    delegate.handler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.parsetools.JsonEvent.newInstance((io.vertx.core.parsetools.JsonEvent)event)));
    return this;
  }

  public io.vertx.mutiny.core.parsetools.JsonParser handler(java.util.function.Consumer<io.vertx.mutiny.core.parsetools.JsonEvent> handler) {
    return __handler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  private io.vertx.mutiny.core.parsetools.JsonParser __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.parsetools.JsonParser exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  private Multi<io.vertx.mutiny.core.parsetools.JsonEvent> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.core.parsetools.JsonEvent> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.parsetools.JsonEvent, io.vertx.mutiny.core.parsetools.JsonEvent> conv = io.vertx.mutiny.core.parsetools.JsonEvent::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.parsetools.JsonEvent> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.core.parsetools.JsonEvent> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public void accept(io.vertx.mutiny.core.buffer.Buffer item) {
    handle(item);
  }
  public static  JsonParser newInstance(io.vertx.core.parsetools.JsonParser arg) {
    return arg != null ? new JsonParser(arg) : null;
  }

}
