package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * A handler which gathers the entire request body and sets it on the .
 * <p>
 * It also handles HTTP file uploads and can be used to limit body sizes.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.BodyHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.BodyHandler.class)
public class BodyHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<BodyHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new BodyHandler((io.vertx.ext.web.handler.BodyHandler) obj),
    BodyHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.BodyHandler delegate;
  
  public BodyHandler(io.vertx.ext.web.handler.BodyHandler delegate) {
    this.delegate = delegate;
  }

  public BodyHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.BodyHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  BodyHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.BodyHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BodyHandler that = (BodyHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @return the body handler
   */
  public static io.vertx.mutiny.ext.web.handler.BodyHandler create() { 
    io.vertx.mutiny.ext.web.handler.BodyHandler ret = io.vertx.mutiny.ext.web.handler.BodyHandler.newInstance((io.vertx.ext.web.handler.BodyHandler)io.vertx.ext.web.handler.BodyHandler.create());
    return ret;
  }

  /**
   * @param handleFileUploads true if files upload should be handled
   * @return the body handler
   */
  public static io.vertx.mutiny.ext.web.handler.BodyHandler create(boolean handleFileUploads) { 
    io.vertx.mutiny.ext.web.handler.BodyHandler ret = io.vertx.mutiny.ext.web.handler.BodyHandler.newInstance((io.vertx.ext.web.handler.BodyHandler)io.vertx.ext.web.handler.BodyHandler.create(handleFileUploads));
    return ret;
  }

  /**
   * @param uploadDirectory the uploads directory
   * @return the body handler
   */
  public static io.vertx.mutiny.ext.web.handler.BodyHandler create(String uploadDirectory) { 
    io.vertx.mutiny.ext.web.handler.BodyHandler ret = io.vertx.mutiny.ext.web.handler.BodyHandler.newInstance((io.vertx.ext.web.handler.BodyHandler)io.vertx.ext.web.handler.BodyHandler.create(uploadDirectory));
    return ret;
  }

  /**
   * @param handleFileUploads true if they should be handled
   * @return reference to this for fluency
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.BodyHandler setHandleFileUploads(boolean handleFileUploads) { 
    delegate.setHandleFileUploads(handleFileUploads);
    return this;
  }

  /**
   * @param bodyLimit the max size in bytes
   * @return reference to this for fluency
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.BodyHandler setBodyLimit(long bodyLimit) { 
    delegate.setBodyLimit(bodyLimit);
    return this;
  }

  /**
   * @param uploadsDirectory the uploads directory
   * @return reference to this for fluency
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.BodyHandler setUploadsDirectory(String uploadsDirectory) { 
    delegate.setUploadsDirectory(uploadsDirectory);
    return this;
  }

  /**
   * @param mergeFormAttributes true if they should be merged
   * @return reference to this for fluency
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) { 
    delegate.setMergeFormAttributes(mergeFormAttributes);
    return this;
  }

  /**
   * @param deleteUploadedFilesOnEnd true if uploaded files should be removed after handling the request
   * @return reference to this for fluency
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.BodyHandler setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) { 
    delegate.setDeleteUploadedFilesOnEnd(deleteUploadedFilesOnEnd);
    return this;
  }

  /**
   * @param isPreallocateBodyBuffer <code>true</code> if body buffer is pre-allocated according to the size read from content-length Header. {code false} if body buffer is pre-allocated to 1KB, and is resized dynamically
   * @return reference to this for fluency
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.BodyHandler setPreallocateBodyBuffer(boolean isPreallocateBodyBuffer) { 
    delegate.setPreallocateBodyBuffer(isPreallocateBodyBuffer);
    return this;
  }

  /**
   * Default max size for a request body in bytes = <code>10485760</code>, i.e. 10 megabytes
   */
  public static final long DEFAULT_BODY_LIMIT = io.vertx.ext.web.handler.BodyHandler.DEFAULT_BODY_LIMIT;
  /**
   * Default uploads directory on server for file uploads
   */
  public static final String DEFAULT_UPLOADS_DIRECTORY = io.vertx.ext.web.handler.BodyHandler.DEFAULT_UPLOADS_DIRECTORY;
  /**
   * Default value of whether form attributes should be merged into request params
   */
  public static final boolean DEFAULT_MERGE_FORM_ATTRIBUTES = io.vertx.ext.web.handler.BodyHandler.DEFAULT_MERGE_FORM_ATTRIBUTES;
  /**
   * Default value of whether uploaded files should be removed after handling the request
   */
  public static final boolean DEFAULT_DELETE_UPLOADED_FILES_ON_END = io.vertx.ext.web.handler.BodyHandler.DEFAULT_DELETE_UPLOADED_FILES_ON_END;
  /**
   * Default value of whether to pre-allocate the body buffer size according to the content-length HTTP request header
   */
  public static final boolean DEFAULT_PREALLOCATE_BODY_BUFFER = io.vertx.ext.web.handler.BodyHandler.DEFAULT_PREALLOCATE_BODY_BUFFER;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  BodyHandler newInstance(io.vertx.ext.web.handler.BodyHandler arg) {
    return arg != null ? new BodyHandler(arg) : null;
  }

}
