package io.vertx.mutiny.ext.web.sstore;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A session store is used to store sessions for an Vert.x-Web web app
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.SessionStore original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {

  public static final io.smallrye.mutiny.vertx.TypeArg<SessionStore> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore) obj),
    SessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.SessionStore delegate;
  
  public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
    this.delegate = delegate;
  }

  public SessionStore(Object delegate) {
    this.delegate = (io.vertx.ext.web.sstore.SessionStore)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SessionStore() {
    this.delegate = null;
  }

  public io.vertx.ext.web.sstore.SessionStore getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SessionStore that = (SessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx vertx instance
   * @return the store or runtime exception
   */
  public static io.vertx.mutiny.ext.web.sstore.SessionStore create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.web.sstore.SessionStore ret = io.vertx.mutiny.ext.web.sstore.SessionStore.newInstance((io.vertx.ext.web.sstore.SessionStore)io.vertx.ext.web.sstore.SessionStore.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx vertx instance
   * @param options extra options for initialization
   * @return the store or runtime exception
   */
  public static io.vertx.mutiny.ext.web.sstore.SessionStore create(io.vertx.mutiny.core.Vertx vertx, JsonObject options) { 
    io.vertx.mutiny.ext.web.sstore.SessionStore ret = io.vertx.mutiny.ext.web.sstore.SessionStore.newInstance((io.vertx.ext.web.sstore.SessionStore)io.vertx.ext.web.sstore.SessionStore.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param options optional Json with extra configuration options
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.sstore.SessionStore init(io.vertx.mutiny.core.Vertx vertx, JsonObject options) { 
    delegate.init(vertx.getDelegate(), options);
    return this;
  }

  /**
   * @return the timeout value, in ms
   */
  public long retryTimeout() { 
    long ret = delegate.retryTimeout();
    return ret;
  }

  /**
   * @param timeout - the session timeout, in ms
   * @return the session
   */
  public io.vertx.mutiny.ext.web.Session createSession(long timeout) { 
    io.vertx.mutiny.ext.web.Session ret = io.vertx.mutiny.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.createSession(timeout));
    return ret;
  }

  /**
   * @param timeout - the session timeout, in ms
   * @param length - the required length for the session id
   * @return the session
   */
  public io.vertx.mutiny.ext.web.Session createSession(long timeout, int length) { 
    io.vertx.mutiny.ext.web.Session ret = io.vertx.mutiny.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.createSession(timeout, length));
    return ret;
  }

  /**
   * Get the session with the specified ID.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param cookieValue the unique ID of the session
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.Session> get(String cookieValue) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.get(cookieValue, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.Session.newInstance((io.vertx.ext.web.Session)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#get(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param cookieValue the unique ID of the session
   * @return the Session instance produced by the operation.
   */
  public io.vertx.mutiny.ext.web.Session getAndAwait(String cookieValue) { 
    return (io.vertx.mutiny.ext.web.Session) get(cookieValue).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#get(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#get(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.sstore.SessionStore#get(String)} but you don't need to compose it with other operations.
   * @param cookieValue the unique ID of the session
   * @return the instance of SessionStore to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.sstore.SessionStore getAndForget(String cookieValue) { 
    get(cookieValue).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Delete the session with the specified ID.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the session id
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> delete(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.delete(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#delete(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the session id
   * @return the Void instance produced by the operation.
   */
  public Void deleteAndAwait(String id) { 
    return (Void) delete(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#delete(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#delete(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.sstore.SessionStore#delete(String)} but you don't need to compose it with other operations.
   * @param id the session id
   * @return the instance of SessionStore to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.sstore.SessionStore deleteAndForget(String id) { 
    delete(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Add a session with the specified ID.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param session the session
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> put(io.vertx.mutiny.ext.web.Session session) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.put(session.getDelegate(), resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#put(io.vertx.mutiny.ext.web.Session)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param session the session
   * @return the Void instance produced by the operation.
   */
  public Void putAndAwait(io.vertx.mutiny.ext.web.Session session) { 
    return (Void) put(session).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#put(io.vertx.mutiny.ext.web.Session)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#put(io.vertx.mutiny.ext.web.Session)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.sstore.SessionStore#put(io.vertx.mutiny.ext.web.Session)} but you don't need to compose it with other operations.
   * @param session the session
   * @return the instance of SessionStore to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.sstore.SessionStore putAndForget(io.vertx.mutiny.ext.web.Session session) { 
    put(session).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove all sessions from the store.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> clear() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.clear(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#clear}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void clearAndAwait() { 
    return (Void) clear().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#clear} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#clear}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.sstore.SessionStore#clear} but you don't need to compose it with other operations.
   * @return the instance of SessionStore to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.sstore.SessionStore clearAndForget() { 
    clear().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the number of sessions in the store.
   * <p>
   * Beware of the result which is just an estimate, in particular with distributed session stores.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Integer> size() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.size(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#size}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Integer instance produced by the operation.
   */
  public Integer sizeAndAwait() { 
    return (Integer) size().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#size} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.web.sstore.SessionStore#size}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.web.sstore.SessionStore#size} but you don't need to compose it with other operations.
   * @return the instance of SessionStore to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.sstore.SessionStore sizeAndForget() { 
    size().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.SessionStore.DEFAULT_SESSIONID_LENGTH;
  public static  SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
    return arg != null ? new SessionStore(arg) : null;
  }

}
