/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.BasicType;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISyntaxRule;
import io.xlate.edi.schema.EDIType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class StructureType
extends BasicType
implements EDIComplexType {
    private static final String TOSTRING_FORMAT = "id: %s, type: %s, code: %s, references: [%s], syntaxRestrictions: [%s]";
    private String code;
    private List<EDIReference> references;
    private List<EDISyntaxRule> syntaxRules;

    StructureType(String id, EDIType.Type type, String code, List<EDIReference> references, List<EDISyntaxRule> syntaxRules, String title, String description) {
        super(id, type, title, description);
        Objects.requireNonNull(code, "EDIComplexType code must not be null");
        Objects.requireNonNull(references, "EDIComplexType references must not be null");
        Objects.requireNonNull(syntaxRules, "EDIComplexType id must not be null");
        this.code = code;
        this.references = Collections.unmodifiableList(new ArrayList<EDIReference>(references));
        this.syntaxRules = Collections.unmodifiableList(new ArrayList<EDISyntaxRule>(syntaxRules));
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, new Object[]{this.getId(), this.getType(), this.code, this.references.stream().map(r -> "{" + r + '}').collect(Collectors.joining(",")), this.syntaxRules.stream().map(r -> "{" + r + '}').collect(Collectors.joining(","))});
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public List<EDIReference> getReferences() {
        return this.references;
    }

    @Override
    public List<EDISyntaxRule> getSyntaxRules() {
        return this.syntaxRules;
    }
}

