/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import java.nio.CharBuffer;

public class CharArraySequence
implements CharSequence,
Comparable<CharSequence> {
    private static final char[] EMPTY = new char[0];
    private char[] text = EMPTY;
    private int start = 0;
    private int length = 0;

    public void set(char[] text, int start, int length) {
        this.text = text;
        this.start = start;
        this.length = length;
    }

    public void clear() {
        this.text = EMPTY;
        this.start = 0;
        this.length = 0;
    }

    public void putToBuffer(CharBuffer buffer) {
        buffer.put(this.text, this.start, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.text[this.start + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(start));
        }
        if (end > this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(end));
        }
        if (start > end) {
            throw new IndexOutOfBoundsException(Integer.toString(end - start));
        }
        return start == 0 && end == this.length ? this : new String(this.text, this.start + start, end - start);
    }

    @Override
    public int compareTo(CharSequence other) {
        int len1 = this.length;
        int len2 = other.length();
        int n = Math.min(len1, len2);
        char[] v1 = this.text;
        int i = this.start;
        int j = 0;
        while (n-- != 0) {
            char c2;
            char c1;
            if ((c1 = v1[i++]) == (c2 = other.charAt(j++))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @Override
    public String toString() {
        return this.length > 0 ? new String(this.text, this.start, this.length) : "";
    }
}

