/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.StaEDIXMLStreamReader;
import io.xlate.edi.stream.EDINamespaces;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

class DocumentNamespaceContext
implements NamespaceContext {
    private final Map<String, String> namespaces;

    DocumentNamespaceContext() {
        List<String> names = EDINamespaces.all();
        this.namespaces = new HashMap<String, String>(names.size());
        for (String namespace : names) {
            String prefix = StaEDIXMLStreamReader.prefixOf(namespace);
            this.namespaces.put(namespace, prefix);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaces.entrySet().stream().filter(e -> ((String)e.getValue()).equals(prefix)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.namespaces.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return Collections.singletonList(this.namespaces.get(namespaceURI)).iterator();
    }
}

