/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.json;

import io.xlate.edi.internal.stream.json.StaEDIJakartaJsonParser;
import io.xlate.edi.internal.stream.json.StaEDIJavaxJsonParser;
import io.xlate.edi.internal.stream.json.StaEDIJsonParser;
import io.xlate.edi.stream.EDIStreamReader;
import java.util.Map;

public final class JsonParserFactory {
    private JsonParserFactory() {
    }

    public static <J> J createJsonParser(EDIStreamReader reader, Class<J> type, Map<String, Object> properties) {
        StaEDIJsonParser parser;
        switch (type.getName()) {
            case "jakarta.json.stream.JsonParser": {
                parser = new StaEDIJakartaJsonParser(reader, properties);
                break;
            }
            case "javax.json.stream.JsonParser": {
                parser = new StaEDIJavaxJsonParser(reader, properties);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported JSON parser type: " + type);
            }
        }
        return (J)parser;
    }
}

