/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import java.util.Objects;

public enum State {
    INVALID(0, -1),
    INITIAL(0, 0),
    INTERCHANGE_END(0, 0),
    HEADER_EDIFACT_U(0, 1),
    HEADER_EDIFACT_N(0, 2),
    HEADER_TRADACOMS_S(0, 3),
    HEADER_TRADACOMS_T(0, 4),
    HEADER_X12_I(0, 5),
    HEADER_X12_S(0, 6),
    INTERCHANGE_CANDIDATE(0),
    HEADER_DATA(0),
    HEADER_SEGMENT_BEGIN(0),
    HEADER_INVALID_DATA(0),
    HEADER_COMPONENT_END(0),
    HEADER_ELEMENT_END(0),
    HEADER_SEGMENT_END(0),
    HEADER_RELEASE(1),
    TAG_SEARCH(10),
    SEGMENT_END(10),
    SEGMENT_EMPTY(10),
    TAG_1(2),
    TAG_2(3),
    TAG_3(4),
    SEGMENT_BEGIN(5),
    ELEMENT_DATA(5),
    ELEMENT_INVALID_DATA(5),
    COMPONENT_END(5),
    ELEMENT_REPEAT(5),
    ELEMENT_END(5),
    DATA_RELEASE(6),
    ELEMENT_DATA_BINARY(7),
    ELEMENT_END_BINARY(8),
    TRAILER_BEGIN(9),
    TRAILER_ELEMENT_DATA(9),
    TRAILER_ELEMENT_END(9),
    TRAILER_EDIFACT_U(11),
    TRAILER_EDIFACT_N(12),
    TRAILER_EDIFACT_Z(13),
    HEADER_EDIFACT_UNB_SEARCH(14),
    HEADER_EDIFACT_UNB_1(15),
    HEADER_EDIFACT_UNB_2(16),
    HEADER_EDIFACT_UNB_3(17),
    TRAILER_TRADACOMS_E(11),
    TRAILER_TRADACOMS_N(12),
    TRAILER_TRADACOMS_D(13),
    TRAILER_X12_I(11),
    TRAILER_X12_E(12),
    TRAILER_X12_A(13);

    private static final State __;
    private static final State II;
    private static final State X1;
    private static final State X2;
    private static final State X7;
    private static final State X8;
    private static final State X9;
    private static final State U1;
    private static final State U2;
    private static final State U7;
    private static final State U8;
    private static final State U9;
    private static final State C1;
    private static final State C2;
    private static final State C7;
    private static final State C8;
    private static final State C9;
    private static final State IC;
    private static final State HD;
    private static final State HR;
    private static final State HV;
    private static final State HC;
    private static final State HE;
    private static final State HZ;
    private static final State B0;
    private static final State B1;
    private static final State B2;
    private static final State B3;
    private static final State BB;
    private static final State TS;
    private static final State T1;
    private static final State T2;
    private static final State T3;
    private static final State SB;
    private static final State DR;
    private static final State ED;
    private static final State EI;
    private static final State CE;
    private static final State ER;
    private static final State EE;
    private static final State SE;
    private static final State SY;
    private static final State TB;
    private static final State TD;
    private static final State TE;
    private static final State IE;
    private static final State BD;
    private static final State[] FROM_INITIAL;
    private static final State[] FROM_EDIFACT_1;
    private static final State[] FROM_EDIFACT_2;
    private static final State[] FROM_TRADACOMS_1;
    private static final State[] FROM_TRADACOMS_2;
    private static final State[] FROM_X12_1;
    private static final State[] FROM_X12_2;
    private static final State[] FROM_HEADER;
    private static final State[] FROM_HEADER_RELEASE;
    private static final State[] FROM_TAG_1;
    private static final State[] FROM_TAG_2;
    private static final State[] FROM_TAG_3;
    private static final State[] FROM_ED;
    private static final State[] FROM_DR;
    private static final State[] FROM_BD;
    private static final State[] FROM_BE;
    private static final State[] FROM_TRAILER;
    private static final State[] FROM_TS_EDIFACT;
    private static final State[] FROM_EDIFACT_7;
    private static final State[] FROM_EDIFACT_8;
    private static final State[] FROM_EDIFACT_9;
    private static final State[] FROM_EDIFACT_UNB_0;
    private static final State[] FROM_EDIFACT_UNB_1;
    private static final State[] FROM_EDIFACT_UNB_2;
    private static final State[] FROM_EDIFACT_UNB_3;
    private static final State[] FROM_TS_TRADACOMS;
    private static final State[] FROM_TRADACOMS_7;
    private static final State[] FROM_TRADACOMS_8;
    private static final State[] FROM_TRADACOMS_9;
    private static final State[] FROM_TAG_2_TRADACOMS;
    private static final State[] FROM_TAG_3_TRADACOMS;
    private static final State[] FROM_TS_X12;
    private static final State[] FROM_X12_7;
    private static final State[] FROM_X12_8;
    private static final State[] FROM_X12_9;
    private static final State[][] TRANSITION_INITIAL;
    private static final State[][] TRANSITION_EDIFACT;
    private static final State[][] TRANSITION_TRADACOMS;
    private static final State[][] TRANSITION_X12;
    private static final State[][][] TRANSITIONS;
    private final int table;
    private final int code;

    private State(int table, int code) {
        this.table = table;
        this.code = code;
    }

    private State(int code) {
        this(-1, code);
    }

    public static State transition(State state, Dialect dialect, CharacterClass clazz) {
        if (state.table != -1) {
            return state.transition(state.table, clazz);
        }
        Objects.requireNonNull(dialect, "dialect was unexpectedly null");
        return state.transition(dialect.getDialectStateCode(), clazz);
    }

    public State transition(int dialect, CharacterClass clazz) {
        return TRANSITIONS[dialect][this.code][clazz.code];
    }

    public boolean isHeaderState() {
        return 0 == this.code && 0 != this.table;
    }

    static {
        __ = INVALID;
        II = INITIAL;
        X1 = HEADER_X12_I;
        X2 = HEADER_X12_S;
        X7 = TRAILER_X12_I;
        X8 = TRAILER_X12_E;
        X9 = TRAILER_X12_A;
        U1 = HEADER_EDIFACT_U;
        U2 = HEADER_EDIFACT_N;
        U7 = TRAILER_EDIFACT_U;
        U8 = TRAILER_EDIFACT_N;
        U9 = TRAILER_EDIFACT_Z;
        C1 = HEADER_TRADACOMS_S;
        C2 = HEADER_TRADACOMS_T;
        C7 = TRAILER_TRADACOMS_E;
        C8 = TRAILER_TRADACOMS_N;
        C9 = TRAILER_TRADACOMS_D;
        IC = INTERCHANGE_CANDIDATE;
        HD = HEADER_DATA;
        HR = HEADER_RELEASE;
        HV = HEADER_INVALID_DATA;
        HC = HEADER_COMPONENT_END;
        HE = HEADER_ELEMENT_END;
        HZ = HEADER_SEGMENT_END;
        B0 = HEADER_EDIFACT_UNB_SEARCH;
        B1 = HEADER_EDIFACT_UNB_1;
        B2 = HEADER_EDIFACT_UNB_2;
        B3 = HEADER_EDIFACT_UNB_3;
        BB = HEADER_SEGMENT_BEGIN;
        TS = TAG_SEARCH;
        T1 = TAG_1;
        T2 = TAG_2;
        T3 = TAG_3;
        SB = SEGMENT_BEGIN;
        DR = DATA_RELEASE;
        ED = ELEMENT_DATA;
        EI = ELEMENT_INVALID_DATA;
        CE = COMPONENT_END;
        ER = ELEMENT_REPEAT;
        EE = ELEMENT_END;
        SE = SEGMENT_END;
        SY = SEGMENT_EMPTY;
        TB = TRAILER_BEGIN;
        TD = TRAILER_ELEMENT_DATA;
        TE = TRAILER_ELEMENT_END;
        IE = INTERCHANGE_END;
        BD = ELEMENT_DATA_BINARY;
        FROM_INITIAL = new State[]{II, __, __, __, __, X1, __, C1, __, U1, __, __, __, __, __, __, __, __, II, II, __, __, __};
        FROM_EDIFACT_1 = new State[]{__, __, __, __, __, __, U2, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __};
        FROM_EDIFACT_2 = new State[]{__, IC, IC, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __};
        FROM_TRADACOMS_1 = new State[]{__, __, __, __, __, __, __, __, C2, __, __, __, __, __, __, __, __, __, __, __, __, __, __};
        FROM_TRADACOMS_2 = new State[]{__, __, __, __, __, __, __, __, __, __, IC, __, __, __, __, __, __, __, __, __, __, __, __};
        FROM_X12_1 = new State[]{__, __, __, __, __, __, __, X2, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __};
        FROM_X12_2 = new State[]{__, IC, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __};
        FROM_HEADER = new State[]{HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HZ, HE, HC, __, HR, HD, HD, HD, HV, HE};
        FROM_HEADER_RELEASE = new State[]{HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HD, HV, HV, HD, HV, HD};
        FROM_TAG_1 = new State[]{__, T2, T2, T2, T2, T2, T2, T2, T2, T2, T2, T2, T2, __, __, __, __, __, __, __, __, __, __};
        FROM_TAG_2 = new State[]{__, T3, T3, T3, T3, T3, T3, T3, T3, T3, T3, T3, T3, SY, SB, __, __, __, __, __, __, __, __};
        FROM_TAG_3 = new State[]{__, __, __, __, __, __, __, __, __, __, __, __, __, SY, SB, __, __, __, __, __, __, __, __};
        FROM_ED = new State[]{ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, SE, EE, CE, ER, DR, EI, EI, ED, EI, __};
        FROM_DR = new State[]{ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, ED, EI, EI, ED, EI, ED};
        FROM_BD = new State[]{BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD, BD};
        FROM_BE = new State[]{__, __, __, __, __, __, __, __, __, __, __, __, __, SE, EE, __, __, __, __, __, __, __, __};
        FROM_TRAILER = new State[]{TD, TD, TD, TD, TD, TD, TD, TD, TD, TD, TD, TD, TD, IE, TE, __, __, __, __, __, TD, __, __};
        FROM_TS_EDIFACT = new State[]{TS, T1, T1, T1, T1, T1, T1, T1, T1, U7, T1, T1, T1, __, __, __, __, __, TS, __, __, __, __};
        FROM_EDIFACT_7 = new State[]{__, T2, T2, T2, T2, T2, U8, T2, T2, T2, T2, T2, T2, __, __, __, __, __, __, __, __, __, __};
        FROM_EDIFACT_8 = new State[]{__, T3, T3, T3, T3, T3, T3, T3, T3, T3, T3, U9, T3, __, SB, __, __, __, __, __, __, __, __};
        FROM_EDIFACT_9 = new State[]{__, __, __, __, __, __, __, __, __, __, __, __, __, __, TB, __, __, __, __, __, __, __, __};
        FROM_EDIFACT_UNB_0 = new State[]{B0, __, __, __, __, __, __, __, B1, B1, __, __, __, __, __, __, __, __, B0, __, __, __, __};
        FROM_EDIFACT_UNB_1 = new State[]{__, __, __, __, __, __, B2, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __};
        FROM_EDIFACT_UNB_2 = new State[]{__, __, B3, __, __, __, __, __, __, __, __, __, __, __, BB, __, __, __, __, __, __, __, __};
        FROM_EDIFACT_UNB_3 = new State[]{__, __, __, __, __, __, __, __, __, __, __, __, __, __, BB, __, __, __, __, __, __, __, __};
        FROM_TS_TRADACOMS = new State[]{TS, T1, T1, T1, C7, T1, T1, T1, T1, T1, T1, T1, T1, __, __, __, __, __, TS, __, __, __, __};
        FROM_TRADACOMS_7 = new State[]{__, T2, T2, T2, T2, T2, C8, T2, T2, T2, T2, T2, T2, __, __, __, __, __, __, __, __, __, __};
        FROM_TRADACOMS_8 = new State[]{__, T3, T3, C9, T3, T3, T3, T3, T3, T3, T3, T3, T3, __, __, __, __, __, __, __, __, __, SB};
        FROM_TRADACOMS_9 = new State[]{__, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, __, TB};
        FROM_TAG_2_TRADACOMS = new State[]{__, T3, T3, T3, T3, T3, T3, T3, T3, T3, T3, T3, T3, SY, __, __, __, __, __, __, __, __, SB};
        FROM_TAG_3_TRADACOMS = new State[]{__, __, __, __, __, __, __, __, __, __, __, __, __, SY, __, __, __, __, __, __, __, __, SB};
        FROM_TS_X12 = new State[]{TS, T1, T1, T1, T1, X7, T1, T1, T1, T1, T1, T1, T1, __, __, __, __, __, TS, __, __, __, __};
        FROM_X12_7 = new State[]{__, T2, T2, T2, X8, T2, T2, T2, T2, T2, T2, T2, T2, __, __, __, __, __, __, __, __, __, __};
        FROM_X12_8 = new State[]{__, X9, T3, T3, T3, T3, T3, T3, T3, T3, T3, T3, T3, __, SB, __, __, __, __, __, __, __, __};
        FROM_X12_9 = new State[]{__, __, __, __, __, __, __, __, __, __, __, __, __, __, TB, __, __, __, __, __, __, __, __};
        TRANSITION_INITIAL = new State[][]{FROM_INITIAL, FROM_EDIFACT_1, FROM_EDIFACT_2, FROM_TRADACOMS_1, FROM_TRADACOMS_2, FROM_X12_1, FROM_X12_2};
        TRANSITION_EDIFACT = new State[][]{FROM_HEADER, FROM_HEADER_RELEASE, FROM_TAG_1, FROM_TAG_2, FROM_TAG_3, FROM_ED, FROM_DR, FROM_BD, FROM_BE, FROM_TRAILER, FROM_TS_EDIFACT, FROM_EDIFACT_7, FROM_EDIFACT_8, FROM_EDIFACT_9, FROM_EDIFACT_UNB_0, FROM_EDIFACT_UNB_1, FROM_EDIFACT_UNB_2, FROM_EDIFACT_UNB_3};
        TRANSITION_TRADACOMS = new State[][]{FROM_HEADER, FROM_HEADER_RELEASE, FROM_TAG_1, FROM_TAG_2_TRADACOMS, FROM_TAG_3_TRADACOMS, FROM_ED, FROM_DR, FROM_BD, FROM_BE, FROM_TRAILER, FROM_TS_TRADACOMS, FROM_TRADACOMS_7, FROM_TRADACOMS_8, FROM_TRADACOMS_9};
        TRANSITION_X12 = new State[][]{FROM_HEADER, FROM_HEADER_RELEASE, FROM_TAG_1, FROM_TAG_2, FROM_TAG_3, FROM_ED, FROM_DR, FROM_BD, FROM_BE, FROM_TRAILER, FROM_TS_X12, FROM_X12_7, FROM_X12_8, FROM_X12_9};
        TRANSITIONS = new State[][][]{TRANSITION_INITIAL, TRANSITION_EDIFACT, TRANSITION_TRADACOMS, TRANSITION_X12};
    }

    private static final class Category {
        static final int INVALID = -1;
        static final int INITIAL = 0;
        static final int EDIFACT_1 = 1;
        static final int EDIFACT_2 = 2;
        static final int TRADACOMS_1 = 3;
        static final int TRADACOMS_2 = 4;
        static final int X12_1 = 5;
        static final int X12_2 = 6;
        static final int HEADER = 0;
        static final int HEADER_RELEASE = 1;
        static final int TAG_1 = 2;
        static final int TAG_2 = 3;
        static final int TAG_3 = 4;
        static final int ELEMENT_PROCESS = 5;
        static final int DATA_RELEASE = 6;
        static final int DATA_BINARY = 7;
        static final int DATA_BINARY_END = 8;
        static final int TRAILER = 9;
        static final int TAG_SEARCH = 10;
        static final int TERM_7 = 11;
        static final int TERM_8 = 12;
        static final int TERM_9 = 13;
        static final int EDIFACT_UNB_0 = 14;
        static final int EDIFACT_UNB_1 = 15;
        static final int EDIFACT_UNB_2 = 16;
        static final int EDIFACT_UNB_3 = 17;

        private Category() {
        }
    }

    public static final class DialectCode {
        public static final int UNKNOWN = 0;
        public static final int EDIFACT = 1;
        public static final int TRADACOMS = 2;
        public static final int X12 = 3;

        private DialectCode() {
        }
    }
}

