/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.avh4.util.imagecomparison.ImageComparison;
import net.avh4.util.imagecomparison.ImageComparisonResult;

public class LooksLikeHelper {
    private final String filename;
    private final BufferedImage referenceImage;
    private final Class<?> sourceClass;
    private boolean matches;
    private StringBuffer mismatchDescription;

    public LooksLikeHelper(String resourceName, Class<?> callingClass) throws IOException {
        this.sourceClass = callingClass;
        this.filename = resourceName;
        URL resource = this.sourceClass.getResource(this.filename);
        this.referenceImage = resource == null ? null : ImageIO.read(resource);
    }

    public boolean matches() {
        return this.matches;
    }

    public String mismatchDescription() {
        return this.mismatchDescription.toString();
    }

    public void checkAndWriteFailingImage(Object item) {
        ImageComparisonResult result = ImageComparison.compare(item, this.referenceImage);
        this.mismatchDescription = new StringBuffer();
        this.matches = false;
        if (result.isEqual()) {
            this.matches = true;
        } else if (this.referenceImage == null) {
            this.mismatchDescription.append("approval image ");
            this.mismatchDescription.append(this.filename);
            this.mismatchDescription.append(" doesn't exist -- expected to find it in ");
            this.mismatchDescription.append(this.sourceClass.getPackage().getName());
            result.writeActualImageToFile(this.filename);
        } else {
            this.mismatchDescription.append("images don't match: ");
            this.mismatchDescription.append(result.getFailureMessage());
            result.writeActualImageToFile(this.filename);
        }
    }

    public String selfDescription() {
        if (this.referenceImage == null) {
            return String.format("reference image \"%s\" to exist in %s", this.filename, this.sourceClass.getPackage().getName());
        }
        return String.format("something that looks like %s (%dx%d)", this.filename, this.referenceImage.getWidth(), this.referenceImage.getHeight());
    }
}

