/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison;

import java.awt.image.BufferedImage;
import net.avh4.util.imagecomparison.ImageComparisonResult;

public class PixelMismatchResult
extends ImageComparisonResult {
    private final int firstMismatchX;
    private final int firstMismatchY;
    private final int actualPixel;
    private final int expectedPixel;

    public PixelMismatchResult(BufferedImage itemImage, int firstMismatchX, int firstMismatchY, int actualPixel, int expectedPixel) {
        super(itemImage);
        this.firstMismatchX = firstMismatchX;
        this.firstMismatchY = firstMismatchY;
        this.actualPixel = actualPixel;
        this.expectedPixel = expectedPixel;
    }

    @Override
    public boolean isEqual() {
        return false;
    }

    @Override
    public String getFailureMessage() {
        return String.format("First incorrect pixel was (%d, %d): expected 0x%x, but got 0x%x", this.firstMismatchX, this.firstMismatchY, this.expectedPixel, this.actualPixel);
    }

    public String toString() {
        return "PixelMismatchResult{actualImage=" + this.actualImage + ", firstMismatchX=" + this.firstMismatchX + ", firstMismatchY=" + this.firstMismatchY + ", actualPixel=" + this.actualPixel + ", expectedPixel=" + this.expectedPixel + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelMismatchResult that = (PixelMismatchResult)o;
        if (this.actualPixel != that.actualPixel) {
            return false;
        }
        if (this.expectedPixel != that.expectedPixel) {
            return false;
        }
        if (this.firstMismatchX != that.firstMismatchX) {
            return false;
        }
        if (this.firstMismatchY != that.firstMismatchY) {
            return false;
        }
        return !(this.actualImage != null ? !this.actualImage.equals(that.actualImage) : that.actualImage != null);
    }

    public int hashCode() {
        int result = this.actualImage != null ? this.actualImage.hashCode() : 0;
        result = 31 * result + this.firstMismatchX;
        result = 31 * result + this.firstMismatchY;
        result = 31 * result + this.actualPixel;
        result = 31 * result + this.expectedPixel;
        return result;
    }
}

