/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ThrowingSupplier;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.JDBCComponent;
import net.openhft.chronicle.queue.JDBCResult;
import net.openhft.chronicle.queue.JDBCStatement;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.MethodReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCService
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCService.class);
    private final ChronicleQueue in;
    private final ChronicleQueue out;
    private final ThrowingSupplier<Connection, SQLException> connectionSupplier;
    private volatile boolean closed = false;

    public JDBCService(ChronicleQueue in, ChronicleQueue out, ThrowingSupplier<Connection, SQLException> connectionSupplier) {
        this.in = in;
        this.out = out;
        this.connectionSupplier = connectionSupplier;
        ExecutorService service = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(in.file().getName() + "-JDBCService", Boolean.valueOf(true)));
        service.execute(this::runLoop);
        service.shutdown();
    }

    void runLoop() {
        try {
            JDBCResult result = (JDBCResult)this.out.acquireAppender().methodWriterBuilder(JDBCResult.class).recordHistory(true).get();
            JDBCComponent js = new JDBCComponent(this.connectionSupplier, result);
            MethodReader reader = this.in.createTailer().afterLastWritten(this.out).methodReader(new Object[]{js});
            Pauser pauser = Pauser.millis((int)1, (int)10);
            while (!this.closed) {
                if (reader.readOne()) {
                    pauser.reset();
                    continue;
                }
                pauser.pause();
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Run loop exited", t);
        }
    }

    public void close() {
        this.closed = true;
    }

    public JDBCStatement createWriter() {
        return (JDBCStatement)this.in.acquireAppender().methodWriterBuilder(JDBCStatement.class).recordHistory(true).get();
    }

    public MethodReader createReader(JDBCResult result) {
        return this.out.createTailer().methodReader(new Object[]{result});
    }
}

