/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverContext;
import net.thucydides.core.webdriver.WebdriverInstances;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public class SerenityWebdriverManager
implements WebdriverManager {
    private static final ThreadLocal<WebdriverInstances> webdriverInstancesThreadLocal = new ThreadLocal();
    private final WebDriverFactory webDriverFactory;
    private final DriverConfiguration<DriverConfiguration> configuration;
    private final String options;
    private String overridenDefaultDriverType = null;

    public SerenityWebdriverManager(WebDriverFactory webDriverFactory, DriverConfiguration configuration) {
        this(webDriverFactory, configuration, "");
    }

    public SerenityWebdriverManager(WebDriverFactory webDriverFactory, DriverConfiguration configuration, String options) {
        this.webDriverFactory = webDriverFactory;
        this.configuration = configuration;
        this.options = options;
    }

    private static WebDriver newDriver(DriverConfiguration configuration, WebDriverFactory webDriverFactory, String driver, String options) {
        SupportedWebDriver supportedDriverType = SerenityWebdriverManager.getConfiguredWebDriverWithOverride(configuration, driver);
        Class<? extends WebDriver> webDriverType = webDriverFactory.getClassFor(supportedDriverType);
        return WebdriverProxyFactory.getFactory().proxyFor(webDriverType, webDriverFactory, configuration, options);
    }

    private static SupportedWebDriver getConfiguredWebDriverWithOverride(DriverConfiguration configuration, String driver) {
        if (StringUtils.isEmpty((CharSequence)driver)) {
            return configuration.getDriverType();
        }
        return SupportedWebDriver.getDriverTypeFor(driver);
    }

    @Override
    public void closeDriver() {
        SerenityWebdriverManager.inThisTestThread().closeCurrentDriver();
    }

    @Override
    public void closeCurrentDrivers() {
        SerenityWebdriverManager.inThisTestThread().closeCurrentDrivers();
    }

    @Override
    public void closeAllDrivers() {
        SerenityWebdriverManager.inThisTestThread().closeAllDrivers();
    }

    @Override
    public void reset() {
        SerenityWebdriverManager.inThisTestThread().closeAllDrivers();
    }

    @Override
    public WebdriverManager withOptions(String driverOptions) {
        return new SerenityWebdriverManager(this.webDriverFactory, this.configuration, driverOptions);
    }

    @Override
    public void overrideProperties(Map<String, String> propertyValues) {
        this.configuration.getEnvironmentVariables().setProperties(propertyValues);
    }

    @Override
    public WebdriverManager withProperty(String property, String value) {
        EnvironmentVariables updatedEnvironmentVariables = this.configuration.getEnvironmentVariables().copy();
        updatedEnvironmentVariables.setProperty(property, value);
        return new SerenityWebdriverManager(this.webDriverFactory, (DriverConfiguration)this.configuration.withEnvironmentVariables(updatedEnvironmentVariables), this.options);
    }

    @Override
    public void resetDriver() {
        SerenityWebdriverManager.inThisTestThread().resetCurrentDriver();
    }

    @Override
    public WebDriver getWebdriver() {
        String currentDriverName = StringUtils.isNotEmpty((CharSequence)SerenityWebdriverManager.inThisTestThread().getCurrentDriverName()) ? SerenityWebdriverManager.inThisTestThread().getCurrentDriverName() : this.getDefaultDriverType();
        return SerenityWebdriverManager.instantiatedThreadLocalWebDriver(this.configuration, this.webDriverFactory, currentDriverName, this.options);
    }

    @Override
    public WebdriverContext inContext(String context) {
        return new WebdriverContext(this, context);
    }

    @Override
    public void setCurrentDriver(WebDriver driver) {
        SerenityWebdriverManager.inThisTestThread().setCurrentDriverTo(driver);
    }

    @Override
    public void clearCurrentDriver() {
        SerenityWebdriverManager.inThisTestThread().resetCurrentDriver();
    }

    public static void resetThisThread() {
        webdriverInstancesThreadLocal.remove();
    }

    @Override
    public void registerDriver(WebDriver driver) {
        if (driver != null) {
            SerenityWebdriverManager.inThisTestThread().registerDriverCalled(this.nameOf(driver)).forDriver(driver);
            SerenityWebdriverManager.inThisTestThread().setCurrentDriverTo(driver);
        }
    }

    private String nameOf(WebDriver driver) {
        if (driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)driver).getDriverName();
        }
        if (driver instanceof RemoteWebDriver && ((RemoteWebDriver)driver).getCapabilities() != null) {
            return ((RemoteWebDriver)driver).getCapabilities().getBrowserName();
        }
        return driver.toString();
    }

    @Override
    public List<WebDriver> getRegisteredDrivers() {
        return SerenityWebdriverManager.inThisTestThread().getActiveDrivers();
    }

    @Override
    public List<String> getActiveDriverTypes() {
        return SerenityWebdriverManager.inThisTestThread().getActiveDriverTypes();
    }

    @Override
    public String getCurrentDriverType() {
        return SerenityWebdriverManager.inThisTestThread().getCurrentDriverType();
    }

    @Override
    public String getDefaultDriverType() {
        return Optional.ofNullable(this.overridenDefaultDriverType).orElse(this.configuration.getDriverType().name());
    }

    @Override
    public void overrideDefaultDriverType(String driverType) {
        this.overridenDefaultDriverType = StringUtils.isEmpty((CharSequence)driverType) ? null : driverType;
    }

    @Override
    public SessionId getSessionId() {
        WebDriver driver = SerenityWebdriverManager.inThisTestThread().getCurrentDriver();
        if (driver instanceof WebDriverFacade && ((WebDriverFacade)driver).isInstantiated()) {
            WebDriver proxiedDriver = ((WebDriverFacade)driver).getDriverInstance();
            return this.sessionIdOf(proxiedDriver);
        }
        return this.sessionIdOf(driver);
    }

    private SessionId sessionIdOf(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            return ((RemoteWebDriver)driver).getSessionId();
        }
        return null;
    }

    public WebDriver getWebdriver(String driverName, String options) {
        String name = StringUtils.isEmpty((CharSequence)driverName) ? SerenityWebdriverManager.inThisTestThread().getCurrentDriverName() : driverName;
        return SerenityWebdriverManager.instantiatedThreadLocalWebDriver(this.configuration, this.webDriverFactory, name, options);
    }

    @Override
    public WebDriver getWebdriver(String driverName) {
        String defaultDriverOptions = ThucydidesWebDriverSupport.getDefaultDriverOptions().orElse("");
        String activeOptions = StringUtils.isEmpty((CharSequence)this.options) ? defaultDriverOptions : this.options;
        return this.getWebdriver(driverName, activeOptions);
    }

    @Override
    public WebDriver getCurrentDriver() {
        return SerenityWebdriverManager.inThisTestThread().getCurrentDriver();
    }

    @Override
    public WebDriver getWebdriverByName(String name, String driver) {
        return this.getWebdriver(driver + ":" + name);
    }

    @Override
    public WebDriver getWebdriverByName(String name) {
        return this.getWebdriverByName(name, this.configuration.getDriverType().name());
    }

    private static WebDriver instantiatedThreadLocalWebDriver(DriverConfiguration configuration, WebDriverFactory webDriverFactory, String driver, String options) {
        String uniqueDriverName = SerenityWebdriverManager.uniqueDriverNameFor(driver, options);
        if (!SerenityWebdriverManager.inThisTestThread().driverIsRegisteredFor(uniqueDriverName)) {
            SerenityWebdriverManager.inThisTestThread().registerDriverCalled(uniqueDriverName).forDriver(SerenityWebdriverManager.newDriver(configuration, webDriverFactory, SerenityWebdriverManager.driverTypeOf(driver), options));
        }
        return SerenityWebdriverManager.inThisTestThread().useDriver(uniqueDriverName);
    }

    private static String uniqueDriverNameFor(String driver, String options) {
        return driver + (StringUtils.isEmpty((CharSequence)options) ? "" : ":" + options);
    }

    private static String driverTypeOf(String driverName) {
        if (driverName.contains(":")) {
            return driverName.substring(0, driverName.indexOf(":"));
        }
        return driverName;
    }

    public static WebdriverInstances inThisTestThread() {
        if (webdriverInstancesThreadLocal.get() == null) {
            webdriverInstancesThreadLocal.set(new WebdriverInstances());
        }
        return webdriverInstancesThreadLocal.get();
    }

    @Override
    public int getCurrentActiveWebdriverCount() {
        return SerenityWebdriverManager.inThisTestThread().getActiveWebdriverCount();
    }

    @Override
    public int getActiveWebdriverCount() {
        return SerenityWebdriverManager.inThisTestThread().getActiveWebdriverCount();
    }

    @Override
    public boolean hasAnInstantiatedDriver() {
        return SerenityWebdriverManager.inThisTestThread().hasAnInstantiatedDriver();
    }
}

