/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.CacheStatistics;
import javax.cache.CacheWriter;
import javax.cache.InvalidConfigurationException;
import javax.cache.event.CacheEntryListener;
import javax.cache.mbeans.CacheMXBean;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CopyStrategyConfiguration;
import net.sf.ehcache.jcache.DelegatingJCacheMXBean;
import net.sf.ehcache.jcache.JCacheCacheLoaderAdapter;
import net.sf.ehcache.jcache.JCacheCacheWriterAdapter;
import net.sf.ehcache.jcache.JCacheConfiguration;
import net.sf.ehcache.jcache.JCacheCopyOnWriteStrategy;
import net.sf.ehcache.jcache.JCacheEhcacheDecorator;
import net.sf.ehcache.jcache.JCacheEntry;
import net.sf.ehcache.jcache.JCacheListenerAdapter;
import net.sf.ehcache.jcache.JCacheManager;
import net.sf.ehcache.jcache.JCacheStatistics;
import net.sf.ehcache.jcache.JCacheStatusAdapter;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCache<K, V>
implements javax.cache.Cache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(JCache.class);
    private static final int CACHE_LOADER_THREADS = 2;
    private static final int DEFAULT_EXECUTOR_TIMEOUT = 10;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);
    private final Set<JCacheListenerAdapter<K, ? extends V>> cacheEntryListeners = new CopyOnWriteArraySet<JCacheListenerAdapter<K, ? extends V>>();
    private Ehcache ehcache;
    private JCacheManager cacheManager;
    private JCacheCacheLoaderAdapter cacheLoaderAdapter;
    private JCacheCacheWriterAdapter cacheWriterAdapter;
    private ClassLoader classLoader;
    private CacheMXBean mbean;
    private JCacheConfiguration configuration;

    public JCache(Ehcache ehcache, JCacheManager cacheManager, ClassLoader classLoader) {
        this.cacheManager = cacheManager;
        this.ehcache = ehcache;
        this.classLoader = classLoader;
        this.configuration = new JCacheConfiguration(ehcache.getCacheConfiguration());
        this.mbean = new DelegatingJCacheMXBean(this);
    }

    public Ehcache getEhcache() {
        return this.ehcache;
    }

    private void checkStatusStarted() {
        if (!JCacheStatusAdapter.adaptStatus(this.ehcache.getStatus()).equals((Object)javax.cache.Status.STARTED)) {
            throw new IllegalStateException("The cache status is not STARTED");
        }
    }

    public V get(K key) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        Element cacheElement = this.ehcache.get(key);
        if (cacheElement == null) {
            if (this.cacheLoaderAdapter != null) {
                return this.getFromLoader(key);
            }
            return null;
        }
        return (V)cacheElement.getValue();
    }

    private V getFromLoader(K key) {
        Cache.Entry entry = (Cache.Entry)this.cacheLoaderAdapter.load(key);
        if (entry != null) {
            this.ehcache.put(new Element(entry.getKey(), entry.getValue()));
            return (V)entry.getValue();
        }
        return null;
    }

    public Map<K, V> getAll(Set<? extends K> keys) throws CacheException {
        this.checkStatusStarted();
        if (keys == null || keys.contains(null)) {
            throw new NullPointerException("key cannot be null");
        }
        HashMap<K, V> map = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = this.get(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public boolean containsKey(K key) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        return this.ehcache.isKeyInCache(key);
    }

    public Future<V> load(K key) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        if (this.ehcache.getRegisteredCacheLoaders().size() == 0) {
            return null;
        }
        FutureTask task = new FutureTask(new JCacheLoaderCallable(this, key));
        this.executorService.submit(task);
        return task;
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
    }

    private void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
    }

    public Future<Map<K, ? extends V>> loadAll(Set<? extends K> keys) throws CacheException {
        this.checkStatusStarted();
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.contains(null)) {
            throw new NullPointerException("key");
        }
        if (this.cacheLoaderAdapter == null) {
            return null;
        }
        FutureTask<Map<K, ? extends V>> task = new FutureTask<Map<K, ? extends V>>(new JCacheLoaderLoadAllCallable(this, this.cacheLoaderAdapter.getJCacheCacheLoader(), keys));
        this.executorService.submit(task);
        return task;
    }

    public CacheStatistics getStatistics() {
        this.checkStatusStarted();
        if (!this.configuration.isStatisticsEnabled()) {
            return null;
        }
        return new JCacheStatistics(this, this.ehcache.getLiveCacheStatistics());
    }

    public void put(K key, V value) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        this.checkValue(value);
        this.ehcache.put(new Element(key, value));
    }

    public V getAndPut(K key, V value) throws CacheException, NullPointerException, IllegalStateException {
        this.checkStatusStarted();
        if (key == null || value == null) {
            throw new NullPointerException("Key cannot be null");
        }
        try {
            Element old = this.ehcache.get(key);
            this.put(key, value);
            return (V)(old != null ? old.getValue() : null);
        }
        catch (Exception e) {
            throw new CacheException("Unable to getAndPut.", (Throwable)e);
        }
    }

    public void putAll(Map<? extends K, ? extends V> map) throws CacheException {
        this.checkStatusStarted();
        if (map == null || map.containsKey(null)) {
            throw new NullPointerException("Map of keys cannot be null, and no key in map can be null");
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean putIfAbsent(K key, V value) throws CacheException {
        this.checkStatusStarted();
        boolean present = this.containsKey(key);
        if (present) {
            return false;
        }
        this.put(key, value);
        return this.containsKey(key);
    }

    public boolean remove(K key) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        return this.ehcache.remove(key);
    }

    public boolean remove(K key, V oldValue) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        this.checkValue(oldValue);
        if (this.containsKey(key) && this.get(key).equals(oldValue)) {
            return this.remove(key);
        }
        return false;
    }

    public V getAndRemove(K key) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        if (this.containsKey(key)) {
            V oldValue = this.get(key);
            this.remove(key);
            return oldValue;
        }
        return null;
    }

    public boolean replace(K key, V oldValue, V newValue) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        Element e = this.ehcache.get(key);
        if (e != null && e.getValue().equals(oldValue)) {
            this.ehcache.put(new Element(key, newValue));
            return true;
        }
        return false;
    }

    public boolean replace(K key, V value) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        this.checkValue(value);
        return this.ehcache.replace(new Element(key, value)) != null;
    }

    public V getAndReplace(K key, V value) throws CacheException {
        this.checkStatusStarted();
        this.checkKey(key);
        this.checkValue(value);
        Element replaced = this.ehcache.replace(new Element(key, value));
        return (V)(replaced != null ? replaced.getValue() : null);
    }

    public void removeAll(Set<? extends K> keys) throws CacheException {
        this.checkStatusStarted();
        for (K key : keys) {
            this.remove(key);
        }
    }

    public void removeAll() throws CacheException {
        this.checkStatusStarted();
        this.ehcache.removeAll();
    }

    public JCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean registerCacheEntryListener(CacheEntryListener<? super K, ? super V> cacheEntryListener) {
        this.checkValue(cacheEntryListener);
        JCacheListenerAdapter<? super K, ? super V> listener = new JCacheListenerAdapter<K, V>(cacheEntryListener);
        this.ehcache.getCacheEventNotificationService().registerListener(listener);
        return this.cacheEntryListeners.add(listener);
    }

    public boolean unregisterCacheEntryListener(CacheEntryListener<?, ?> cacheEntryListener) {
        if (cacheEntryListener == null) {
            return false;
        }
        JCacheListenerAdapter listenerAdapter = new JCacheListenerAdapter(cacheEntryListener);
        this.ehcache.getCacheEventNotificationService().unregisterListener(listenerAdapter);
        return this.cacheEntryListeners.remove(listenerAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeEntryProcessor(K key, Cache.EntryProcessor<K, V> kvEntryProcessor) {
        this.checkStatusStarted();
        if (key == null) {
            throw new NullPointerException();
        }
        if (kvEntryProcessor == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        Object result = null;
        try {
            JCacheMutableEntry entry = new JCacheMutableEntry(key, this.ehcache);
            result = kvEntryProcessor.process(entry);
            entry.commit();
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
        return result;
    }

    public String getName() {
        return this.ehcache.getName();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public <T> T unwrap(Class<T> cls) {
        if (this.getClass().isAssignableFrom(cls)) {
            return (T)this;
        }
        if (cls.isAssignableFrom(Ehcache.class)) {
            return (T)this.ehcache;
        }
        throw new IllegalArgumentException("Can't cast the the specified class");
    }

    public void start() throws CacheException {
    }

    public void stop() throws CacheException {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
        if (this.ehcache.getStatus().equals(Status.STATUS_ALIVE)) {
            this.ehcache.dispose();
        }
    }

    public javax.cache.Status getStatus() {
        return JCacheStatusAdapter.adaptStatus(this.ehcache.getStatus());
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkStatusStarted();
        return new EhcacheIterator(this.ehcache.getKeys().iterator());
    }

    public CacheMXBean getMBean() {
        return this.mbean;
    }

    protected JCacheCacheLoaderAdapter<K, V> getCacheLoaderAdapter() {
        return this.cacheLoaderAdapter;
    }

    protected JCacheCacheWriterAdapter<K, V> getCacheWriterAdapter() {
        return this.cacheWriterAdapter;
    }

    public static class JCacheMutableEntry<K, V>
    implements Cache.MutableEntry<K, V> {
        private Ehcache store;
        private final K key;
        private V value;
        private boolean exists;
        private boolean remove;

        public JCacheMutableEntry(K key, Ehcache store) {
            this.store = store;
            this.key = key;
            this.exists = store.isKeyInCache(key);
        }

        private void commit() {
            if (this.remove) {
                this.store.remove(this.key);
            } else if (this.value != null) {
                this.store.put(new Element(this.key, this.value));
            }
        }

        public boolean exists() {
            return this.exists;
        }

        public void remove() {
            this.remove = true;
            this.exists = false;
            this.value = null;
        }

        public void setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.exists = true;
            this.remove = false;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return (V)(this.value != null ? this.value : this.store.get(this.key).getValue());
        }
    }

    public static class Builder<K, V>
    implements CacheBuilder<K, V> {
        private String cacheName;
        private ClassLoader classLoader;
        private JCacheConfiguration cacheConfiguration;
        private javax.cache.CacheLoader<K, ? extends V> cacheLoader;
        private CacheWriter<? super K, ? super V> cacheWriter;
        private final CopyOnWriteArraySet<CacheEntryListener<K, V>> listeners = new CopyOnWriteArraySet();
        private final JCacheConfiguration.Builder configurationBuilder = new JCacheConfiguration.Builder();
        private JCacheManager cacheManager;

        public Builder(String cacheName, JCacheManager cacheManager, ClassLoader classLoader) {
            this.cacheName = cacheName;
            this.cacheManager = cacheManager;
            this.classLoader = classLoader;
        }

        public JCache<K, V> build() {
            if (this.cacheName == null) {
                throw new InvalidConfigurationException("cache name can't be null");
            }
            this.cacheConfiguration = this.configurationBuilder.build();
            if (this.cacheConfiguration.isReadThrough() && this.cacheLoader == null) {
                throw new InvalidConfigurationException("cacheLoader can't be null on a readThrough cache");
            }
            if (this.cacheConfiguration.isWriteThrough() && this.cacheWriter == null) {
                throw new InvalidConfigurationException("cacheWriter can't be null on a writeThrough cache");
            }
            this.cacheConfiguration.getCacheConfiguration().setName(this.cacheName);
            if (this.cacheConfiguration.isStoreByValue()) {
                this.cacheConfiguration.getCacheConfiguration().setCopyOnWrite(true);
                this.cacheConfiguration.getCacheConfiguration().setCopyOnRead(true);
                CopyStrategyConfiguration copyStrategyConfiguration = this.cacheConfiguration.getCacheConfiguration().getCopyStrategyConfiguration();
                copyStrategyConfiguration.setCopyStrategyInstance((ReadWriteCopyStrategy)new JCacheCopyOnWriteStrategy(this.classLoader));
            }
            if (this.cacheManager.getEhcacheManager().getConfiguration().getMaxBytesLocalHeap() == 0L && this.cacheConfiguration.getCacheConfiguration().getMaxBytesLocalHeap() == 0L && this.cacheConfiguration.getCacheConfiguration().getMaxEntriesLocalHeap() == 0L) {
                LOG.warn("There is no maxBytesLocalHeap set for the cacheManager '{}'. ", (Object)this.cacheManager.getEhcacheManager().getName());
                LOG.warn("Ehcache requires either maxBytesLocalHeap be set at the cacheManager Level or requires maxEntriesLocalHeap or maxBytesLocalHeap to be set at the Cache level");
                LOG.warn("The default value of 10000 maxElementsLocalHeap is being used for now. To fix this in the future create an ehcache{}.xml file in the classpath that configures maxBytesLocalHeap", (Object)(this.cacheManager.getName() == "__default__" ? "" : "-" + this.cacheName));
                this.cacheConfiguration.getCacheConfiguration().maxEntriesLocalHeap(10000);
            }
            this.cacheConfiguration.getCacheConfiguration().setStatistics(this.cacheConfiguration.isStatisticsEnabled());
            this.cacheConfiguration.getCacheConfiguration().setDiskPersistent(false);
            Cache cache = new Cache(this.cacheConfiguration.getCacheConfiguration());
            JCache<K, V> jcache = new JCache<K, V>((Ehcache)cache, this.cacheManager, this.classLoader);
            ((JCache)jcache).configuration = this.cacheConfiguration;
            JCacheEhcacheDecorator decoratedCache = new JCacheEhcacheDecorator((Ehcache)cache, jcache);
            ((JCache)jcache).ehcache = decoratedCache;
            if (this.cacheLoader != null) {
                ((JCache)jcache).cacheLoaderAdapter = new JCacheCacheLoaderAdapter<K, V>(this.cacheLoader);
                ((JCache)jcache).ehcache.registerCacheLoader((CacheLoader)((JCache)jcache).cacheLoaderAdapter);
            }
            if (this.cacheWriter != null) {
                ((JCache)jcache).cacheWriterAdapter = new JCacheCacheWriterAdapter<K, V>(this.cacheWriter);
                ((JCache)jcache).ehcache.registerCacheWriter((net.sf.ehcache.writer.CacheWriter)((JCache)jcache).cacheWriterAdapter);
            }
            for (CacheEntryListener<K, V> listener : this.listeners) {
                jcache.registerCacheEntryListener(listener);
            }
            return jcache;
        }

        public Builder<K, V> setCacheLoader(javax.cache.CacheLoader<K, ? extends V> cacheLoader) {
            if (cacheLoader == null) {
                throw new NullPointerException("cacheLoader");
            }
            this.cacheLoader = cacheLoader;
            return this;
        }

        public CacheBuilder<K, V> setCacheWriter(CacheWriter<? super K, ? super V> cacheWriter) {
            if (cacheWriter == null) {
                throw new NullPointerException("cacheWriter");
            }
            this.cacheWriter = cacheWriter;
            return this;
        }

        public CacheBuilder<K, V> registerCacheEntryListener(CacheEntryListener<K, V> listener) {
            this.listeners.add(listener);
            return this;
        }

        public CacheBuilder<K, V> setStoreByValue(boolean storeByValue) {
            this.configurationBuilder.setStoreByValue(storeByValue);
            return this;
        }

        public CacheBuilder<K, V> setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
            if (IsolationLevel.NONE.equals((Object)isolationLevel)) {
                throw new IllegalArgumentException("The none isolation level is not permitted.");
            }
            if (Mode.NONE.equals((Object)mode)) {
                throw new IllegalArgumentException("The none Mode is not permitted.");
            }
            this.configurationBuilder.setTransactionEnabled(isolationLevel, mode);
            return this;
        }

        public CacheBuilder<K, V> setStatisticsEnabled(boolean enableStatistics) {
            this.configurationBuilder.setStatisticsEnabled(enableStatistics);
            return this;
        }

        public CacheBuilder<K, V> setReadThrough(boolean readThrough) {
            this.configurationBuilder.setReadThrough(readThrough);
            return this;
        }

        public CacheBuilder<K, V> setWriteThrough(boolean writeThrough) {
            this.configurationBuilder.setWriteThrough(writeThrough);
            return this;
        }

        public CacheBuilder<K, V> setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration timeToLive) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (timeToLive == null) {
                throw new NullPointerException();
            }
            this.configurationBuilder.setExpiry(type, timeToLive);
            return this;
        }
    }

    private static class JCacheLoaderLoadAllCallable<K, V>
    implements Callable<Map<K, ? extends V>> {
        private final JCache<K, V> cache;
        private final Collection<? extends K> keys;
        private final javax.cache.CacheLoader<K, ? extends V> cacheLoader;

        JCacheLoaderLoadAllCallable(JCache<K, V> cache, javax.cache.CacheLoader<K, V> cacheLoader, Collection<? extends K> keys) {
            this.cache = cache;
            this.keys = keys;
            this.cacheLoader = cacheLoader;
        }

        @Override
        public Map<K, ? extends V> call() throws Exception {
            ArrayList<K> keysNotInStore = new ArrayList<K>();
            for (K key : this.keys) {
                if (this.cache.containsKey(key)) continue;
                keysNotInStore.add(key);
            }
            Map value = this.cacheLoader.loadAll(keysNotInStore);
            this.cache.putAll(value);
            return value;
        }
    }

    private static class JCacheLoaderCallable<K, V>
    implements Callable<V> {
        private final JCache<K, V> cache;
        private final K key;

        JCacheLoaderCallable(JCache<K, V> cache, K key) {
            this.cache = cache;
            this.key = key;
        }

        @Override
        public V call() throws Exception {
            if (this.key == null) {
                throw new NullPointerException("Can't load null values");
            }
            Cache.Entry loadedEntry = this.cache.getCacheLoaderAdapter().getJCacheCacheLoader().load(this.key);
            Object loadedValue = loadedEntry.getValue();
            if (loadedValue == null) {
                throw new NullPointerException("Can't load null values");
            }
            this.cache.put(loadedEntry.getKey(), loadedEntry.getValue());
            return (V)loadedValue;
        }
    }

    private class EhcacheIterator
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator keyIterator;
        private K lastKey = null;

        public EhcacheIterator(Iterator keyIterator) {
            this.keyIterator = keyIterator;
        }

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext();
        }

        @Override
        public Cache.Entry<K, V> next() {
            Object key = this.keyIterator.next();
            if (key == null) {
                throw new NoSuchElementException();
            }
            this.lastKey = key;
            return new JCacheEntry(JCache.this.ehcache.get(key));
        }

        @Override
        public void remove() {
            if (this.lastKey == null) {
                throw new IllegalStateException();
            }
            JCache.this.ehcache.remove(this.lastKey);
            this.lastKey = null;
        }
    }
}

