/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.net.URL;
import javax.cache.implementation.AbstractCacheManagerFactory;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.jcache.JCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JCacheCacheManagerFactory
extends AbstractCacheManagerFactory {
    private static Logger LOG = LoggerFactory.getLogger(JCacheCacheManagerFactory.class);
    private static final JCacheCacheManagerFactory INSTANCE = new JCacheCacheManagerFactory();

    private JCacheCacheManagerFactory() {
    }

    protected javax.cache.CacheManager createCacheManager(ClassLoader classLoader, String name) {
        return new JCacheManager(name, this.configureEhCacheManager(name, classLoader), classLoader);
    }

    protected ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private CacheManager configureEhCacheManager(String name, ClassLoader classLoader) {
        Configuration config = this.getInitialConfigurationForCacheManager(name, classLoader);
        config.setName(name + classLoader.toString());
        LOG.debug("CacheName was set to {} used with classLoader {}", (Object)name, (Object)classLoader.toString());
        CacheManager cacheManager = CacheManager.newInstance((Configuration)config);
        return cacheManager;
    }

    private Configuration getInitialConfigurationForCacheManager(String name, ClassLoader classLoader) {
        String defaultName = "ehcache-" + name + ".xml";
        URL configResource = null;
        if (name != "__default__") {
            configResource = classLoader.getResource(defaultName);
        }
        Configuration configuration = configResource != null ? ConfigurationFactory.parseConfiguration((URL)configResource) : ConfigurationFactory.parseConfiguration();
        return configuration;
    }

    public static JCacheCacheManagerFactory getInstance() {
        return INSTANCE;
    }
}

