/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheConfiguration;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.Caching;
import javax.cache.InvalidConfigurationException;
import javax.cache.OptionalFeature;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.jcache.JCache;
import net.sf.ehcache.jcache.JCacheCacheLoaderAdapter;
import net.sf.ehcache.jcache.JCacheCacheWriterAdapter;

public class JCacheConfiguration
implements javax.cache.CacheConfiguration {
    private static final boolean DEFAULT_WRITE_THROUGH = false;
    private static final boolean DEFAULT_READ_THROUGH = false;
    private final AtomicBoolean writeThrough;
    private final AtomicBoolean readThrough;
    private volatile IsolationLevel isolationLevel;
    private volatile Mode transactionMode;
    private final CacheConfiguration.Duration[] timeToLive;
    private final CacheConfiguration cacheConfiguration;
    private JCache jcache;

    private JCacheConfiguration(boolean readThrough, boolean writeThrough, boolean storeByValue, boolean statisticsEnabled, IsolationLevel isolationLevel, Mode transactionMode, CacheConfiguration.Duration[] timeToLive) {
        this.readThrough = new AtomicBoolean(readThrough);
        this.writeThrough = new AtomicBoolean(writeThrough);
        this.cacheConfiguration = new CacheConfiguration();
        this.cacheConfiguration.setCopyOnRead(storeByValue);
        this.cacheConfiguration.setCopyOnWrite(storeByValue);
        this.cacheConfiguration.statistics(statisticsEnabled);
        this.isolationLevel = isolationLevel;
        this.transactionMode = transactionMode;
        this.timeToLive = timeToLive;
        for (CacheConfiguration.ExpiryType expiryType : CacheConfiguration.ExpiryType.values()) {
            this.setExpiry(expiryType, timeToLive[expiryType.ordinal()]);
        }
    }

    public JCacheConfiguration(CacheConfiguration ehCacheConfiguration) {
        this.readThrough = new AtomicBoolean(false);
        this.writeThrough = new AtomicBoolean(false);
        this.timeToLive = new CacheConfiguration.Duration[CacheConfiguration.ExpiryType.values().length];
        for (int i = 0; i < this.timeToLive.length; ++i) {
            this.timeToLive[i] = CacheConfiguration.Duration.ETERNAL;
        }
        this.cacheConfiguration = ehCacheConfiguration != null ? ehCacheConfiguration : new CacheConfiguration();
    }

    public boolean isReadThrough() {
        return this.readThrough.get();
    }

    void setJCache(JCache jcache) {
        this.jcache = jcache;
    }

    public CacheLoader getCacheLoader() {
        JCacheCacheLoaderAdapter cacheLoaderAdapter = this.jcache.getCacheLoaderAdapter();
        return cacheLoaderAdapter != null ? cacheLoaderAdapter.getJCacheCacheLoader() : null;
    }

    public CacheWriter getCacheWriter() {
        JCacheCacheWriterAdapter cacheWriterAdapter = this.jcache.getCacheWriterAdapter();
        return cacheWriterAdapter != null ? cacheWriterAdapter.getJCacheCacheWriter() : null;
    }

    public boolean isWriteThrough() {
        return this.writeThrough.get();
    }

    public boolean isStoreByValue() {
        return this.cacheConfiguration.isCopyOnRead() && this.cacheConfiguration.isCopyOnWrite();
    }

    public boolean isStatisticsEnabled() {
        return this.cacheConfiguration.getStatistics();
    }

    public void setStatisticsEnabled(boolean enableStatistics) {
        this.cacheConfiguration.statistics(enableStatistics);
    }

    public boolean isTransactionEnabled() {
        return this.isolationLevel != null && this.transactionMode != null;
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return this.isolationLevel != null ? this.isolationLevel : IsolationLevel.NONE;
    }

    public Mode getTransactionMode() {
        return this.transactionMode != null ? this.transactionMode : Mode.NONE;
    }

    private void setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration duration) {
        if (type == null) {
            throw new NullPointerException("ExpiryType can't be null");
        }
        this.timeToLive[type.ordinal()] = duration;
        if (type == CacheConfiguration.ExpiryType.ACCESSED) {
            this.cacheConfiguration.setTimeToIdleSeconds(duration.getTimeUnit().toSeconds(duration.getDurationAmount()));
        }
        if (type == CacheConfiguration.ExpiryType.MODIFIED) {
            this.cacheConfiguration.setTimeToLiveSeconds(duration.getTimeUnit().toSeconds(duration.getDurationAmount()));
        }
        this.timeToLive[type.ordinal()] = duration;
    }

    public CacheConfiguration.Duration getExpiry(CacheConfiguration.ExpiryType type) {
        CacheConfiguration.Duration duration = this.timeToLive[type.ordinal()];
        TimeUnit timeUnit = duration.getTimeUnit();
        Long ttl = duration.getDurationAmount();
        if (type == CacheConfiguration.ExpiryType.ACCESSED) {
            long timeToIdleSeconds = this.cacheConfiguration.getTimeToIdleSeconds();
            if (timeUnit.toSeconds(ttl) != timeToIdleSeconds) {
                duration = new CacheConfiguration.Duration(TimeUnit.SECONDS, timeToIdleSeconds);
            }
        }
        if (type == CacheConfiguration.ExpiryType.MODIFIED) {
            long timeToLiveSeconds = this.cacheConfiguration.getTimeToLiveSeconds();
            if (timeUnit.toSeconds(ttl) != timeToLiveSeconds) {
                duration = new CacheConfiguration.Duration(TimeUnit.SECONDS, timeToLiveSeconds);
            }
        }
        if (duration.getDurationAmount() == 0L) {
            return CacheConfiguration.Duration.ETERNAL;
        }
        return duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JCacheConfiguration that = (JCacheConfiguration)o;
        if (this.isolationLevel != that.isolationLevel) {
            return false;
        }
        if (this.isStatisticsEnabled() != that.isStatisticsEnabled()) {
            return false;
        }
        if (this.isStoreByValue() != that.isStoreByValue()) {
            return false;
        }
        if (this.isTransactionEnabled() != that.isTransactionEnabled()) {
            return false;
        }
        if (this.isReadThrough() != that.isReadThrough()) {
            return false;
        }
        if (this.isWriteThrough() != that.isWriteThrough()) {
            return false;
        }
        if (!Arrays.equals(this.timeToLive, that.timeToLive)) {
            return false;
        }
        if (this.transactionMode != that.transactionMode) {
            return false;
        }
        return this.writeThrough.get() == that.writeThrough.get();
    }

    public int hashCode() {
        int result = this.readThrough.hashCode();
        result = 31 * result + this.writeThrough.hashCode();
        result = 31 * result + (this.isStatisticsEnabled() ? 1 : 0);
        result = 31 * result + (this.isStoreByValue() ? 1 : 0);
        result = 31 * result + (this.isTransactionEnabled() ? 1 : 0);
        result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
        result = 31 * result + (this.transactionMode != null ? this.transactionMode.hashCode() : 0);
        result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.timeToLive);
        return result;
    }

    public CacheConfiguration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public static class Builder {
        private static final boolean DEFAULT_READ_THROUGH = false;
        private static final boolean DEFAULT_WRITE_THROUGH = false;
        private static final boolean DEFAULT_STORE_BY_VALUE = true;
        private static final boolean DEFAULT_STATISTICS_ENABLED = false;
        private static final CacheConfiguration.Duration DEFAULT_TIME_TO_LIVE = CacheConfiguration.Duration.ETERNAL;
        private static final IsolationLevel DEFAULT_TRANSACTION_ISOLATION_LEVEL = null;
        private static final Mode DEFAULT_TRANSACTION_MODE = null;
        private boolean readThrough = false;
        private boolean writeThrough = false;
        private boolean storeByValue = true;
        private boolean statisticsEnabled = false;
        private IsolationLevel isolationLevel = DEFAULT_TRANSACTION_ISOLATION_LEVEL;
        private Mode transactionMode = DEFAULT_TRANSACTION_MODE;
        private final CacheConfiguration.Duration[] timeToLive = new CacheConfiguration.Duration[CacheConfiguration.ExpiryType.values().length];

        public Builder() {
            for (int i = 0; i < this.timeToLive.length; ++i) {
                this.timeToLive[i] = CacheConfiguration.Duration.ETERNAL;
            }
        }

        public Builder setReadThrough(boolean readThrough) {
            this.readThrough = readThrough;
            return this;
        }

        public Builder setWriteThrough(boolean writeThrough) {
            this.writeThrough = writeThrough;
            return this;
        }

        public Builder setStoreByValue(boolean storeByValue) {
            if (!storeByValue && !Caching.isSupported((OptionalFeature)OptionalFeature.STORE_BY_REFERENCE)) {
                throw new InvalidConfigurationException("storeByValue");
            }
            this.storeByValue = storeByValue;
            return this;
        }

        public Builder setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
            return this;
        }

        public Builder setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration duration) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (duration == null) {
                throw new NullPointerException();
            }
            this.timeToLive[type.ordinal()] = duration;
            return this;
        }

        public Builder setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
            if (!Caching.isSupported((OptionalFeature)OptionalFeature.TRANSACTIONS)) {
                throw new InvalidConfigurationException("transactionsEnabled");
            }
            this.isolationLevel = isolationLevel;
            this.transactionMode = mode;
            return this;
        }

        public JCacheConfiguration build() {
            return new JCacheConfiguration(this.readThrough, this.writeThrough, this.storeByValue, this.statisticsEnabled, this.isolationLevel, this.transactionMode, this.timeToLive);
        }

        protected static CacheConfiguration.Duration[] defaultTimeToLive() {
            CacheConfiguration.Duration[] ttl = new CacheConfiguration.Duration[CacheConfiguration.ExpiryType.values().length];
            for (int i = 0; i < ttl.length; ++i) {
                ttl[i] = DEFAULT_TIME_TO_LIVE;
            }
            return ttl;
        }
    }
}

