/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;

public class JCacheCopyOnWriteStrategy
implements ReadWriteCopyStrategy<Element> {
    private ClassLoader deserializationClassLoader;

    public JCacheCopyOnWriteStrategy(ClassLoader deserializationClassLoader) {
        this.deserializationClassLoader = deserializationClassLoader;
    }

    public Element copyForWrite(Element value) {
        if (value == null) {
            return null;
        }
        Object elementValue = value.getObjectValue();
        Serializable elementKey = value.getKey();
        byte[] serializedValue = this.cloneObjectToByteArray(elementValue);
        return this.duplicateElementWithNewValue(value, serializedValue);
    }

    byte[] cloneObjectToByteArray(Object elementValue) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bout);
            oos.writeObject(elementValue);
        }
        catch (Exception e) {
            throw new CacheException("When configured copyOnRead or copyOnWrite, a Store will only accept Serializable values", (Throwable)e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {}
        }
        return bout.toByteArray();
    }

    public Element copyForRead(Element storedValue) {
        if (storedValue == null) {
            return null;
        }
        Object deserializedElement = this.deserializeByteArrayToObject((byte[])storedValue.getValue());
        return this.duplicateElementWithNewValue(storedValue, deserializedElement);
    }

    Object deserializeByteArrayToObject(byte[] bytes) {
        Object deserializedElement;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        PreferredClassLoaderObjectInputSteam ois = null;
        try {
            ois = new PreferredClassLoaderObjectInputSteam(bin, this.deserializationClassLoader);
            deserializedElement = ois.readObject();
        }
        catch (Exception e) {
            throw new CacheException("When configured copyOnRead or copyOnWrite, a Store will only accept Serializable values", (Throwable)e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {}
        }
        return deserializedElement;
    }

    protected Element duplicateElementWithNewValue(Element element, Object newValue) {
        return new Element((Object)element.getKey(), newValue, element.getVersion(), element.getCreationTime(), element.getLastAccessTime(), element.getHitCount(), element.usesCacheDefaultLifespan(), element.getTimeToLive(), element.getTimeToIdle(), element.getLastUpdateTime());
    }

    private static class PreferredClassLoaderObjectInputSteam
    extends ObjectInputStream {
        private ClassLoader classLoader;

        public PreferredClassLoaderObjectInputSteam(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), false, this.classLoader);
        }
    }
}

