/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.EhcacheDecoratorAdapter;
import net.sf.ehcache.jcache.JCache;

public class JCacheEhcacheDecorator<K, V>
extends EhcacheDecoratorAdapter {
    private JCache<K, V> jcache;

    public JCacheEhcacheDecorator(Ehcache underlyingCache) {
        super(underlyingCache);
    }

    public void setJcache(JCache<K, V> jcache) {
        this.jcache = jcache;
    }

    public JCacheEhcacheDecorator(Ehcache underlyingCache, JCache<K, V> jcache) {
        super(underlyingCache);
        this.jcache = jcache;
    }

    public void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        Element newElement = element;
        if (this.jcache.getConfiguration().isStoreByValue()) {
            Serializable key = this.cloneKeyValue(element.getKey());
            newElement = this.duplicateElementWithNewKey(element, key);
        }
        super.put(newElement);
    }

    protected Element duplicateElementWithNewKey(Element element, Object newKey) {
        return new Element(newKey, (Object)element.getValue(), element.getVersion(), element.getCreationTime(), element.getLastAccessTime(), element.getHitCount(), element.usesCacheDefaultLifespan(), element.getTimeToLive(), element.getTimeToIdle(), element.getLastUpdateTime());
    }

    private K cloneKeyValue(K key) {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(key);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            return (K)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Unable to clone Key", (Throwable)e);
        }
        catch (IOException e) {
            throw new CacheException("Unable to clone key", (Throwable)e);
        }
    }

    public JCache<K, V> getJcache() {
        return this.jcache;
    }
}

