/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.jcache.JCache;
import net.sf.ehcache.jcache.JCacheEhcacheDecorator;
import net.sf.ehcache.jcache.JCacheEntryEventAdapter;

public class JCacheListenerAdapter<K, V>
implements CacheEventListener {
    private CacheEntryListener<K, V> cacheListener;
    private boolean removedListener;
    private boolean createdListener;
    private boolean updatedListener;
    private boolean expiredListener;

    public JCacheListenerAdapter(CacheEntryListener<K, V> cacheListener) {
        this.cacheListener = cacheListener;
        this.removedListener = this.implementsMethods(CacheEntryRemovedListener.class);
        this.createdListener = this.implementsMethods(CacheEntryCreatedListener.class);
        this.updatedListener = this.implementsMethods(CacheEntryUpdatedListener.class);
        this.expiredListener = this.implementsMethods(CacheEntryExpiredListener.class);
    }

    private boolean implementsMethods(Class cls) {
        return cls.isAssignableFrom(this.cacheListener.getClass());
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.removedListener && element != null) {
            ((CacheEntryRemovedListener)this.cacheListener).entryRemoved(new JCacheEntryEventAdapter<K, V>(this.fromEhcache(cache), element));
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.createdListener && element != null) {
            ((CacheEntryCreatedListener)this.cacheListener).entryCreated(new JCacheEntryEventAdapter<K, V>(this.fromEhcache(cache), element));
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.updatedListener && element != null) {
            ((CacheEntryCreatedListener)this.cacheListener).entryCreated(new JCacheEntryEventAdapter<K, V>(this.fromEhcache(cache), element));
        }
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        if (this.expiredListener && element != null) {
            ((CacheEntryExpiredListener)this.cacheListener).entryExpired(new JCacheEntryEventAdapter<K, V>(this.fromEhcache(cache), element));
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        if (this.expiredListener && element != null) {
            ((CacheEntryExpiredListener)this.cacheListener).entryExpired(new JCacheEntryEventAdapter<K, V>(this.fromEhcache(cache), element));
        }
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected JCache<K, V> fromEhcache(Ehcache ehcache) {
        if (ehcache instanceof JCacheEhcacheDecorator) {
            return ((JCacheEhcacheDecorator)ehcache).getJcache();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JCacheListenerAdapter that = (JCacheListenerAdapter)o;
        if (this.createdListener != that.createdListener) {
            return false;
        }
        if (this.expiredListener != that.expiredListener) {
            return false;
        }
        if (this.removedListener != that.removedListener) {
            return false;
        }
        if (this.updatedListener != that.updatedListener) {
            return false;
        }
        return this.cacheListener.equals(that.cacheListener);
    }

    public int hashCode() {
        int result = this.cacheListener.hashCode();
        result = 31 * result + (this.removedListener ? 1 : 0);
        result = 31 * result + (this.createdListener ? 1 : 0);
        result = 31 * result + (this.updatedListener ? 1 : 0);
        result = 31 * result + (this.expiredListener ? 1 : 0);
        return result;
    }
}

