/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.Caching;
import javax.cache.OptionalFeature;
import javax.cache.Status;
import javax.cache.event.CacheEntryListener;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;
import javax.transaction.UserTransaction;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.jcache.JCache;
import net.sf.ehcache.jcache.JCacheEhcacheDecorator;
import net.sf.ehcache.jcache.JCacheStatusAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheManager
implements javax.cache.CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheManager.class);
    private final HashMap<String, Cache<?, ?>> caches = new HashMap();
    private final HashSet<Class<?>> immutableClasses = new HashSet();
    private final ClassLoader classLoader;
    private final CacheManager ehcacheManager;

    public JCacheManager(String name, CacheManager ehcacheManager, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("No classLoader specified");
        }
        if (name == null) {
            throw new NullPointerException("No name specified");
        }
        this.classLoader = classLoader;
        this.ehcacheManager = ehcacheManager;
        this.ehcacheManager.setName(name);
    }

    public CacheManager getEhcacheManager() {
        return this.ehcacheManager;
    }

    public String getName() {
        return this.ehcacheManager.getName();
    }

    public Status getStatus() {
        return JCacheStatusAdapter.adaptStatus(this.ehcacheManager.getStatus());
    }

    public <K, V> CacheBuilder<K, V> createCacheBuilder(String cacheName) {
        return new JCacheBuilder(cacheName, this, this.classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName) {
        if (this.getStatus() != Status.STARTED) {
            throw new IllegalStateException("CacheManager must be started before retrieving a cache");
        }
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            if (this.caches.containsKey(cacheName)) {
                return this.caches.get(cacheName);
            }
            Ehcache ehcache = this.ehcacheManager.getEhcache(cacheName);
            if (ehcache == null) {
                return null;
            }
            JCacheEhcacheDecorator decoratedCache = new JCacheEhcacheDecorator(ehcache);
            JCache cache = new JCache((Ehcache)decoratedCache, this, this.classLoader);
            decoratedCache.setJcache(cache);
            this.caches.put(cacheName, cache);
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Cache<?, ?>> getCaches() {
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            HashSet cacheSet = new HashSet(this.caches.size(), 1.0f);
            for (Cache<?, ?> cache : this.caches.values()) {
                cacheSet.add(cache);
            }
            return Collections.unmodifiableSet(cacheSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCache(String cacheName) {
        Cache<?, ?> oldCache;
        if (this.getStatus() != Status.STARTED) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            oldCache = this.caches.remove(cacheName);
        }
        if (oldCache != null) {
            oldCache.stop();
        }
        return oldCache != null;
    }

    public UserTransaction getUserTransaction() {
        throw new UnsupportedOperationException();
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return Caching.isSupported((OptionalFeature)optionalFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.getStatus() != Status.STARTED) {
            throw new IllegalStateException();
        }
        Cloneable cloneable = this.immutableClasses;
        synchronized (cloneable) {
            this.immutableClasses.clear();
        }
        cloneable = this.caches;
        synchronized (cloneable) {
            this.ehcacheManager.shutdown();
            this.caches.clear();
        }
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwapping to " + cls + " is not a supported by this implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInternal(JCache cache) {
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            if (this.caches.containsKey(cache.getName())) {
                this.ehcacheManager.removeCache(cache.getName());
            }
            if (this.ehcacheManager.getEhcache(cache.getName()) != null) {
                this.ehcacheManager.removeCache(cache.getName());
            }
            this.caches.remove(cache.getName());
            this.caches.put(cache.getName(), cache);
            this.ehcacheManager.addCache(new JCacheEhcacheDecorator(cache.getEhcache(), cache));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JCacheManager that = (JCacheManager)o;
        if (this.caches != null ? !this.caches.equals(that.caches) : that.caches != null) {
            return false;
        }
        if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
            return false;
        }
        if (this.ehcacheManager != null ? !this.ehcacheManager.equals(that.ehcacheManager) : that.ehcacheManager != null) {
            return false;
        }
        return !(this.immutableClasses != null ? !this.immutableClasses.equals(that.immutableClasses) : that.immutableClasses != null);
    }

    public int hashCode() {
        int result = this.caches != null ? this.caches.hashCode() : 0;
        result = 31 * result + (this.immutableClasses != null ? this.immutableClasses.hashCode() : 0);
        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
        result = 31 * result + (this.ehcacheManager != null ? this.ehcacheManager.hashCode() : 0);
        return result;
    }

    private class JCacheBuilder<K, V>
    implements CacheBuilder<K, V> {
        private final JCache.Builder<K, V> cacheBuilder;
        private Pattern namePattern = Pattern.compile("\\S+");

        public JCacheBuilder(String cacheName, JCacheManager jCacheManager2, ClassLoader cl) {
            if (cacheName == null) {
                throw new NullPointerException("Cache name cannot be null");
            }
            if (!this.namePattern.matcher(cacheName).find()) {
                throw new IllegalArgumentException("Cache name must contain one or more non-whitespace characters");
            }
            this.cacheBuilder = new JCache.Builder(cacheName, jCacheManager2, cl);
        }

        public JCache<K, V> build() {
            Cache cache = this.cacheBuilder.build();
            JCacheManager.this.addInternal((JCache)cache);
            return cache;
        }

        public CacheBuilder<K, V> setCacheLoader(CacheLoader<K, ? extends V> cacheLoader) {
            this.cacheBuilder.setCacheLoader((CacheLoader)cacheLoader);
            return this;
        }

        public CacheBuilder<K, V> setCacheWriter(CacheWriter<? super K, ? super V> cacheWriter) {
            this.cacheBuilder.setCacheWriter(cacheWriter);
            return this;
        }

        public CacheBuilder<K, V> registerCacheEntryListener(CacheEntryListener<K, V> listener) {
            this.cacheBuilder.registerCacheEntryListener(listener);
            return this;
        }

        public CacheBuilder<K, V> setStoreByValue(boolean storeByValue) {
            this.cacheBuilder.setStoreByValue(storeByValue);
            return this;
        }

        public CacheBuilder<K, V> setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
            this.cacheBuilder.setTransactionEnabled(isolationLevel, mode);
            return this;
        }

        public CacheBuilder<K, V> setStatisticsEnabled(boolean enableStatistics) {
            this.cacheBuilder.setStatisticsEnabled(enableStatistics);
            return this;
        }

        public CacheBuilder<K, V> setReadThrough(boolean readThrough) {
            this.cacheBuilder.setReadThrough(readThrough);
            return this;
        }

        public CacheBuilder<K, V> setWriteThrough(boolean writeThrough) {
            this.cacheBuilder.setWriteThrough(writeThrough);
            return this;
        }

        public CacheBuilder<K, V> setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration timeToLive) {
            this.cacheBuilder.setExpiry(type, timeToLive);
            return this;
        }
    }
}

